/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.util.ConvertingIterable;
import com.mware.ge.values.storable.Value;
import java.util.Iterator;

public interface GeObject
extends Comparable {
    public Object getId();

    public Iterable<Property> getProperties();

    default public Property getProperty(String name) {
        Iterator<Property> propertiesWithName = this.getProperties(name).iterator();
        if (propertiesWithName.hasNext()) {
            return propertiesWithName.next();
        }
        return null;
    }

    default public Value getPropertyValue(String name) {
        return this.getPropertyValue(name, 0);
    }

    default public Property getProperty(String key, String name) {
        return this.getProperty(key, name, null);
    }

    public Property getProperty(String var1, String var2, Visibility var3);

    public Property getProperty(String var1, Visibility var2);

    public Iterable<Property> getProperties(String var1);

    public Iterable<Property> getProperties(String var1, String var2);

    default public Iterable<Value> getPropertyValues(String name) {
        return new ConvertingIterable<Property, Value>(this.getProperties(name)){

            @Override
            protected Value convert(Property o) {
                return o.getValue();
            }
        };
    }

    default public Iterable<Value> getPropertyValues(String key, String name) {
        return new ConvertingIterable<Property, Value>(this.getProperties(key, name)){

            @Override
            protected Value convert(Property p) {
                return p.getValue();
            }
        };
    }

    default public Value getPropertyValue(String key, String name) {
        return this.getPropertyValue(key, name, 0);
    }

    default public Value getPropertyValue(String name, int index) {
        Iterator<Value> values = this.getPropertyValues(name).iterator();
        while (values.hasNext() && index >= 0) {
            Value v = values.next();
            if (index == 0) {
                return v;
            }
            --index;
        }
        return null;
    }

    default public Value getPropertyValue(String key, String name, int index) {
        Iterator<Value> values = this.getPropertyValues(key, name).iterator();
        while (values.hasNext() && index >= 0) {
            Value v = values.next();
            if (index == 0) {
                return v;
            }
            --index;
        }
        return null;
    }
}

