/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mware.ge.Authorizations;
import com.mware.ge.DefinePropertyBuilder;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.EdgeBuilder;
import com.mware.ge.EdgeBuilderByVertexId;
import com.mware.ge.EdgeInfo;
import com.mware.ge.Element;
import com.mware.ge.ElementBuilder;
import com.mware.ge.ElementFilter;
import com.mware.ge.ElementId;
import com.mware.ge.ElementType;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.ExtendedDataRowId;
import com.mware.ge.FetchHints;
import com.mware.ge.FetchHintsBuilder;
import com.mware.ge.FindPathOptions;
import com.mware.ge.GeException;
import com.mware.ge.GraphMetadataEntry;
import com.mware.ge.GraphVisitor;
import com.mware.ge.IdRange;
import com.mware.ge.Path;
import com.mware.ge.ProgressCallback;
import com.mware.ge.Property;
import com.mware.ge.PropertyDefinition;
import com.mware.ge.RelatedEdge;
import com.mware.ge.RelatedEdgeImpl;
import com.mware.ge.SearchIndexSecurityGranularity;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.Visibility;
import com.mware.ge.event.GraphEventListener;
import com.mware.ge.id.IdGenerator;
import com.mware.ge.id.IdentityNameSubstitutionStrategy;
import com.mware.ge.id.NameSubstitutionStrategy;
import com.mware.ge.metric.GeMetricRegistry;
import com.mware.ge.mutation.ElementMutation;
import com.mware.ge.query.GraphQuery;
import com.mware.ge.query.MultiVertexQuery;
import com.mware.ge.query.SimilarToGraphQuery;
import com.mware.ge.util.FilterIterable;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.util.LookAheadIterable;
import com.mware.ge.util.Preconditions;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Graph {
    default public Vertex addVertex(Visibility visibility, Authorizations authorizations, String conceptType) {
        return this.prepareVertex(visibility, conceptType).save(authorizations);
    }

    default public Vertex addVertex(String vertexId, Visibility visibility, Authorizations authorizations, String conceptType) {
        return this.prepareVertex(vertexId, visibility, conceptType).save(authorizations);
    }

    default public Iterable<Vertex> addVertices(Iterable<ElementBuilder<Vertex>> vertices, Authorizations authorizations) {
        ArrayList<Vertex> addedVertices = new ArrayList<Vertex>();
        for (ElementBuilder<Vertex> vertexBuilder : vertices) {
            addedVertices.add(vertexBuilder.save(authorizations));
        }
        return addedVertices;
    }

    default public VertexBuilder prepareVertex(Visibility visibility, String conceptType) {
        return this.prepareVertex(this.getIdGenerator().nextId(), null, visibility, conceptType);
    }

    default public VertexBuilder prepareVertex(Long timestamp, Visibility visibility, String conceptType) {
        return this.prepareVertex(this.getIdGenerator().nextId(), timestamp, visibility, conceptType);
    }

    default public VertexBuilder prepareVertex(String vertexId, Visibility visibility, String conceptType) {
        return this.prepareVertex(vertexId, null, visibility, conceptType);
    }

    public VertexBuilder prepareVertex(String var1, Long var2, Visibility var3, String var4);

    default public boolean doesVertexExist(String vertexId, Authorizations authorizations) {
        return this.getVertex(vertexId, FetchHints.NONE, authorizations) != null;
    }

    default public Element getElement(ElementId elementId, Authorizations authorizations) {
        return this.getElement(elementId, this.getDefaultFetchHints(), authorizations);
    }

    default public Element getElement(ElementId elementId, FetchHints fetchHints, Authorizations authorizations) {
        Element element;
        if (elementId instanceof Element && (element = (Element)elementId).getFetchHints().hasFetchHints(fetchHints)) {
            return element;
        }
        switch (elementId.getElementType()) {
            case VERTEX: {
                return this.getVertex(elementId.getId(), fetchHints, authorizations);
            }
            case EDGE: {
                return this.getEdge(elementId.getId(), fetchHints, authorizations);
            }
        }
        throw new GeException("Unhandled element type: " + (Object)((Object)elementId.getElementType()));
    }

    default public void deleteElements(Stream<? extends ElementId> elementIds, Authorizations authorizations) {
        elementIds.forEach(elementId -> this.deleteElement((ElementId)elementId, authorizations));
    }

    default public void deleteElement(ElementId elementId, Authorizations authorizations) {
        Preconditions.checkNotNull(elementId, "element is required");
        switch (elementId.getElementType()) {
            case VERTEX: {
                if (elementId instanceof Vertex) {
                    this.deleteVertex((Vertex)elementId, authorizations);
                    break;
                }
                this.deleteVertex(elementId.getId(), authorizations);
                break;
            }
            case EDGE: {
                if (elementId instanceof Edge) {
                    this.deleteEdge((Edge)elementId, authorizations);
                    break;
                }
                this.deleteEdge(elementId.getId(), authorizations);
                break;
            }
            default: {
                throw new GeException("Unhandled element type: " + (Object)((Object)elementId.getElementType()));
            }
        }
    }

    default public Vertex getVertex(String vertexId, Authorizations authorizations) {
        return this.getVertex(vertexId, this.getDefaultFetchHints(), authorizations);
    }

    default public Vertex getVertex(String vertexId, FetchHints fetchHints, Authorizations authorizations) {
        return this.getVertex(vertexId, fetchHints, null, authorizations);
    }

    default public Vertex getVertex(String vertexId, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        if (null == fetchHints) {
            return this.getVertex(vertexId, this.getDefaultFetchHints(), endTime, authorizations);
        }
        for (Vertex vertex : this.getVertices(fetchHints, endTime, authorizations)) {
            if (!((String)vertex.getId()).equals(vertexId)) continue;
            return vertex;
        }
        return null;
    }

    default public Iterable<Vertex> getVerticesWithPrefix(String vertexIdPrefix, Authorizations authorizations) {
        return this.getVerticesWithPrefix(vertexIdPrefix, this.getDefaultFetchHints(), authorizations);
    }

    default public Iterable<Vertex> getVerticesWithPrefix(String vertexIdPrefix, FetchHints fetchHints, Authorizations authorizations) {
        return this.getVerticesWithPrefix(vertexIdPrefix, fetchHints, null, authorizations);
    }

    default public Iterable<Vertex> getVerticesWithPrefix(final String vertexIdPrefix, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        Iterable<Vertex> vertices = this.getVertices(fetchHints, endTime, authorizations);
        return new FilterIterable<Vertex>(vertices){

            @Override
            protected boolean isIncluded(Vertex v) {
                return ((String)v.getId()).startsWith(vertexIdPrefix);
            }
        };
    }

    default public Iterable<Vertex> getVerticesInRange(IdRange idRange, Authorizations authorizations) {
        return this.getVerticesInRange(idRange, this.getDefaultFetchHints(), authorizations);
    }

    default public Iterable<Vertex> getVerticesInRange(IdRange idRange, FetchHints fetchHints, Authorizations authorizations) {
        return this.getVerticesInRange(idRange, fetchHints, null, authorizations);
    }

    default public Iterable<Vertex> getVerticesInRange(final IdRange idRange, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        Iterable<Vertex> vertices = this.getVertices(fetchHints, endTime, authorizations);
        return new FilterIterable<Vertex>(vertices){

            @Override
            protected boolean isIncluded(Vertex v) {
                return idRange.isInRange(v.getId());
            }
        };
    }

    default public Iterable<Vertex> getVertices(Authorizations authorizations) {
        return this.getVertices(this.getDefaultFetchHints(), authorizations);
    }

    default public Iterable<Vertex> getVertices(FetchHints fetchHints, Authorizations authorizations) {
        return this.getVertices(fetchHints, null, authorizations);
    }

    public Iterable<String> getVertexIds(Authorizations var1);

    public Iterable<Vertex> getVertices(FetchHints var1, Long var2, Authorizations var3);

    default public Map<String, Boolean> doVerticesExist(Iterable<String> ids, Authorizations authorizations) {
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        for (String id : ids) {
            results.put(id, false);
        }
        for (Vertex vertex : this.getVertices(ids, FetchHints.NONE, authorizations)) {
            results.put((String)vertex.getId(), true);
        }
        return results;
    }

    default public Iterable<Vertex> getVertices(Iterable<String> ids, Authorizations authorizations) {
        return this.getVertices(ids, this.getDefaultFetchHints(), authorizations);
    }

    default public Iterable<Vertex> getVertices(Iterable<String> ids, FetchHints fetchHints, Authorizations authorizations) {
        return this.getVertices(ids, fetchHints, null, authorizations);
    }

    default public Iterable<Vertex> getVertices(final Iterable<String> ids, final FetchHints fetchHints, final Long endTime, final Authorizations authorizations) {
        return new LookAheadIterable<String, Vertex>(){

            @Override
            protected boolean isIncluded(String src, Vertex vertex) {
                return vertex != null;
            }

            @Override
            protected Vertex convert(String id) {
                return Graph.this.getVertex(id, fetchHints, endTime, authorizations);
            }

            @Override
            protected Iterator<String> createIterator() {
                return Sets.newHashSet((Iterable)ids).iterator();
            }
        };
    }

    default public List<Vertex> getVerticesInOrder(Iterable<String> ids, Authorizations authorizations) {
        return this.getVerticesInOrder(ids, this.getDefaultFetchHints(), authorizations);
    }

    default public List<Vertex> getVerticesInOrder(Iterable<String> ids, FetchHints fetchHints, Authorizations authorizations) {
        List<String> vertexIds = IterableUtils.toList(ids);
        List<Vertex> vertices = IterableUtils.toList(this.getVertices(vertexIds, authorizations));
        vertices.sort((v1, v2) -> {
            Integer i1 = vertexIds.indexOf(v1.getId());
            Integer i2 = vertexIds.indexOf(v2.getId());
            return i1.compareTo(i2);
        });
        return vertices;
    }

    public void deleteVertex(Vertex var1, Authorizations var2);

    default public void deleteVertex(String vertexId, Authorizations authorizations) {
        Vertex vertex = this.getVertex(vertexId, authorizations);
        Preconditions.checkNotNull(vertex, "Could not find vertex to delete with id: " + vertexId);
        this.deleteVertex(vertex, authorizations);
    }

    default public void softDeleteVertex(Vertex vertex, Authorizations authorizations) {
        this.softDeleteVertex(vertex, null, authorizations);
    }

    public void softDeleteVertex(Vertex var1, Long var2, Authorizations var3);

    default public void softDeleteVertex(String vertexId, Authorizations authorizations) {
        Vertex vertex = this.getVertex(vertexId, authorizations);
        Preconditions.checkNotNull(vertex, "Could not find vertex to soft delete with id: " + vertexId);
        this.softDeleteVertex(vertex, null, authorizations);
    }

    default public void softDeleteVertex(String vertexId, Long timestamp, Authorizations authorizations) {
        Vertex vertex = this.getVertex(vertexId, authorizations);
        Preconditions.checkNotNull(vertex, "Could not find vertex to soft delete with id: " + vertexId);
        this.softDeleteVertex(vertex, timestamp, authorizations);
    }

    default public Edge addEdge(Vertex outVertex, Vertex inVertex, String label, Visibility visibility, Authorizations authorizations) {
        return this.prepareEdge(outVertex, inVertex, label, visibility).save(authorizations);
    }

    default public Edge addEdge(String edgeId, Vertex outVertex, Vertex inVertex, String label, Visibility visibility, Authorizations authorizations) {
        return this.prepareEdge(edgeId, outVertex, inVertex, label, visibility).save(authorizations);
    }

    default public Edge addEdge(String outVertexId, String inVertexId, String label, Visibility visibility, Authorizations authorizations) {
        return this.prepareEdge(outVertexId, inVertexId, label, visibility).save(authorizations);
    }

    default public Edge addEdge(String edgeId, String outVertexId, String inVertexId, String label, Visibility visibility, Authorizations authorizations) {
        return this.prepareEdge(edgeId, outVertexId, inVertexId, label, visibility).save(authorizations);
    }

    default public EdgeBuilder prepareEdge(Vertex outVertex, Vertex inVertex, String label, Visibility visibility) {
        return this.prepareEdge(this.getIdGenerator().nextId(), outVertex, inVertex, label, visibility);
    }

    default public EdgeBuilder prepareEdge(String edgeId, Vertex outVertex, Vertex inVertex, String label, Visibility visibility) {
        return this.prepareEdge(edgeId, outVertex, inVertex, label, null, visibility);
    }

    public EdgeBuilder prepareEdge(String var1, Vertex var2, Vertex var3, String var4, Long var5, Visibility var6);

    default public EdgeBuilderByVertexId prepareEdge(String outVertexId, String inVertexId, String label, Visibility visibility) {
        return this.prepareEdge(this.getIdGenerator().nextId(), outVertexId, inVertexId, label, visibility);
    }

    default public EdgeBuilderByVertexId prepareEdge(String edgeId, String outVertexId, String inVertexId, String label, Visibility visibility) {
        return this.prepareEdge(edgeId, outVertexId, inVertexId, label, null, visibility);
    }

    public EdgeBuilderByVertexId prepareEdge(String var1, String var2, String var3, String var4, Long var5, Visibility var6);

    default public boolean doesEdgeExist(String edgeId, Authorizations authorizations) {
        return this.getEdge(edgeId, FetchHints.NONE, authorizations) != null;
    }

    default public Edge getEdge(String edgeId, Authorizations authorizations) {
        return this.getEdge(edgeId, this.getDefaultFetchHints(), authorizations);
    }

    default public Edge getEdge(String edgeId, FetchHints fetchHints, Authorizations authorizations) {
        return this.getEdge(edgeId, fetchHints, null, authorizations);
    }

    default public Edge getEdge(String edgeId, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        if (null == fetchHints) {
            return this.getEdge(edgeId, this.getDefaultFetchHints(), endTime, authorizations);
        }
        for (Edge edge : this.getEdges(fetchHints, endTime, authorizations)) {
            if (!((String)edge.getId()).equals(edgeId)) continue;
            return edge;
        }
        return null;
    }

    default public Iterable<Edge> getEdges(Authorizations authorizations) {
        return this.getEdges(this.getDefaultFetchHints(), authorizations);
    }

    default public Iterable<Edge> getEdges(FetchHints fetchHints, Authorizations authorizations) {
        return this.getEdges(fetchHints, null, authorizations);
    }

    public Iterable<Edge> getEdges(FetchHints var1, Long var2, Authorizations var3);

    default public Iterable<Edge> getEdgesInRange(IdRange idRange, Authorizations authorizations) {
        return this.getEdgesInRange(idRange, this.getDefaultFetchHints(), authorizations);
    }

    default public Iterable<Edge> getEdgesInRange(IdRange idRange, FetchHints fetchHints, Authorizations authorizations) {
        return this.getEdgesInRange(idRange, fetchHints, null, authorizations);
    }

    default public Iterable<Edge> getEdgesInRange(final IdRange idRange, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        Iterable<Edge> edges = this.getEdges(fetchHints, endTime, authorizations);
        return new FilterIterable<Edge>(edges){

            @Override
            protected boolean isIncluded(Edge e) {
                return idRange.isInRange(e.getId());
            }
        };
    }

    public Iterable<String> filterEdgeIdsByAuthorization(Iterable<String> var1, String var2, EnumSet<ElementFilter> var3, Authorizations var4);

    public Iterable<String> filterVertexIdsByAuthorization(Iterable<String> var1, String var2, EnumSet<ElementFilter> var3, Authorizations var4);

    default public Map<String, Boolean> doEdgesExist(Iterable<String> ids, Authorizations authorizations) {
        return this.doEdgesExist(ids, null, authorizations);
    }

    default public Map<String, Boolean> doEdgesExist(Iterable<String> ids, Long endTime, Authorizations authorizations) {
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        for (String id : ids) {
            results.put(id, false);
        }
        for (Edge edge : this.getEdges(ids, FetchHints.NONE, endTime, authorizations)) {
            results.put((String)edge.getId(), true);
        }
        return results;
    }

    default public Iterable<Edge> getEdges(Iterable<String> ids, Authorizations authorizations) {
        return this.getEdges(ids, this.getDefaultFetchHints(), authorizations);
    }

    default public Iterable<Edge> getEdges(Iterable<String> ids, FetchHints fetchHints, Authorizations authorizations) {
        return this.getEdges(ids, fetchHints, null, authorizations);
    }

    default public Iterable<Edge> getEdges(final Iterable<String> ids, final FetchHints fetchHints, final Long endTime, final Authorizations authorizations) {
        return new LookAheadIterable<String, Edge>(){

            @Override
            protected boolean isIncluded(String src, Edge edge) {
                return edge != null;
            }

            @Override
            protected Edge convert(String id) {
                return Graph.this.getEdge(id, fetchHints, endTime, authorizations);
            }

            @Override
            protected Iterator<String> createIterator() {
                return Sets.newHashSet((Iterable)ids).iterator();
            }
        };
    }

    @Deprecated
    default public Iterable<String> findRelatedEdges(Iterable<String> vertexIds, Authorizations authorizations) {
        return this.findRelatedEdgeIds(vertexIds, authorizations);
    }

    @Deprecated
    default public Iterable<String> findRelatedEdges(Iterable<String> vertexIds, Long endTime, Authorizations authorizations) {
        return this.findRelatedEdgeIds(vertexIds, endTime, authorizations);
    }

    default public Iterable<String> findRelatedEdgeIdsForVertices(Iterable<Vertex> verticesIterable, Authorizations authorizations) {
        ArrayList<String> results = new ArrayList<String>();
        List<Vertex> vertices = IterableUtils.toList(verticesIterable);
        for (Vertex outVertex : vertices) {
            if (outVertex == null) {
                throw new GeException("verticesIterable cannot have null values");
            }
            Iterable<EdgeInfo> edgeInfos = outVertex.getEdgeInfos(Direction.OUT, authorizations);
            for (EdgeInfo edgeInfo : edgeInfos) {
                for (Vertex inVertex : vertices) {
                    if (edgeInfo.getVertexId() == null || !edgeInfo.getVertexId().equals(inVertex.getId())) continue;
                    results.add(edgeInfo.getEdgeId());
                }
            }
        }
        return results;
    }

    default public Iterable<String> findRelatedEdgeIds(Iterable<String> vertexIds, Authorizations authorizations) {
        return this.findRelatedEdgeIds(vertexIds, null, authorizations);
    }

    default public Iterable<String> findRelatedEdgeIds(Iterable<String> vertexIds, Long endTime, Authorizations authorizations) {
        FetchHints fetchHints = new FetchHintsBuilder().setIncludeOutEdgeRefs(true).build();
        return this.findRelatedEdgeIdsForVertices(this.getVertices(vertexIds, fetchHints, endTime, authorizations), authorizations);
    }

    default public Iterable<RelatedEdge> findRelatedEdgeSummaryForVertices(Iterable<Vertex> verticesIterable, Authorizations authorizations) {
        ArrayList<RelatedEdge> results = new ArrayList<RelatedEdge>();
        List<Vertex> vertices = IterableUtils.toList(verticesIterable);
        for (Vertex outVertex : vertices) {
            Iterable<EdgeInfo> edgeInfos = outVertex.getEdgeInfos(Direction.OUT, authorizations);
            for (EdgeInfo edgeInfo : edgeInfos) {
                for (Vertex inVertex : vertices) {
                    if (!edgeInfo.getVertexId().equals(inVertex.getId())) continue;
                    results.add(new RelatedEdgeImpl(edgeInfo.getEdgeId(), edgeInfo.getLabel(), (String)outVertex.getId(), (String)inVertex.getId()));
                }
            }
        }
        return results;
    }

    default public Iterable<RelatedEdge> findRelatedEdgeSummary(Iterable<String> vertexIds, Authorizations authorizations) {
        return this.findRelatedEdgeSummary(vertexIds, null, authorizations);
    }

    default public Iterable<RelatedEdge> findRelatedEdgeSummary(Iterable<String> vertexIds, Long endTime, Authorizations authorizations) {
        FetchHints fetchHints = new FetchHintsBuilder().setIncludeOutEdgeRefs(true).build();
        return this.findRelatedEdgeSummaryForVertices(this.getVertices(vertexIds, fetchHints, endTime, authorizations), authorizations);
    }

    public void deleteEdge(Edge var1, Authorizations var2);

    default public void deleteEdge(String edgeId, Authorizations authorizations) {
        Edge edge = this.getEdge(edgeId, authorizations);
        Preconditions.checkNotNull(edge, "Could not find edge to delete with id: " + edgeId);
        this.deleteEdge(edge, authorizations);
    }

    default public void softDeleteEdge(Edge edge, Authorizations authorizations) {
        this.softDeleteEdge(edge, null, authorizations);
    }

    public void softDeleteEdge(Edge var1, Long var2, Authorizations var3);

    default public void softDeleteEdge(String edgeId, Authorizations authorizations) {
        Edge edge = this.getEdge(edgeId, authorizations);
        Preconditions.checkNotNull(edge, "Could not find edge to soft delete with id: " + edgeId);
        this.softDeleteEdge(edge, null, authorizations);
    }

    default public void softDeleteEdge(String edgeId, Long timestamp, Authorizations authorizations) {
        Edge edge = this.getEdge(edgeId, authorizations);
        Preconditions.checkNotNull(edge, "Could not find edge to soft delete with id: " + edgeId);
        this.softDeleteEdge(edge, timestamp, authorizations);
    }

    public GraphQuery query(String var1, Authorizations var2);

    public GraphQuery query(Authorizations var1);

    public MultiVertexQuery query(String[] var1, String var2, Authorizations var3);

    public MultiVertexQuery query(String[] var1, Authorizations var2);

    public boolean isQuerySimilarToTextSupported();

    public SimilarToGraphQuery querySimilarTo(String[] var1, String var2, Authorizations var3);

    public void flush();

    public void shutdown();

    @Deprecated
    default public Iterable<Path> findPaths(String sourceVertexId, String destVertexId, int maxHops, Authorizations authorizations) {
        return this.findPaths(sourceVertexId, destVertexId, null, maxHops, authorizations);
    }

    @Deprecated
    default public Iterable<Path> findPaths(String sourceVertexId, String destVertexId, String[] labels, int maxHops, Authorizations authorizations) {
        return this.findPaths(sourceVertexId, destVertexId, labels, maxHops, null, authorizations);
    }

    @Deprecated
    default public Iterable<Path> findPaths(String sourceVertexId, String destVertexId, int maxHops, ProgressCallback progressCallback, Authorizations authorizations) {
        return this.findPaths(sourceVertexId, destVertexId, null, maxHops, progressCallback, authorizations);
    }

    @Deprecated
    default public Iterable<Path> findPaths(String sourceVertexId, String destVertexId, String[] labels, int maxHops, ProgressCallback progressCallback, Authorizations authorizations) {
        FindPathOptions options = new FindPathOptions(sourceVertexId, destVertexId, maxHops);
        options.setLabels(labels);
        options.setProgressCallback(progressCallback);
        return this.findPaths(options, authorizations);
    }

    public Iterable<Path> findPaths(FindPathOptions var1, Authorizations var2);

    public IdGenerator getIdGenerator();

    public boolean isVisibilityValid(Visibility var1, Authorizations var2);

    public void reindex(Authorizations var1);

    public void setMetadata(String var1, Object var2);

    public void removeMetadata(String var1);

    public Object getMetadata(String var1);

    public void reloadMetadata();

    public Iterable<GraphMetadataEntry> getMetadata();

    public Iterable<GraphMetadataEntry> getMetadataWithPrefix(String var1);

    public boolean isFieldBoostSupported();

    public void truncate();

    public void drop();

    public SearchIndexSecurityGranularity getSearchIndexSecurityGranularity();

    public void addGraphEventListener(GraphEventListener var1);

    public void removeGraphEventListener(GraphEventListener var1);

    public void markVertexHidden(Vertex var1, Visibility var2, Authorizations var3);

    public void markVertexVisible(Vertex var1, Visibility var2, Authorizations var3);

    public void markEdgeHidden(Edge var1, Visibility var2, Authorizations var3);

    public void markEdgeVisible(Edge var1, Visibility var2, Authorizations var3);

    public Authorizations createAuthorizations(String ... var1);

    default public Authorizations createAuthorizations(Collection<String> auths) {
        Preconditions.checkNotNull(auths, "auths cannot be null");
        return this.createAuthorizations(auths.toArray(new String[0]));
    }

    public Authorizations createAuthorizations(Authorizations var1, String ... var2);

    default public Authorizations createAuthorizations(Authorizations auths, Collection<String> additionalAuthorizations) {
        return this.createAuthorizations(auths, additionalAuthorizations.toArray(new String[0]));
    }

    default public Map<Object, Long> getVertexPropertyCountByValue(String propertyName, Authorizations authorizations) {
        HashMap<Object, Long> countsByValue = new HashMap<Object, Long>();
        for (Vertex v : this.getVertices(authorizations)) {
            for (Property p : v.getProperties()) {
                Long currentValue;
                if (!propertyName.equals(p.getName())) continue;
                Value mapKey = p.getValue();
                if (mapKey instanceof TextValue) {
                    mapKey = ((TextValue)mapKey).toLower();
                }
                if ((currentValue = (Long)countsByValue.get(mapKey.asObjectCopy())) == null) {
                    countsByValue.put(mapKey.asObjectCopy(), 1L);
                    continue;
                }
                countsByValue.put(mapKey.asObjectCopy(), currentValue + 1L);
            }
        }
        return countsByValue;
    }

    default public long getVertexCount(Authorizations authorizations) {
        return IterableUtils.count(this.getVertices(authorizations));
    }

    default public long getEdgeCount(Authorizations authorizations) {
        return IterableUtils.count(this.getEdges(authorizations));
    }

    public void savePropertyDefinition(PropertyDefinition var1);

    default public DefinePropertyBuilder defineProperty(String propertyName) {
        return new DefinePropertyBuilder(propertyName){

            @Override
            public PropertyDefinition define() {
                PropertyDefinition propertyDefinition = super.define();
                Graph.this.savePropertyDefinition(propertyDefinition);
                return propertyDefinition;
            }
        };
    }

    public boolean isPropertyDefined(String var1);

    public PropertyDefinition getPropertyDefinition(String var1);

    public void removePropertyDefinition(String var1);

    public Collection<PropertyDefinition> getPropertyDefinitions();

    public Iterable<Element> saveElementMutations(Iterable<ElementMutation<? extends Element>> var1, Authorizations var2);

    default public List<InputStream> getStreamingPropertyValueInputStreams(List<StreamingPropertyValue> streamingPropertyValues) {
        return streamingPropertyValues.stream().map(StreamingPropertyValue::getInputStream).collect(Collectors.toList());
    }

    default public Iterable<ExtendedDataRow> getExtendedData(Iterable<ExtendedDataRowId> ids, Authorizations authorizations) {
        return this.getExtendedData(ids, FetchHints.ALL, authorizations);
    }

    public Iterable<ExtendedDataRow> getExtendedData(Iterable<ExtendedDataRowId> var1, FetchHints var2, Authorizations var3);

    default public ExtendedDataRow getExtendedData(ExtendedDataRowId id, Authorizations authorizations) {
        ArrayList rows = Lists.newArrayList(this.getExtendedData(Lists.newArrayList((Object[])new ExtendedDataRowId[]{id}), authorizations));
        if (rows.size() == 0) {
            return null;
        }
        if (rows.size() == 1) {
            return (ExtendedDataRow)rows.get(0);
        }
        throw new GeException("Expected 0 or 1 rows found " + rows.size());
    }

    default public Iterable<ExtendedDataRow> getExtendedData(ElementType elementType, String elementId, String tableName, Authorizations authorizations) {
        return this.getExtendedData(elementType, elementId, tableName, FetchHints.ALL, authorizations);
    }

    default public Iterable<ExtendedDataRow> getExtendedData(ElementId elementId, String tableName, Authorizations authorizations) {
        return this.getExtendedData(elementId, tableName, FetchHints.ALL, authorizations);
    }

    default public Iterable<ExtendedDataRow> getExtendedData(ElementType elementType, String elementId, String tableName, FetchHints fetchHints, Authorizations authorizations) {
        return this.getExtendedData(ElementId.create(elementType, elementId), tableName, fetchHints, authorizations);
    }

    default public Iterable<ExtendedDataRow> getExtendedData(ElementId elementId, String tableName, FetchHints fetchHints, Authorizations authorizations) {
        return this.getExtendedDataForElements(Lists.newArrayList((Object[])new ElementId[]{elementId}), tableName, fetchHints, authorizations);
    }

    default public Iterable<ExtendedDataRow> getExtendedDataForElements(Iterable<? extends ElementId> elementIds, Authorizations authorizations) {
        return this.getExtendedDataForElements(elementIds, FetchHints.ALL, authorizations);
    }

    default public Iterable<ExtendedDataRow> getExtendedDataForElements(Iterable<? extends ElementId> elementIds, String tableName, Authorizations authorizations) {
        return this.getExtendedDataForElements(elementIds, tableName, FetchHints.ALL, authorizations);
    }

    default public Iterable<ExtendedDataRow> getExtendedDataForElements(Iterable<? extends ElementId> elementIds, FetchHints fetchHints, Authorizations authorizations) {
        return this.getExtendedDataForElements(elementIds, null, fetchHints, authorizations);
    }

    public Iterable<ExtendedDataRow> getExtendedDataForElements(Iterable<? extends ElementId> var1, String var2, FetchHints var3, Authorizations var4);

    public Iterable<ExtendedDataRow> getExtendedDataInRange(ElementType var1, IdRange var2, Authorizations var3);

    public void deleteExtendedDataRow(ExtendedDataRowId var1, Authorizations var2);

    public FetchHints getDefaultFetchHints();

    default public void visitElements(GraphVisitor graphVisitor, Authorizations authorizations) {
        this.visitVertices(graphVisitor, authorizations);
        this.visitEdges(graphVisitor, authorizations);
    }

    default public void visitVertices(GraphVisitor graphVisitor, Authorizations authorizations) {
        this.visit(this.getVertices(authorizations), graphVisitor);
    }

    default public void visitEdges(GraphVisitor graphVisitor, Authorizations authorizations) {
        this.visit(this.getEdges(authorizations), graphVisitor);
    }

    default public void visit(Iterable<? extends Element> elements, GraphVisitor visitor) {
        for (Element element : elements) {
            visitor.visitElement(element);
            if (element instanceof Vertex) {
                visitor.visitVertex((Vertex)element);
            } else if (element instanceof Edge) {
                visitor.visitEdge((Edge)element);
            } else {
                throw new GeException("Invalid element type to visit: " + element.getClass().getName());
            }
            for (Property property : element.getProperties()) {
                visitor.visitProperty(element, property);
            }
            for (String tableName : element.getExtendedDataTableNames()) {
                for (ExtendedDataRow extendedDataRow : element.getExtendedData(tableName)) {
                    visitor.visitExtendedDataRow(element, tableName, extendedDataRow);
                    for (Property property : extendedDataRow.getProperties()) {
                        visitor.visitProperty(element, tableName, extendedDataRow, property);
                    }
                }
            }
        }
    }

    public void dumpGraph();

    public GeMetricRegistry getMetricsRegistry();

    default public NameSubstitutionStrategy getNameSubstitutionStrategy() {
        return new IdentityNameSubstitutionStrategy();
    }

    public void ensurePropertyDefined(String var1, Value var2);
}

