/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.EdgeInfo;
import com.mware.ge.EdgeVertexPair;
import com.mware.ge.Element;
import com.mware.ge.ElementFilter;
import com.mware.ge.ElementId;
import com.mware.ge.ElementType;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.ExtendedDataRowId;
import com.mware.ge.FetchHints;
import com.mware.ge.FetchHintsBuilder;
import com.mware.ge.FindPathOptions;
import com.mware.ge.GeException;
import com.mware.ge.GeMissingFetchHintException;
import com.mware.ge.GeNotSupportedException;
import com.mware.ge.GeTypeException;
import com.mware.ge.Graph;
import com.mware.ge.GraphMetadataEntry;
import com.mware.ge.GraphMetadataStore;
import com.mware.ge.IdRange;
import com.mware.ge.Metadata;
import com.mware.ge.Path;
import com.mware.ge.ProgressCallback;
import com.mware.ge.Property;
import com.mware.ge.PropertyDefinition;
import com.mware.ge.SearchIndexSecurityGranularity;
import com.mware.ge.TextIndexHint;
import com.mware.ge.Vertex;
import com.mware.ge.event.GraphEvent;
import com.mware.ge.event.GraphEventListener;
import com.mware.ge.metric.GeMetricRegistry;
import com.mware.ge.metric.StackTraceTracker;
import com.mware.ge.metric.Timer;
import com.mware.ge.mutation.ElementMutation;
import com.mware.ge.mutation.ExistingElementMutation;
import com.mware.ge.query.GraphQuery;
import com.mware.ge.query.SimilarToGraphQuery;
import com.mware.ge.util.ArrayUtils;
import com.mware.ge.util.ConvertingIterable;
import com.mware.ge.util.FilterIterable;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.util.JoinIterable;
import com.mware.ge.util.SelectManyIterable;
import com.mware.ge.util.StreamUtils;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.StreamingPropertyValueRef;
import com.mware.ge.values.storable.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public abstract class GraphBase
implements Graph {
    private static final GeLogger LOGGER = GeLoggerFactory.getLogger(GraphBase.class);
    protected static final GeLogger QUERY_LOGGER = GeLoggerFactory.getQueryLogger(Graph.class);
    public static final String METADATA_DEFINE_PROPERTY_PREFIX = "defineProperty.";
    private final List<GraphEventListener> graphEventListeners = new ArrayList<GraphEventListener>();
    private Map<String, PropertyDefinition> propertyDefinitionCache = new ConcurrentHashMap<String, PropertyDefinition>();
    private final boolean strictTyping;
    private final GeMetricRegistry metricRegistry;
    protected final Timer flushTimer;
    protected final StackTraceTracker flushStackTraceTracker;

    protected GraphBase(boolean strictTyping, GeMetricRegistry metricRegistry) {
        this.strictTyping = strictTyping;
        this.metricRegistry = metricRegistry;
        this.flushTimer = metricRegistry.getTimer(Graph.class, "flush", "timer");
        this.flushStackTraceTracker = metricRegistry.getStackTraceTracker(Graph.class, "flush", "stack");
    }

    @Override
    public Iterable<String> filterEdgeIdsByAuthorization(Iterable<String> edgeIds, final String authorizationToMatch, final EnumSet<ElementFilter> filters, Authorizations authorizations) {
        FilterIterable<Edge> edges = new FilterIterable<Edge>(this.getEdges(edgeIds, FetchHints.ALL_INCLUDING_HIDDEN, authorizations)){

            @Override
            protected boolean isIncluded(Edge edge) {
                if (filters.contains((Object)ElementFilter.ELEMENT) && edge.getVisibility().hasAuthorization(authorizationToMatch)) {
                    return true;
                }
                return GraphBase.this.isIncludedByAuthorizations(edge, filters, authorizationToMatch);
            }
        };
        return new ConvertingIterable<Edge, String>((Iterable)edges){

            @Override
            protected String convert(Edge edge) {
                return edge.getId();
            }
        };
    }

    private boolean isIncludedByAuthorizations(Element element, EnumSet<ElementFilter> filters, String authorizationToMatch) {
        if (filters.contains((Object)ElementFilter.PROPERTY) || filters.contains((Object)ElementFilter.PROPERTY_METADATA)) {
            for (Property property : element.getProperties()) {
                if (filters.contains((Object)ElementFilter.PROPERTY) && property.getVisibility().hasAuthorization(authorizationToMatch)) {
                    return true;
                }
                if (!filters.contains((Object)ElementFilter.PROPERTY_METADATA)) continue;
                for (Metadata.Entry entry : property.getMetadata().entrySet()) {
                    if (!entry.getVisibility().hasAuthorization(authorizationToMatch)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Iterable<String> filterVertexIdsByAuthorization(Iterable<String> vertexIds, final String authorizationToMatch, final EnumSet<ElementFilter> filters, Authorizations authorizations) {
        FilterIterable<Vertex> vertices = new FilterIterable<Vertex>(this.getVertices(vertexIds, FetchHints.ALL_INCLUDING_HIDDEN, authorizations)){

            @Override
            protected boolean isIncluded(Vertex vertex) {
                if (filters.contains((Object)ElementFilter.ELEMENT) && vertex.getVisibility().hasAuthorization(authorizationToMatch)) {
                    return true;
                }
                return GraphBase.this.isIncludedByAuthorizations(vertex, filters, authorizationToMatch);
            }
        };
        return new ConvertingIterable<Vertex, String>((Iterable)vertices){

            @Override
            protected String convert(Vertex vertex) {
                return vertex.getId();
            }
        };
    }

    @Override
    public Iterable<Path> findPaths(FindPathOptions options, Authorizations authorizations) {
        ProgressCallback progressCallback = options.getProgressCallback();
        if (progressCallback == null) {
            progressCallback = new ProgressCallback(){

                @Override
                public void progress(double progressPercent, ProgressCallback.Step step, Integer edgeIndex, Integer vertexCount) {
                    LOGGER.debug("findPaths progress %d%%: %s", (int)(progressPercent * 100.0), step.formatMessage(edgeIndex, vertexCount));
                }
            };
        }
        FetchHints fetchHints = FetchHints.EDGE_REFS;
        Vertex sourceVertex = this.getVertex(options.getSourceVertexId(), fetchHints, authorizations);
        if (sourceVertex == null) {
            throw new IllegalArgumentException("Could not find vertex with id: " + options.getSourceVertexId());
        }
        Vertex destVertex = this.getVertex(options.getDestVertexId(), fetchHints, authorizations);
        if (destVertex == null) {
            throw new IllegalArgumentException("Could not find vertex with id: " + options.getDestVertexId());
        }
        progressCallback.progress(0.0, ProgressCallback.Step.FINDING_PATH);
        HashSet<String> seenVertices = new HashSet<String>();
        seenVertices.add((String)sourceVertex.getId());
        Path startPath = new Path(new String[]{sourceVertex.getId()});
        ArrayList<Path> foundPaths = new ArrayList<Path>();
        if (options.getMaxHops() == 2) {
            this.findPathsSetIntersection(options, foundPaths, sourceVertex, destVertex, progressCallback, authorizations);
        } else {
            this.findPathsRecursive(options, foundPaths, sourceVertex, destVertex, options.getMaxHops(), seenVertices, startPath, progressCallback, authorizations);
        }
        progressCallback.progress(1.0, ProgressCallback.Step.COMPLETE);
        return foundPaths;
    }

    protected void findPathsSetIntersection(FindPathOptions options, List<Path> foundPaths, Vertex sourceVertex, Vertex destVertex, ProgressCallback progressCallback, Authorizations authorizations) {
        Object sourceVertexId = sourceVertex.getId();
        Object destVertexId = destVertex.getId();
        progressCallback.progress(0.1, ProgressCallback.Step.SEARCHING_SOURCE_VERTEX_EDGES);
        Set<String> sourceVertexConnectedVertexIds = this.filterFindPathEdgeInfo(options, sourceVertex.getEdgeInfos(Direction.BOTH, options.getLabels(), authorizations));
        Map<String, Boolean> sourceVerticesExist = this.doVerticesExist(sourceVertexConnectedVertexIds, authorizations);
        sourceVertexConnectedVertexIds = StreamUtils.stream(sourceVerticesExist.keySet()).filter(key -> sourceVerticesExist.getOrDefault(key, false)).collect(Collectors.toSet());
        progressCallback.progress(0.3, ProgressCallback.Step.SEARCHING_DESTINATION_VERTEX_EDGES);
        Set<String> destVertexConnectedVertexIds = this.filterFindPathEdgeInfo(options, destVertex.getEdgeInfos(Direction.BOTH, options.getLabels(), authorizations));
        Map<String, Boolean> destVerticesExist = this.doVerticesExist(destVertexConnectedVertexIds, authorizations);
        destVertexConnectedVertexIds = StreamUtils.stream(destVerticesExist.keySet()).filter(key -> destVerticesExist.getOrDefault(key, false)).collect(Collectors.toSet());
        if (sourceVertexConnectedVertexIds.contains(destVertexId)) {
            foundPaths.add(new Path(new String[]{sourceVertexId, destVertexId}));
            if (options.isGetAnyPath()) {
                return;
            }
        }
        progressCallback.progress(0.6, ProgressCallback.Step.MERGING_EDGES);
        sourceVertexConnectedVertexIds.retainAll(destVertexConnectedVertexIds);
        progressCallback.progress(0.9, ProgressCallback.Step.ADDING_PATHS);
        for (String connectedVertexId : sourceVertexConnectedVertexIds) {
            foundPaths.add(new Path(new String[]{sourceVertexId, connectedVertexId, destVertexId}));
        }
    }

    private Set<String> filterFindPathEdgeInfo(FindPathOptions options, Iterable<EdgeInfo> edgeInfos) {
        return StreamUtils.stream(edgeInfos).filter(edgeInfo -> {
            if (options.getExcludedLabels() != null) {
                return !ArrayUtils.contains(options.getExcludedLabels(), edgeInfo.getLabel());
            }
            return true;
        }).map(EdgeInfo::getVertexId).collect(Collectors.toSet());
    }

    private Iterable<Vertex> filterFindPathEdgePairs(FindPathOptions options, Iterable<EdgeVertexPair> edgeVertexPairs) {
        return StreamUtils.stream(edgeVertexPairs).filter(edgePair -> {
            if (options.getExcludedLabels() != null) {
                return !ArrayUtils.contains(options.getExcludedLabels(), edgePair.getEdge().getLabel());
            }
            return true;
        }).map(EdgeVertexPair::getVertex).collect(Collectors.toList());
    }

    protected void findPathsRecursive(FindPathOptions options, List<Path> foundPaths, Vertex sourceVertex, Vertex destVertex, int hops, Set<String> seenVertices, Path currentPath, ProgressCallback progressCallback, Authorizations authorizations) {
        boolean firstLevelRecursion;
        boolean bl = firstLevelRecursion = hops == options.getMaxHops();
        if (options.isGetAnyPath() && foundPaths.size() == 1) {
            return;
        }
        seenVertices.add((String)sourceVertex.getId());
        if (((String)sourceVertex.getId()).equals(destVertex.getId())) {
            foundPaths.add(currentPath);
        } else if (hops > 0) {
            Iterable<Vertex> vertices = this.filterFindPathEdgePairs(options, sourceVertex.getEdgeVertexPairs(Direction.BOTH, options.getLabels(), authorizations));
            int vertexCount = 0;
            if (firstLevelRecursion) {
                vertices = IterableUtils.toList(vertices);
                vertexCount = ((List)vertices).size();
            }
            int i = 0;
            for (Vertex child : vertices) {
                if (firstLevelRecursion) {
                    double progressPercent = (double)i / (double)vertexCount;
                    progressCallback.progress(progressPercent, ProgressCallback.Step.SEARCHING_EDGES, i + 1, vertexCount);
                }
                if (!seenVertices.contains(child.getId())) {
                    this.findPathsRecursive(options, foundPaths, child, destVertex, hops - 1, seenVertices, new Path(currentPath, (String)child.getId()), progressCallback, authorizations);
                }
                ++i;
            }
        }
        seenVertices.remove(sourceVertex.getId());
    }

    protected abstract GraphMetadataStore getGraphMetadataStore();

    @Override
    public Iterable<GraphMetadataEntry> getMetadata() {
        return this.getGraphMetadataStore().getMetadata();
    }

    @Override
    public void setMetadata(String key, Object value) {
        this.getGraphMetadataStore().setMetadata(key, value);
    }

    @Override
    public void removeMetadata(String key) {
        this.getGraphMetadataStore().removeMetadata(key);
    }

    @Override
    public Object getMetadata(String key) {
        return this.getGraphMetadataStore().getMetadata(key);
    }

    @Override
    public void reloadMetadata() {
        this.getGraphMetadataStore().reloadMetadata();
    }

    @Override
    public Iterable<GraphMetadataEntry> getMetadataWithPrefix(String prefix) {
        return this.getGraphMetadataStore().getMetadataWithPrefix(prefix);
    }

    @Override
    public abstract GraphQuery query(Authorizations var1);

    @Override
    public abstract GraphQuery query(String var1, Authorizations var2);

    @Override
    public abstract void reindex(Authorizations var1);

    @Override
    public abstract void flush();

    @Override
    public abstract void shutdown();

    @Override
    public abstract void drop();

    @Override
    public abstract boolean isFieldBoostSupported();

    @Override
    public abstract SearchIndexSecurityGranularity getSearchIndexSecurityGranularity();

    @Override
    public void addGraphEventListener(GraphEventListener graphEventListener) {
        this.graphEventListeners.add(graphEventListener);
    }

    @Override
    public void removeGraphEventListener(GraphEventListener graphEventListener) {
        this.graphEventListeners.remove(graphEventListener);
    }

    protected boolean hasEventListeners() {
        return this.graphEventListeners.size() > 0;
    }

    protected void fireGraphEvent(GraphEvent graphEvent) {
        for (GraphEventListener graphEventListener : this.graphEventListeners) {
            graphEventListener.onGraphEvent(graphEvent);
        }
    }

    @Override
    public boolean isQuerySimilarToTextSupported() {
        return false;
    }

    @Override
    public SimilarToGraphQuery querySimilarTo(String[] fields, String text, Authorizations authorizations) {
        throw new GeNotSupportedException("querySimilarTo not supported");
    }

    @Override
    public Authorizations createAuthorizations(Authorizations auths, String ... additionalAuthorizations) {
        HashSet<String> newAuths = new HashSet<String>();
        Collections.addAll(newAuths, auths.getAuthorizations());
        Collections.addAll(newAuths, additionalAuthorizations);
        return this.createAuthorizations(newAuths);
    }

    protected void addToPropertyDefinitionCache(PropertyDefinition propertyDefinition) {
        this.propertyDefinitionCache.put(propertyDefinition.getPropertyName(), propertyDefinition);
    }

    @VisibleForTesting
    public void clearPropertyDefinitionCache() {
        this.propertyDefinitionCache.clear();
    }

    public void invalidatePropertyDefinition(String propertyName) {
        PropertyDefinition def = (PropertyDefinition)this.getMetadata(this.getPropertyDefinitionKey(propertyName));
        if (def == null) {
            this.propertyDefinitionCache.remove(propertyName);
        } else if (def != null) {
            this.addToPropertyDefinitionCache(def);
        }
    }

    @Override
    public void savePropertyDefinition(PropertyDefinition propertyDefinition) {
        this.addToPropertyDefinitionCache(propertyDefinition);
        this.setMetadata(this.getPropertyDefinitionKey(propertyDefinition.getPropertyName()), propertyDefinition);
    }

    private String getPropertyDefinitionKey(String propertyName) {
        return METADATA_DEFINE_PROPERTY_PREFIX + propertyName;
    }

    @Override
    public PropertyDefinition getPropertyDefinition(String propertyName) {
        return this.propertyDefinitionCache.getOrDefault(propertyName, null);
    }

    @Override
    public void removePropertyDefinition(String propertyName) {
        PropertyDefinition propertyDefinition = this.propertyDefinitionCache.get(propertyName);
        if (propertyDefinition != null) {
            this.getGraphMetadataStore().removeMetadata(this.getPropertyDefinitionKey(propertyName));
            this.propertyDefinitionCache.remove(propertyName);
        }
    }

    @Override
    public Collection<PropertyDefinition> getPropertyDefinitions() {
        return this.propertyDefinitionCache.values();
    }

    @Override
    public boolean isPropertyDefined(String propertyName) {
        return this.propertyDefinitionCache.containsKey(propertyName);
    }

    @Override
    public void ensurePropertyDefined(String name, Value value) {
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(name);
        if (propertyDefinition != null) {
            return;
        }
        Class<? extends Value> valueClass = this.getValueType(value);
        if (this.strictTyping) {
            throw new GeTypeException(name, valueClass);
        }
        LOGGER.warn("creating default property definition because a previous definition could not be found for property \"" + name + "\" of type " + valueClass, new Object[0]);
        propertyDefinition = new PropertyDefinition(name, valueClass, TextIndexHint.ALL);
        this.savePropertyDefinition(propertyDefinition);
    }

    protected Class<? extends Value> getValueType(Value value) {
        Class<Object> valueClass = value.getClass();
        if (value instanceof StreamingPropertyValue) {
            valueClass = ((StreamingPropertyValue)value).getValueType();
        } else if (value instanceof StreamingPropertyValueRef) {
            valueClass = ((StreamingPropertyValueRef)value).getValueType();
        }
        return valueClass;
    }

    @Override
    public Iterable<Element> saveElementMutations(Iterable<ElementMutation<? extends Element>> mutations, Authorizations authorizations) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (ElementMutation m : this.orderMutations(mutations)) {
            if (m instanceof ExistingElementMutation && !m.hasChanges()) {
                elements.add((Element)((ExistingElementMutation)m).getElement());
                continue;
            }
            Object element = m.save(authorizations);
            elements.add((Element)element);
        }
        return elements;
    }

    protected Iterable<ElementMutation> orderMutations(Iterable<ElementMutation<? extends Element>> mutations) {
        ArrayList<ElementMutation> orderedMutations = new ArrayList<ElementMutation>();
        orderedMutations.addAll(StreamUtils.stream(mutations).filter(m -> m.getElementType().equals((Object)ElementType.VERTEX)).collect(Collectors.toList()));
        orderedMutations.addAll(StreamUtils.stream(mutations).filter(m -> m.getElementType().equals((Object)ElementType.EDGE)).collect(Collectors.toList()));
        return orderedMutations;
    }

    @Override
    public Iterable<ExtendedDataRow> getExtendedData(Iterable<ExtendedDataRowId> idsIterable, FetchHints fetchHints, Authorizations authorizations) {
        final HashSet ids = Sets.newHashSet(idsIterable);
        return new FilterIterable<ExtendedDataRow>(this.getAllExtendedData(fetchHints, authorizations)){

            @Override
            protected boolean isIncluded(ExtendedDataRow row) {
                return ids.contains(row.getId());
            }
        };
    }

    @Override
    public Iterable<ExtendedDataRow> getExtendedDataForElements(Iterable<? extends ElementId> elementIdsArg, final String tableName, FetchHints fetchHints, Authorizations authorizations) {
        final ArrayList elementIds = Lists.newArrayList(elementIdsArg);
        for (ElementId elementId : elementIds) {
            if ((elementId.getElementType() != null || elementId.getId() == null && tableName == null) && (elementId.getElementType() == null || elementId.getId() != null || tableName == null)) continue;
            throw new GeException("Cannot create partial key with missing inner value");
        }
        return new FilterIterable<ExtendedDataRow>(this.getAllExtendedData(fetchHints, authorizations)){

            @Override
            protected boolean isIncluded(ExtendedDataRow row) {
                ExtendedDataRowId rowId = row.getId();
                if (tableName != null && !tableName.equals(rowId.getTableName())) {
                    return false;
                }
                return elementIds.stream().anyMatch(elementId -> {
                    if (elementId.getElementType() != null && !elementId.getElementType().equals((Object)rowId.getElementType())) {
                        return false;
                    }
                    return elementId.getId() == null || elementId.getId().equals(rowId.getElementId());
                });
            }
        };
    }

    @Override
    public Iterable<ExtendedDataRow> getExtendedDataInRange(final ElementType elementType, final IdRange elementIdRange, Authorizations authorizations) {
        return new FilterIterable<ExtendedDataRow>(this.getAllExtendedData(FetchHints.ALL, authorizations)){

            @Override
            protected boolean isIncluded(ExtendedDataRow row) {
                ExtendedDataRowId rowId = row.getId();
                return elementType.equals((Object)rowId.getElementType()) && elementIdRange.isInRange(rowId.getElementId());
            }
        };
    }

    protected Iterable<ExtendedDataRow> getAllExtendedData(FetchHints fetchHints, Authorizations authorizations) {
        JoinIterable allElements = new JoinIterable(this.getVertices(fetchHints, authorizations), this.getEdges(fetchHints, authorizations));
        return new SelectManyIterable<Element, ExtendedDataRow>(allElements){

            @Override
            protected Iterable<? extends ExtendedDataRow> getIterable(final Element element) {
                return new SelectManyIterable<String, ExtendedDataRow>(element.getExtendedDataTableNames()){

                    @Override
                    protected Iterable<? extends ExtendedDataRow> getIterable(String tableName) {
                        return element.getExtendedData(tableName);
                    }
                };
            }
        };
    }

    protected void deleteAllExtendedDataForElement(Element element, Authorizations authorizations) {
        if (!element.getFetchHints().isIncludeExtendedDataTableNames()) {
            throw new GeMissingFetchHintException(element.getFetchHints(), "includeExtendedDataTableNames");
        }
        if (element.getExtendedDataTableNames().size() == 0) {
            return;
        }
        FetchHints fetchHints = new FetchHintsBuilder().setIncludeExtendedDataTableNames(true).build();
        Iterable<ExtendedDataRow> rows = this.getExtendedData(element.getElementType(), (String)element.getId(), null, fetchHints, authorizations);
        for (ExtendedDataRow row : rows) {
            this.deleteExtendedDataRow(row.getId(), authorizations);
        }
    }

    @Override
    public void dumpGraph() {
    }

    @Override
    public GeMetricRegistry getMetricsRegistry() {
        return this.metricRegistry;
    }
}

