/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.mware.ge.Authorizations;
import com.mware.ge.Edge;
import com.mware.ge.EdgeBuilder;
import com.mware.ge.EdgeBuilderByVertexId;
import com.mware.ge.Element;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.GraphBase;
import com.mware.ge.GraphConfiguration;
import com.mware.ge.GraphMetadataEntry;
import com.mware.ge.GraphMetadataStore;
import com.mware.ge.GraphWithSearchIndex;
import com.mware.ge.PropertyDefinition;
import com.mware.ge.SearchIndexSecurityGranularity;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.Visibility;
import com.mware.ge.id.IdGenerator;
import com.mware.ge.mutation.ElementMutation;
import com.mware.ge.mutation.ExistingElementMutation;
import com.mware.ge.query.GraphQuery;
import com.mware.ge.query.MultiVertexQuery;
import com.mware.ge.query.SimilarToGraphQuery;
import com.mware.ge.search.IndexHint;
import com.mware.ge.search.SearchIndex;
import com.mware.ge.search.SearchIndexWithVertexPropertyCountByValue;
import com.mware.ge.tools.GraphBackup;
import com.mware.ge.tools.GraphRestore;
import java.util.ArrayList;
import java.util.Map;

public abstract class GraphBaseWithSearchIndex
extends GraphBase
implements Graph,
GraphWithSearchIndex {
    public static final String METADATA_ID_GENERATOR_CLASSNAME = "idGenerator.classname";
    private final GraphConfiguration configuration;
    private final IdGenerator idGenerator;
    private final FetchHints defaultFetchHints;
    private SearchIndex searchIndex;
    private boolean foundIdGeneratorClassnameInMetadata;

    protected GraphBaseWithSearchIndex(GraphConfiguration configuration) {
        super(configuration.isStrictTyping(), configuration.createMetricsRegistry());
        this.configuration = configuration;
        this.searchIndex = configuration.createSearchIndex(this);
        this.idGenerator = configuration.createIdGenerator(this);
        this.defaultFetchHints = FetchHints.ALL;
    }

    protected GraphBaseWithSearchIndex(GraphConfiguration configuration, IdGenerator idGenerator, SearchIndex searchIndex) {
        super(configuration.isStrictTyping(), configuration.createMetricsRegistry());
        this.configuration = configuration;
        this.searchIndex = searchIndex;
        this.idGenerator = idGenerator;
        this.defaultFetchHints = FetchHints.ALL;
    }

    protected void setup() {
        this.setupGraphMetadata();
    }

    protected void setupGraphMetadata() {
        this.foundIdGeneratorClassnameInMetadata = false;
        for (GraphMetadataEntry graphMetadataEntry : this.getMetadata()) {
            this.setupGraphMetadata(graphMetadataEntry);
        }
        if (!this.foundIdGeneratorClassnameInMetadata) {
            this.setMetadata(METADATA_ID_GENERATOR_CLASSNAME, this.idGenerator.getClass().getName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setupGraphMetadata(GraphMetadataEntry graphMetadataEntry) {
        if (graphMetadataEntry.getKey().startsWith("defineProperty.")) {
            Object value = graphMetadataEntry.getValue();
            if (value == null) {
                return;
            }
            if (!(value instanceof PropertyDefinition)) throw new GeException("Invalid property definition metadata: " + graphMetadataEntry.getKey() + " expected " + PropertyDefinition.class.getName() + " found " + graphMetadataEntry.getValue().getClass().getName());
            this.addToPropertyDefinitionCache((PropertyDefinition)graphMetadataEntry.getValue());
            return;
        } else {
            if (!graphMetadataEntry.getKey().equals(METADATA_ID_GENERATOR_CLASSNAME)) return;
            if (!(graphMetadataEntry.getValue() instanceof String)) throw new GeException("Invalid idGenerator.classname expected String found " + graphMetadataEntry.getValue().getClass().getName());
            String idGeneratorClassname = (String)graphMetadataEntry.getValue();
            if (!idGeneratorClassname.equals(this.idGenerator.getClass().getName())) return;
            this.foundIdGeneratorClassnameInMetadata = true;
        }
    }

    @Override
    public GraphQuery query(Authorizations authorizations) {
        return this.getSearchIndex().queryGraph(this, null, authorizations);
    }

    @Override
    public GraphQuery query(String queryString, Authorizations authorizations) {
        return this.getSearchIndex().queryGraph(this, queryString, authorizations);
    }

    @Override
    public MultiVertexQuery query(String[] vertexIds, String queryString, Authorizations authorizations) {
        return this.getSearchIndex().queryGraph(this, vertexIds, queryString, authorizations);
    }

    @Override
    public MultiVertexQuery query(String[] vertexIds, Authorizations authorizations) {
        return this.getSearchIndex().queryGraph(this, vertexIds, null, authorizations);
    }

    @Override
    public boolean isQuerySimilarToTextSupported() {
        return this.getSearchIndex().isQuerySimilarToTextSupported();
    }

    @Override
    public SimilarToGraphQuery querySimilarTo(String[] fields, String text, Authorizations authorizations) {
        return this.getSearchIndex().querySimilarTo(this, fields, text, authorizations);
    }

    @Override
    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public GraphConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public SearchIndex getSearchIndex() {
        return this.searchIndex;
    }

    @Override
    public void reindex(Authorizations authorizations) {
        this.reindexVertices(authorizations);
        this.reindexEdges(authorizations);
    }

    protected void reindexVertices(Authorizations authorizations) {
        this.searchIndex.addElements(this, this.getVertices(authorizations), authorizations);
    }

    private void reindexEdges(Authorizations authorizations) {
        this.searchIndex.addElements(this, this.getEdges(authorizations), authorizations);
    }

    @Override
    public void flush() {
        this.flushStackTraceTracker.addStackTrace();
        if (this.getSearchIndex() != null) {
            this.searchIndex.flush(this);
        }
    }

    @Override
    public void shutdown() {
        this.flush();
        if (this.getSearchIndex() != null) {
            this.searchIndex.shutdown();
            this.searchIndex = null;
        }
        this.getMetricsRegistry().shutdown();
    }

    @Override
    public abstract void drop();

    @Override
    public boolean isFieldBoostSupported() {
        return this.getSearchIndex().isFieldBoostSupported();
    }

    @Override
    public SearchIndexSecurityGranularity getSearchIndexSecurityGranularity() {
        return this.getSearchIndex().getSearchIndexSecurityGranularity();
    }

    @Override
    public Map<Object, Long> getVertexPropertyCountByValue(String propertyName, Authorizations authorizations) {
        if (this.getSearchIndex() instanceof SearchIndexWithVertexPropertyCountByValue) {
            return ((SearchIndexWithVertexPropertyCountByValue)((Object)this.getSearchIndex())).getVertexPropertyCountByValue(this, propertyName, authorizations);
        }
        return super.getVertexPropertyCountByValue(propertyName, authorizations);
    }

    @Override
    public Iterable<Element> saveElementMutations(Iterable<ElementMutation<? extends Element>> mutations, Authorizations authorizations) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (ElementMutation elementMutation : this.orderMutations(mutations)) {
            if (elementMutation instanceof ExistingElementMutation && !elementMutation.hasChanges()) {
                elements.add((Element)((ExistingElementMutation)elementMutation).getElement());
                continue;
            }
            Object element = elementMutation.save(authorizations);
            elements.add((Element)element);
        }
        for (ElementMutation elementMutation : mutations) {
            if (elementMutation.getIndexHint() != IndexHint.INDEX) continue;
            this.getSearchIndex().addElementExtendedData(this, elementMutation, elementMutation.getExtendedData(), authorizations);
        }
        return elements;
    }

    @Override
    public abstract VertexBuilder prepareVertex(String var1, Long var2, Visibility var3, String var4);

    @Override
    public abstract Iterable<Vertex> getVertices(FetchHints var1, Long var2, Authorizations var3);

    @Override
    public abstract EdgeBuilder prepareEdge(String var1, Vertex var2, Vertex var3, String var4, Long var5, Visibility var6);

    @Override
    public VertexBuilder prepareVertex(Long timestamp, Visibility visibility, String conceptType) {
        return super.prepareVertex(timestamp, visibility, conceptType);
    }

    @Override
    public abstract EdgeBuilderByVertexId prepareEdge(String var1, String var2, String var3, String var4, Long var5, Visibility var6);

    @Override
    public abstract void softDeleteVertex(Vertex var1, Long var2, Authorizations var3);

    @Override
    public abstract void softDeleteEdge(Edge var1, Long var2, Authorizations var3);

    @Override
    public abstract Iterable<Edge> getEdges(FetchHints var1, Long var2, Authorizations var3);

    @Override
    protected abstract GraphMetadataStore getGraphMetadataStore();

    @Override
    public abstract void deleteVertex(Vertex var1, Authorizations var2);

    @Override
    public abstract void deleteEdge(Edge var1, Authorizations var2);

    @Override
    public abstract boolean isVisibilityValid(Visibility var1, Authorizations var2);

    @Override
    public abstract void truncate();

    @Override
    public abstract void markVertexHidden(Vertex var1, Visibility var2, Authorizations var3);

    @Override
    public abstract void markVertexVisible(Vertex var1, Visibility var2, Authorizations var3);

    @Override
    public abstract void markEdgeHidden(Edge var1, Visibility var2, Authorizations var3);

    @Override
    public abstract void markEdgeVisible(Edge var1, Visibility var2, Authorizations var3);

    @Override
    public abstract Authorizations createAuthorizations(String ... var1);

    @Override
    public FetchHints getDefaultFetchHints() {
        return this.defaultFetchHints;
    }

    public String getBackupDir() {
        return this.configuration.getString("backupDir", null);
    }

    public GraphBackup getBackupTool(String outputFile) {
        return new GraphBackup(this.getBackupDir(), outputFile);
    }

    public GraphRestore getRestoreTool() {
        return new GraphRestore(this.getBackupDir());
    }
}

