/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.id.IdGenerator;
import com.mware.ge.id.LongIdGenerator;
import com.mware.ge.metric.DropWizardMetricRegistry;
import com.mware.ge.metric.GeMetricRegistry;
import com.mware.ge.search.DefaultSearchIndex;
import com.mware.ge.search.SearchIndex;
import com.mware.ge.serializer.GeSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.QuickKryoGeSerializer;
import com.mware.ge.util.ConfigurationUtils;
import java.time.Duration;
import java.util.Map;

public class GraphConfiguration {
    public static final String IDGENERATOR_PROP_PREFIX = "idgenerator";
    public static final String SEARCH_INDEX_PROP_PREFIX = "search";
    public static final String AUTO_FLUSH = "autoFlush";
    public static final String DEFAULT_IDGENERATOR = LongIdGenerator.class.getName();
    public static final String DEFAULT_SEARCH_INDEX = DefaultSearchIndex.class.getName();
    public static final boolean DEFAULT_AUTO_FLUSH = false;
    public static final String TABLE_NAME_PREFIX = "tableNamePrefix";
    public static final String DEFAULT_TABLE_NAME_PREFIX = "bc";
    public static final String SERIALIZER = "serializer";
    public static final String DEFAULT_SERIALIZER = QuickKryoGeSerializer.class.getName();
    public static final String METRICS_REGISTRY = "metricsRegistry";
    public static final String DEFAULT_METRICS_REGISTRY = DropWizardMetricRegistry.class.getName();
    public static final String STRICT_TYPING = "strictTyping";
    public static final boolean DEFAULT_STRICT_TYPING = false;
    public static final String CREATE_TABLES = "createTables";
    public static final boolean DEFAULT_CREATE_TABLES = true;
    public static final String BACKUP_DIR = "backupDir";
    private final Map<String, Object> config;

    public GraphConfiguration(Map<String, Object> config) {
        this.config = config;
    }

    public void set(String key, Object value) {
        this.config.put(key, value);
    }

    public Map getConfig() {
        return this.config;
    }

    public Object getConfig(String key, Object defaultValue) {
        Object o = this.getConfig().get(key);
        if (o == null) {
            return defaultValue;
        }
        return o;
    }

    public IdGenerator createIdGenerator(Graph graph) throws GeException {
        return (IdGenerator)ConfigurationUtils.createProvider(graph, this, IDGENERATOR_PROP_PREFIX, DEFAULT_IDGENERATOR);
    }

    public SearchIndex createSearchIndex(Graph graph) throws GeException {
        return (SearchIndex)ConfigurationUtils.createProvider(graph, this, SEARCH_INDEX_PROP_PREFIX, DEFAULT_SEARCH_INDEX);
    }

    public GeSerializer createSerializer(Graph graph) throws GeException {
        return (GeSerializer)ConfigurationUtils.createProvider(graph, this, SERIALIZER, DEFAULT_SERIALIZER);
    }

    public GeSerializer createSerializer() throws GeException {
        return (GeSerializer)ConfigurationUtils.createProvider(null, this, SERIALIZER, DEFAULT_SERIALIZER);
    }

    public GeMetricRegistry createMetricsRegistry() {
        return (GeMetricRegistry)ConfigurationUtils.createProvider(null, this, METRICS_REGISTRY, DEFAULT_METRICS_REGISTRY);
    }

    public boolean getBoolean(String configKey, boolean defaultValue) {
        return ConfigurationUtils.getBoolean(this.config, configKey, defaultValue);
    }

    public double getDouble(String configKey, double defaultValue) {
        return ConfigurationUtils.getDouble(this.config, configKey, defaultValue);
    }

    public int getInt(String configKey, int defaultValue) {
        return ConfigurationUtils.getInt(this.config, configKey, defaultValue);
    }

    public Integer getInteger(String configKey, Integer defaultValue) {
        return ConfigurationUtils.getInteger(this.config, configKey, defaultValue);
    }

    public Duration getDuration(String key, Duration defaultValue) {
        return ConfigurationUtils.getDuration(this.config, key, defaultValue);
    }

    public Duration getDuration(String key, String defaultValue) {
        return ConfigurationUtils.getDuration(this.config, key, defaultValue);
    }

    public long getConfigLong(String key, long defaultValue) {
        return ConfigurationUtils.getConfigLong(this.config, key, defaultValue);
    }

    public String getString(String configKey, String defaultValue) {
        return ConfigurationUtils.getString(this.config, configKey, defaultValue);
    }

    public String getTableNamePrefix() {
        return this.getString(TABLE_NAME_PREFIX, DEFAULT_TABLE_NAME_PREFIX);
    }

    public boolean isStrictTyping() {
        return this.getBoolean(STRICT_TYPING, false);
    }

    public boolean isCreateTables() {
        return this.getBoolean(CREATE_TABLES, true);
    }
}

