/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.mware.ge.Metadata;
import com.mware.ge.Visibility;
import java.io.Serializable;
import java.util.Set;

public class HistoricalPropertyValue
implements Serializable,
Comparable<HistoricalPropertyValue> {
    static final long serialVersionUID = 42L;
    private final String propertyKey;
    private final String propertyName;
    private final long timestamp;
    private final Visibility propertyVisibility;
    private final Object value;
    private final Metadata metadata;
    private final Boolean isDeleted;
    private Set<Visibility> hiddenVisibilities;

    public HistoricalPropertyValue(HistoricalPropertyValueBuilder builder) {
        this.propertyKey = builder.propertyKey;
        this.propertyName = builder.propertyName;
        this.propertyVisibility = builder.propertyVisibility;
        this.timestamp = builder.timestamp;
        this.value = builder.value;
        this.metadata = builder.metadata;
        this.hiddenVisibilities = builder.hiddenVisibilities;
        this.isDeleted = builder.isDeleted;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Visibility getPropertyVisibility() {
        return this.propertyVisibility;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Object getValue() {
        return this.value;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Set<Visibility> getHiddenVisibilities() {
        return this.hiddenVisibilities;
    }

    public boolean isDeleted() {
        return this.isDeleted != null && this.isDeleted != false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricalPropertyValue that = (HistoricalPropertyValue)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (!this.propertyKey.equals(that.propertyKey)) {
            return false;
        }
        if (!this.propertyName.equals(that.propertyName)) {
            return false;
        }
        return this.propertyVisibility.equals(that.propertyVisibility);
    }

    public int hashCode() {
        int result = this.propertyKey.hashCode();
        result = 31 * result + this.propertyName.hashCode();
        result = 31 * result + this.propertyVisibility.hashCode();
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    @Override
    public int compareTo(HistoricalPropertyValue o) {
        int result = -Long.compare(this.getTimestamp(), o.getTimestamp());
        if (result != 0) {
            return result;
        }
        result = this.getPropertyName().compareTo(o.getPropertyName());
        if (result != 0) {
            return result;
        }
        result = this.getPropertyKey().compareTo(o.getPropertyKey());
        if (result != 0) {
            return result;
        }
        result = this.getPropertyVisibility().compareTo(o.getPropertyVisibility());
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public String toString() {
        return "HistoricalPropertyValue{propertyKey='" + this.propertyKey + '\'' + ", propertyName='" + this.propertyName + '\'' + ", propertyVisibility=" + this.propertyVisibility + ", timestamp=" + this.timestamp + ", value=" + this.value + ", isDeleted=" + this.isDeleted + '}';
    }

    public static class HistoricalPropertyValueBuilder {
        private String propertyKey;
        private String propertyName;
        private long timestamp;
        private Visibility propertyVisibility;
        private Object value;
        private Metadata metadata;
        private Boolean isDeleted;
        private Set<Visibility> hiddenVisibilities;

        public HistoricalPropertyValueBuilder(String propertyKey, String propertyName, long timestamp) {
            this.propertyKey = propertyKey;
            this.propertyName = propertyName;
            this.timestamp = timestamp;
        }

        public HistoricalPropertyValueBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public HistoricalPropertyValueBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public HistoricalPropertyValueBuilder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            return this;
        }

        public HistoricalPropertyValueBuilder hiddenVisibilities(Set<Visibility> hiddenVisibilities) {
            this.hiddenVisibilities = hiddenVisibilities;
            return this;
        }

        public HistoricalPropertyValueBuilder propertyVisibility(Visibility propertyVisibility) {
            this.propertyVisibility = propertyVisibility;
            return this;
        }

        public HistoricalPropertyValueBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public HistoricalPropertyValue build() {
            return new HistoricalPropertyValue(this);
        }
    }
}

