/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Metadata;
import com.mware.ge.Visibility;
import com.mware.ge.values.storable.Value;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MapMetadata
implements Metadata,
Serializable {
    private static final String KEY_SEPARATOR = "\u001f";
    private final Map<String, Entry> entries;
    private final FetchHints fetchHints;
    private transient ReadWriteLock entriesLock = new ReentrantReadWriteLock();

    public MapMetadata() {
        this(FetchHints.ALL);
    }

    public MapMetadata(FetchHints fetchHints) {
        this.entries = new HashMap<String, Entry>();
        this.fetchHints = fetchHints;
    }

    public MapMetadata(Metadata copyFromMetadata) {
        this(copyFromMetadata, FetchHints.ALL);
    }

    public MapMetadata(Metadata copyFromMetadata, FetchHints fetchHints) {
        this(fetchHints);
        if (copyFromMetadata != null) {
            for (Metadata.Entry entry : copyFromMetadata.entrySet()) {
                this.add(entry.getKey(), entry.getValue(), entry.getVisibility());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Metadata add(String key, Value value, Visibility visibility) {
        this.getEntriesLock().writeLock().lock();
        try {
            this.entries.put(this.toMapKey(key, visibility), new Entry(key, value, visibility));
            MapMetadata mapMetadata = this;
            return mapMetadata;
        }
        finally {
            this.getEntriesLock().writeLock().unlock();
        }
    }

    @Override
    public void remove(String key, Visibility visibility) {
        this.getEntriesLock().writeLock().lock();
        try {
            this.entries.remove(this.toMapKey(key, visibility));
        }
        finally {
            this.getEntriesLock().writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.getEntriesLock().writeLock().lock();
        try {
            this.entries.clear();
        }
        finally {
            this.getEntriesLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        this.getEntriesLock().writeLock().lock();
        try {
            for (Map.Entry<String, Entry> e : new ArrayList<Map.Entry<String, Entry>>(this.entries.entrySet())) {
                if (!e.getValue().getKey().equals(key)) continue;
                this.entries.remove(e.getKey());
            }
        }
        finally {
            this.getEntriesLock().writeLock().unlock();
        }
    }

    @Override
    public Collection<Metadata.Entry> entrySet() {
        this.getEntriesLock().readLock().lock();
        try {
            ArrayList<Metadata.Entry> arrayList = new ArrayList<Metadata.Entry>(this.entries.values());
            return arrayList;
        }
        finally {
            this.getEntriesLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry getEntry(String key, Visibility visibility) {
        this.getFetchHints().assertMetadataIncluded(key);
        this.getEntriesLock().readLock().lock();
        try {
            Entry entry = this.entries.get(this.toMapKey(key, visibility));
            return entry;
        }
        finally {
            this.getEntriesLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry getEntry(String key) {
        this.getFetchHints().assertMetadataIncluded(key);
        this.getEntriesLock().readLock().lock();
        try {
            Entry entry = null;
            for (Map.Entry<String, Entry> e : this.entries.entrySet()) {
                if (!e.getValue().getKey().equals(key)) continue;
                if (entry != null) {
                    throw new GeException("Multiple matching entries for key: " + key);
                }
                entry = e.getValue();
            }
            Iterator<Map.Entry<String, Entry>> iterator = entry;
            return iterator;
        }
        finally {
            this.getEntriesLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Metadata.Entry> getEntries(String key) {
        this.getFetchHints().assertMetadataIncluded(key);
        this.getEntriesLock().readLock().lock();
        try {
            ArrayList<Entry> results = new ArrayList<Entry>();
            for (Map.Entry<String, Entry> e : this.entries.entrySet()) {
                if (!e.getValue().getKey().equals(key)) continue;
                Entry entry = e.getValue();
                results.add(entry);
            }
            ArrayList<Entry> arrayList = results;
            return arrayList;
        }
        finally {
            this.getEntriesLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(String key) {
        this.getFetchHints().assertMetadataIncluded(key);
        this.getEntriesLock().readLock().lock();
        try {
            for (Map.Entry<String, Entry> e : this.entries.entrySet()) {
                if (!e.getValue().getKey().equals(key)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.getEntriesLock().readLock().unlock();
        }
    }

    private String toMapKey(String key, Visibility visibility) {
        return key + KEY_SEPARATOR + visibility.getVisibilityString();
    }

    private ReadWriteLock getEntriesLock() {
        if (this.entriesLock == null) {
            this.entriesLock = new ReentrantReadWriteLock();
        }
        return this.entriesLock;
    }

    @Override
    public FetchHints getFetchHints() {
        return this.fetchHints;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MapMetadata)) {
            return false;
        }
        MapMetadata other = (MapMetadata)obj;
        return Objects.equals(this.entries, other.entries);
    }

    class Entry
    implements Metadata.Entry,
    Serializable {
        static final long serialVersionUID = 42L;
        private final String key;
        private final Value value;
        private final Visibility visibility;

        protected Entry(String key, Value value, Visibility visibility) {
            this.key = key;
            this.value = value;
            this.visibility = visibility;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Value getValue() {
            return this.value;
        }

        @Override
        public Visibility getVisibility() {
            return this.visibility;
        }

        public String toString() {
            return "Entry{key='" + this.key + '\'' + ", value=" + this.value + ", visibility=" + this.visibility + '}';
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)obj;
            return Objects.equals(this.key, other.key) && Objects.equals(this.value, other.value) && Objects.equals(this.visibility, other.visibility);
        }
    }
}

