/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.mware.ge.FetchHints;
import com.mware.ge.MapMetadata;
import com.mware.ge.Visibility;
import com.mware.ge.values.storable.Value;
import java.util.ArrayList;
import java.util.Collection;

public interface Metadata {
    public static Metadata create(FetchHints fetchHints) {
        return new MapMetadata(fetchHints);
    }

    public static Metadata create() {
        return new MapMetadata();
    }

    public static Metadata create(Metadata metadata) {
        return new MapMetadata(metadata);
    }

    public static Metadata create(Metadata metadata, FetchHints fetchHints) {
        return new MapMetadata(metadata, fetchHints);
    }

    public Metadata add(String var1, Value var2, Visibility var3);

    public void remove(String var1, Visibility var2);

    public void clear();

    public void remove(String var1);

    public Collection<Entry> entrySet();

    public Entry getEntry(String var1, Visibility var2);

    public Entry getEntry(String var1);

    public Collection<Entry> getEntries(String var1);

    public FetchHints getFetchHints();

    default public Object getValue(String key, Visibility visibility) {
        Entry entry = this.getEntry(key, visibility);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    default public Value getValue(String key) {
        Entry entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    default public Collection<Value> getValues(String key) {
        ArrayList<Value> results = new ArrayList<Value>();
        Collection<Entry> entries = this.getEntries(key);
        for (Entry entry : entries) {
            results.add(entry.getValue());
        }
        return results;
    }

    default public boolean containsKey(String key) {
        return this.getEntries(key).size() > 0;
    }

    default public boolean contains(String key, Visibility visibility) {
        return this.getEntry(key, visibility) != null;
    }

    public static interface Entry {
        public String getKey();

        public Value getValue();

        public Visibility getVisibility();
    }
}

