/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.google.common.collect.Sets;
import com.mware.ge.GePropertyNotDefinedException;
import com.mware.ge.TextIndexHint;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;

public class PropertyDefinition
implements Serializable {
    private static final long serialVersionUID = 42L;
    private static final PropertyDefinition ID_PROPERTY_DEFINITION = new PropertyDefinition("__ID__", TextValue.class, Sets.newHashSet((Object[])new TextIndexHint[]{TextIndexHint.EXACT_MATCH}));
    private static final PropertyDefinition LABEL_PROPERTY_DEFINITION = new PropertyDefinition("__edgeLabel", TextValue.class, Sets.newHashSet((Object[])new TextIndexHint[]{TextIndexHint.EXACT_MATCH}));
    private static final PropertyDefinition OUT_VERTEX_ID_PROPERTY_DEFINITION = new PropertyDefinition("__outVertexId", TextValue.class, Sets.newHashSet((Object[])new TextIndexHint[]{TextIndexHint.EXACT_MATCH}));
    private static final PropertyDefinition OUT_VERTEX_TYPE_PROPERTY_DEFINITION = new PropertyDefinition("__outVertexType", TextValue.class, Sets.newHashSet((Object[])new TextIndexHint[]{TextIndexHint.EXACT_MATCH}));
    private static final PropertyDefinition IN_VERTEX_ID_PROPERTY_DEFINITION = new PropertyDefinition("__inVertexId", TextValue.class, Sets.newHashSet((Object[])new TextIndexHint[]{TextIndexHint.EXACT_MATCH}));
    private static final PropertyDefinition IN_VERTEX_TYPE_PROPERTY_DEFINITION = new PropertyDefinition("__inVertexType", TextValue.class, Sets.newHashSet((Object[])new TextIndexHint[]{TextIndexHint.EXACT_MATCH}));
    private static final PropertyDefinition IN_OR_OUT_VERTEX_ID_PROPERTY_DEFINITION = new PropertyDefinition("__inOrOutVertexId", TextValue.class, Sets.newHashSet((Object[])new TextIndexHint[]{TextIndexHint.EXACT_MATCH}));
    private static final PropertyDefinition TABLE_NAME_PROPERTY_DEFINITION = new PropertyDefinition("__extendedDataTableName", TextValue.class, Sets.newHashSet((Object[])new TextIndexHint[]{TextIndexHint.EXACT_MATCH}));
    private static final PropertyDefinition ELEMENT_ID_PROPERTY_DEFINITION = new PropertyDefinition("__extendedDataElementId", TextValue.class, Sets.newHashSet((Object[])new TextIndexHint[]{TextIndexHint.EXACT_MATCH}));
    private static final PropertyDefinition ELEMENT_TYPE_PROPERTY_DEFINITION = new PropertyDefinition("__extendedDataElementType", TextValue.class, Sets.newHashSet((Object[])new TextIndexHint[]{TextIndexHint.EXACT_MATCH}));
    private static final PropertyDefinition ROW_ID_PROPERTY_DEFINITION = new PropertyDefinition("__extendedDataRowId", TextValue.class, Sets.newHashSet((Object[])new TextIndexHint[]{TextIndexHint.EXACT_MATCH}));
    private final String propertyName;
    private final Class<? extends Value> dataType;
    private final Set<TextIndexHint> textIndexHints;
    private final Double boost;
    private final boolean sortable;

    public PropertyDefinition(String propertyName, Class<? extends Value> dataType, Set<TextIndexHint> textIndexHints) {
        this(propertyName, dataType, textIndexHints, null, false);
    }

    public PropertyDefinition(String propertyName, Class dataType, Set<TextIndexHint> textIndexHints, Double boost, boolean sortable) {
        this.propertyName = propertyName;
        this.dataType = dataType;
        this.textIndexHints = textIndexHints;
        if (textIndexHints != null && textIndexHints.contains((Object)TextIndexHint.EXACT_MATCH)) {
            this.textIndexHints.add(TextIndexHint.FULL_TEXT);
        }
        this.boost = boost;
        this.sortable = sortable;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<? extends Value> getDataType() {
        return this.dataType;
    }

    public Set<TextIndexHint> getTextIndexHints() {
        return this.textIndexHints;
    }

    public Double getBoost() {
        return this.boost;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public static PropertyDefinition findPropertyDefinition(Collection<PropertyDefinition> propertyDefinitions, String propertyName) {
        if ("__ID__".equals(propertyName)) {
            return ID_PROPERTY_DEFINITION;
        }
        if ("__edgeLabel".equals(propertyName)) {
            return LABEL_PROPERTY_DEFINITION;
        }
        if ("__outVertexId".equals(propertyName)) {
            return OUT_VERTEX_ID_PROPERTY_DEFINITION;
        }
        if ("__outVertexType".equals(propertyName)) {
            return OUT_VERTEX_TYPE_PROPERTY_DEFINITION;
        }
        if ("__inVertexId".equals(propertyName)) {
            return IN_VERTEX_ID_PROPERTY_DEFINITION;
        }
        if ("__inVertexType".equals(propertyName)) {
            return IN_VERTEX_TYPE_PROPERTY_DEFINITION;
        }
        if ("__inOrOutVertexId".equals(propertyName)) {
            return IN_OR_OUT_VERTEX_ID_PROPERTY_DEFINITION;
        }
        if ("__extendedDataTableName".equals(propertyName)) {
            return TABLE_NAME_PROPERTY_DEFINITION;
        }
        if ("__extendedDataRowId".equals(propertyName)) {
            return ROW_ID_PROPERTY_DEFINITION;
        }
        if ("__extendedDataElementType".equals(propertyName)) {
            return ELEMENT_TYPE_PROPERTY_DEFINITION;
        }
        if ("__extendedDataElementId".equals(propertyName)) {
            return ELEMENT_ID_PROPERTY_DEFINITION;
        }
        for (PropertyDefinition propertyDefinition : propertyDefinitions) {
            if (propertyDefinition.getPropertyName() == null || !propertyDefinition.getPropertyName().equals(propertyName)) continue;
            return propertyDefinition;
        }
        throw new GePropertyNotDefinedException("Could not find property definition for property name: " + propertyName);
    }

    public String toString() {
        return "PropertyDefinition{propertyName='" + this.propertyName + '\'' + ", dataType=" + this.dataType + ", textIndexHints=" + this.textIndexHints + ", boost=" + this.boost + ", sortable=" + this.sortable + '}';
    }
}

