/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.mware.ge.IdRange;
import com.mware.ge.util.ObjectUtils;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Range<T>
implements Serializable {
    private static final long serialVersionUID = -4491252292678133754L;
    private T start;
    private final boolean inclusiveStart;
    private T end;
    private final boolean inclusiveEnd;
    private String prefix;

    protected Range() {
        this.start = null;
        this.end = null;
        this.inclusiveStart = false;
        this.inclusiveEnd = false;
    }

    public Range(T start, boolean inclusiveStart, T end, boolean inclusiveEnd) {
        this.start = start;
        this.inclusiveStart = inclusiveStart;
        this.end = end;
        this.inclusiveEnd = inclusiveEnd;
    }

    public Range(T row) {
        this(row, true, row, true);
    }

    public T getStart() {
        return this.start;
    }

    public boolean isInclusiveStart() {
        return this.inclusiveStart;
    }

    public T getEnd() {
        return this.end;
    }

    public boolean isInclusiveEnd() {
        return this.inclusiveEnd;
    }

    public boolean isInRange(Object obj) {
        if (this.getStart() != null && (this.isInclusiveStart() ? ObjectUtils.compare(this.getStart(), obj) > 0 : ObjectUtils.compare(this.getStart(), obj) >= 0)) {
            return false;
        }
        return this.getEnd() == null || !(this.isInclusiveEnd() ? ObjectUtils.compare(obj, this.getEnd()) > 0 : ObjectUtils.compare(obj, this.getEnd()) >= 0);
    }

    public static IdRange prefix(String prefix) {
        IdRange r = new IdRange();
        r.setPrefix(prefix);
        return r;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String toString() {
        return String.format("%s{start=%s, inclusiveStart=%s, end=%s, inclusiveEnd=%s}", this.getClass().getSimpleName(), this.start, this.inclusiveStart, this.end, this.inclusiveEnd);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range range = (Range)o;
        return this.inclusiveStart == range.inclusiveStart && this.inclusiveEnd == range.inclusiveEnd && Objects.equals(this.start, range.start) && Objects.equals(this.end, range.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.inclusiveStart, this.end, this.inclusiveEnd);
    }

    public boolean isEmpty() {
        if (this.start == null && this.end == null) {
            return true;
        }
        if (this.start instanceof String && this.end instanceof String) {
            return StringUtils.isEmpty((CharSequence)((String)this.start)) && StringUtils.isEmpty((CharSequence)((String)this.end));
        }
        if (this.start instanceof byte[] && this.end instanceof byte[]) {
            return ((byte[])this.start).length == 0 && ((byte[])this.end).length == 0;
        }
        assert (this.start != null);
        throw new IllegalStateException("Don't know how to test for emptiness for type: " + this.start.getClass().getName());
    }
}

