/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public enum TextIndexHint {
    FULL_TEXT(1),
    EXACT_MATCH(2);

    private final byte value;
    public static final Set<TextIndexHint> NONE;
    public static final Set<TextIndexHint> ALL;

    private TextIndexHint(byte value) {
        this.value = value;
    }

    public static byte toBits(TextIndexHint ... indexHints) {
        return TextIndexHint.toBits(EnumSet.copyOf(Arrays.asList(indexHints)));
    }

    public static byte toBits(Collection<TextIndexHint> hints) {
        byte b = 0;
        for (TextIndexHint hint : hints) {
            b = (byte)(b | hint.value);
        }
        return b;
    }

    public static Set<TextIndexHint> toSet(byte indexHint) {
        HashSet<TextIndexHint> hints = new HashSet<TextIndexHint>();
        if ((indexHint & TextIndexHint.FULL_TEXT.value) == TextIndexHint.FULL_TEXT.value) {
            hints.add(FULL_TEXT);
        }
        if ((indexHint & TextIndexHint.EXACT_MATCH.value) == TextIndexHint.EXACT_MATCH.value) {
            hints.add(EXACT_MATCH);
        }
        return hints;
    }

    public static Set<TextIndexHint> parse(String str) {
        if (str == null || str.equalsIgnoreCase("NONE")) {
            return NONE;
        }
        if (str.equalsIgnoreCase("ALL")) {
            return ALL;
        }
        String[] textIndexHintParts = str.split(",");
        HashSet<TextIndexHint> textIndexHints = new HashSet<TextIndexHint>();
        for (String textIndexHintPart : textIndexHintParts) {
            if (textIndexHintPart.trim().length() == 0) continue;
            textIndexHints.add(TextIndexHint.parsePart(textIndexHintPart));
        }
        return textIndexHints;
    }

    private static TextIndexHint parsePart(String part) {
        part = part.trim();
        for (TextIndexHint textIndexHint : TextIndexHint.values()) {
            if (!textIndexHint.name().equalsIgnoreCase(part)) continue;
            return textIndexHint;
        }
        return TextIndexHint.valueOf(part);
    }

    static {
        NONE = EnumSet.noneOf(TextIndexHint.class);
        ALL = EnumSet.of(FULL_TEXT, EXACT_MATCH);
    }
}

