/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge;

import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.EdgeInfo;
import com.mware.ge.EdgeVertexPair;
import com.mware.ge.EdgesSummary;
import com.mware.ge.Element;
import com.mware.ge.ElementType;
import com.mware.ge.FetchHints;
import com.mware.ge.GeMissingFetchHintException;
import com.mware.ge.VertexElementLocation;
import com.mware.ge.mutation.ExistingVertexMutation;
import com.mware.ge.query.VertexQuery;
import com.mware.ge.util.ConvertingIterable;
import com.mware.ge.util.FilterIterable;

public interface Vertex
extends Element,
VertexElementLocation {
    default public Iterable<Edge> getEdges(Direction direction, Authorizations authorizations) {
        return this.getEdges(direction, this.getGraph().getDefaultFetchHints(), authorizations);
    }

    default public Iterable<Edge> getEdges(Direction direction, FetchHints fetchHints, Authorizations authorizations) {
        return this.getEdges(direction, fetchHints, null, authorizations);
    }

    public Iterable<Edge> getEdges(Direction var1, FetchHints var2, Long var3, Authorizations var4);

    public Iterable<String> getEdgeIds(Direction var1, Authorizations var2);

    default public Iterable<Edge> getEdges(Direction direction, String label, Authorizations authorizations) {
        return this.getEdges(direction, label, this.getGraph().getDefaultFetchHints(), authorizations);
    }

    default public Iterable<Edge> getEdges(Direction direction, String label, FetchHints fetchHints, Authorizations authorizations) {
        String[] stringArray;
        if (label == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = label;
        }
        return this.getEdges(direction, stringArray, authorizations);
    }

    public Iterable<String> getEdgeIds(Direction var1, String var2, Authorizations var3);

    default public Iterable<Edge> getEdges(Direction direction, String[] labels, Authorizations authorizations) {
        return this.getEdges(direction, labels, this.getGraph().getDefaultFetchHints(), authorizations);
    }

    default public Iterable<Edge> getEdges(Direction direction, final String[] labels, FetchHints fetchHints, Authorizations authorizations) {
        return new FilterIterable<Edge>(this.getEdges(direction, authorizations)){

            @Override
            protected boolean isIncluded(Edge edge) {
                if (labels == null) {
                    return true;
                }
                for (String label : labels) {
                    if (!label.equals(edge.getLabel())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public Iterable<String> getEdgeIds(Direction var1, String[] var2, Authorizations var3);

    default public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, Authorizations authorizations) {
        return this.getEdges(otherVertex, direction, this.getGraph().getDefaultFetchHints(), authorizations);
    }

    default public Iterable<Edge> getEdges(final Vertex otherVertex, Direction direction, FetchHints fetchHints, Authorizations authorizations) {
        return new FilterIterable<Edge>(this.getEdges(direction, authorizations)){

            @Override
            protected boolean isIncluded(Edge edge) {
                return edge.getOtherVertexId((String)Vertex.this.getId()).equals(otherVertex.getId());
            }
        };
    }

    public Iterable<String> getEdgeIds(Vertex var1, Direction var2, Authorizations var3);

    default public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, String label, Authorizations authorizations) {
        return this.getEdges(otherVertex, direction, label, this.getGraph().getDefaultFetchHints(), authorizations);
    }

    default public Iterable<Edge> getEdges(final Vertex otherVertex, Direction direction, String label, FetchHints fetchHints, Authorizations authorizations) {
        return new FilterIterable<Edge>(this.getEdges(direction, label, authorizations)){

            @Override
            protected boolean isIncluded(Edge edge) {
                return edge.getOtherVertexId((String)Vertex.this.getId()).equals(otherVertex.getId());
            }
        };
    }

    public Iterable<String> getEdgeIds(Vertex var1, Direction var2, String var3, Authorizations var4);

    default public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, String[] labels, Authorizations authorizations) {
        return this.getEdges(otherVertex, direction, labels, this.getGraph().getDefaultFetchHints(), authorizations);
    }

    default public Iterable<Edge> getEdges(final Vertex otherVertex, Direction direction, String[] labels, FetchHints fetchHints, Authorizations authorizations) {
        return new FilterIterable<Edge>(this.getEdges(direction, labels, authorizations)){

            @Override
            protected boolean isIncluded(Edge edge) {
                return edge.getOtherVertexId((String)Vertex.this.getId()).equals(otherVertex.getId());
            }
        };
    }

    public Iterable<String> getEdgeIds(Vertex var1, Direction var2, String[] var3, Authorizations var4);

    default public int getEdgeCount(Direction direction, Authorizations authorizations) {
        return this.getEdgesSummary(authorizations).getCountOfEdges(direction);
    }

    default public Iterable<String> getEdgeLabels(Direction direction, Authorizations authorizations) {
        return this.getEdgesSummary(authorizations).getEdgeLabels(direction);
    }

    public EdgesSummary getEdgesSummary(Authorizations var1);

    default public Iterable<EdgeInfo> getEdgeInfos(Direction direction, Authorizations authorizations) {
        return this.getEdgeInfos(direction, (String[])null, authorizations);
    }

    default public Iterable<EdgeInfo> getEdgeInfos(Direction direction, String label, Authorizations authorizations) {
        return this.getEdgeInfos(direction, new String[]{label}, authorizations);
    }

    public Iterable<EdgeInfo> getEdgeInfos(Direction var1, String[] var2, Authorizations var3);

    default public Iterable<Vertex> getVertices(Direction direction, Authorizations authorizations) {
        return this.getVertices(direction, this.getGraph().getDefaultFetchHints(), authorizations);
    }

    default public Iterable<Vertex> getVertices(Direction direction, FetchHints fetchHints, Authorizations authorizations) {
        return this.getVertices(direction, (String[])null, fetchHints, authorizations);
    }

    default public Iterable<Vertex> getVertices(Direction direction, String label, Authorizations authorizations) {
        return this.getVertices(direction, label, this.getGraph().getDefaultFetchHints(), authorizations);
    }

    default public Iterable<Vertex> getVertices(Direction direction, String label, FetchHints fetchHints, Authorizations authorizations) {
        String[] stringArray;
        if (label == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = label;
        }
        return this.getVertices(direction, stringArray, fetchHints, authorizations);
    }

    default public Iterable<Vertex> getVertices(Direction direction, String[] labels, Authorizations authorizations) {
        return this.getVertices(direction, labels, this.getGraph().getDefaultFetchHints(), authorizations);
    }

    default public Iterable<Vertex> getVertices(Direction direction, String[] labels, FetchHints fetchHints, Authorizations authorizations) {
        Iterable<String> vertexIds = this.getVertexIds(direction, labels, authorizations);
        return this.getGraph().getVertices(vertexIds, fetchHints, authorizations);
    }

    default public Iterable<String> getVertexIds(Direction direction, String label, Authorizations authorizations) {
        String[] stringArray;
        if (label == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = label;
        }
        return this.getVertexIds(direction, stringArray, authorizations);
    }

    default public Iterable<String> getVertexIds(Direction direction, String[] labels, Authorizations authorizations) {
        if (!this.getFetchHints().isIncludeEdgeVertexIds()) {
            throw new GeMissingFetchHintException(this.getFetchHints(), "includeEdgeVertexIds");
        }
        return new ConvertingIterable<EdgeInfo, String>(this.getEdgeInfos(direction, labels, authorizations)){

            @Override
            protected String convert(EdgeInfo e) {
                return e.getVertexId();
            }
        };
    }

    default public Iterable<String> getVertexIds(Direction direction, Authorizations authorizations) {
        return this.getVertexIds(direction, (String[])null, authorizations);
    }

    default public VertexQuery query(Authorizations authorizations) {
        return this.query(null, authorizations);
    }

    public VertexQuery query(String var1, Authorizations var2);

    public ExistingVertexMutation prepareMutation();

    default public Iterable<EdgeVertexPair> getEdgeVertexPairs(Direction direction, Authorizations authorizations) {
        return this.getEdgeVertexPairs(this.getEdgeInfos(direction, authorizations), this.getGraph().getDefaultFetchHints(), null, authorizations);
    }

    default public Iterable<EdgeVertexPair> getEdgeVertexPairs(Direction direction, FetchHints fetchHints, Authorizations authorizations) {
        return this.getEdgeVertexPairs(this.getEdgeInfos(direction, authorizations), fetchHints, null, authorizations);
    }

    default public Iterable<EdgeVertexPair> getEdgeVertexPairs(Direction direction, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        return this.getEdgeVertexPairs(this.getEdgeInfos(direction, authorizations), fetchHints, endTime, authorizations);
    }

    default public Iterable<EdgeVertexPair> getEdgeVertexPairs(Direction direction, String label, Authorizations authorizations) {
        return this.getEdgeVertexPairs(this.getEdgeInfos(direction, label, authorizations), this.getGraph().getDefaultFetchHints(), null, authorizations);
    }

    default public Iterable<EdgeVertexPair> getEdgeVertexPairs(Direction direction, String label, FetchHints fetchHints, Authorizations authorizations) {
        return this.getEdgeVertexPairs(this.getEdgeInfos(direction, label, authorizations), fetchHints, null, authorizations);
    }

    default public Iterable<EdgeVertexPair> getEdgeVertexPairs(Direction direction, String[] labels, Authorizations authorizations) {
        return this.getEdgeVertexPairs(this.getEdgeInfos(direction, labels, authorizations), this.getGraph().getDefaultFetchHints(), null, authorizations);
    }

    default public Iterable<EdgeVertexPair> getEdgeVertexPairs(Direction direction, String[] labels, FetchHints fetchHints, Authorizations authorizations) {
        return this.getEdgeVertexPairs(this.getEdgeInfos(direction, labels, authorizations), fetchHints, null, authorizations);
    }

    default public Iterable<EdgeVertexPair> getEdgeVertexPairs(Iterable<EdgeInfo> edgeInfos, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        return EdgeVertexPair.getEdgeVertexPairs(this.getGraph(), (String)this.getId(), edgeInfos, fetchHints, endTime, authorizations);
    }

    @Override
    default public ElementType getElementType() {
        return ElementType.VERTEX;
    }

    @Override
    public String getConceptType();
}

