/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.collection;

import com.mware.ge.collection.PrefetchingIterator;
import java.util.Collections;
import java.util.Iterator;

public class CombiningIterator<T>
extends PrefetchingIterator<T> {
    private Iterator<? extends Iterator<T>> iterators;
    private Iterator<T> currentIterator;

    public CombiningIterator(Iterable<? extends Iterator<T>> iterators) {
        this(iterators.iterator());
    }

    public CombiningIterator(Iterator<? extends Iterator<T>> iterators) {
        this.iterators = iterators;
    }

    public CombiningIterator(T first, Iterator<T> rest) {
        this(Collections.emptyList());
        this.hasFetchedNext = true;
        this.nextObject = first;
        this.currentIterator = rest;
    }

    @Override
    protected T fetchNextOrNull() {
        if (this.currentIterator == null || !this.currentIterator.hasNext()) {
            while ((this.currentIterator = this.nextIteratorOrNull()) != null && !this.currentIterator.hasNext()) {
            }
        }
        return this.currentIterator != null && this.currentIterator.hasNext() ? (T)this.currentIterator.next() : null;
    }

    protected Iterator<T> nextIteratorOrNull() {
        if (this.iterators.hasNext()) {
            return this.iterators.next();
        }
        return null;
    }

    protected Iterator<T> currentIterator() {
        return this.currentIterator;
    }
}

