/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.collection;

import com.mware.ge.collection.CombiningIterator;
import com.mware.ge.io.ResourceIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class CombiningResourceIterator<T>
extends CombiningIterator<T>
implements ResourceIterator<T> {
    private final Iterator<ResourceIterator<T>> iterators;
    private final Collection<ResourceIterator<T>> seenIterators = new ArrayList<ResourceIterator<T>>();
    private ResourceIterator<T> currentIterator;

    public CombiningResourceIterator(Iterator<ResourceIterator<T>> iterators) {
        super(iterators);
        this.iterators = iterators;
    }

    @Override
    protected Iterator<T> nextIteratorOrNull() {
        if (this.iterators.hasNext()) {
            this.currentIterator = this.iterators.next();
            this.seenIterators.add(this.currentIterator);
            return this.currentIterator;
        }
        return null;
    }

    @Override
    public void close() {
        for (ResourceIterator<T> seenIterator : this.seenIterators) {
            seenIterator.close();
        }
        while (this.iterators.hasNext()) {
            this.iterators.next().close();
        }
    }
}

