/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

class FilterIterable<T>
implements Iterable<T> {
    private final Iterable<T> iterable;
    private final Predicate<? super T> specification;

    FilterIterable(Iterable<T> iterable, Predicate<? super T> specification) {
        this.iterable = iterable;
        this.specification = specification;
    }

    @Override
    public Iterator<T> iterator() {
        return new FilterIterator<T>(this.iterable.iterator(), this.specification);
    }

    static class FilterIterator<T>
    implements Iterator<T> {
        private final Iterator<T> iterator;
        private final Predicate<? super T> specification;
        private T currentValue;
        boolean finished;
        boolean nextConsumed = true;

        FilterIterator(Iterator<T> iterator, Predicate<? super T> specification) {
            this.specification = specification;
            this.iterator = iterator;
        }

        boolean moveToNextValid() {
            boolean found = false;
            while (!found && this.iterator.hasNext()) {
                T currentValue = this.iterator.next();
                boolean satisfies = this.specification.test(currentValue);
                if (!satisfies) continue;
                found = true;
                this.currentValue = currentValue;
                this.nextConsumed = false;
            }
            if (!found) {
                this.finished = true;
            }
            return found;
        }

        @Override
        public T next() {
            if (!this.nextConsumed) {
                this.nextConsumed = true;
                return this.currentValue;
            }
            if (!this.finished && this.moveToNextValid()) {
                this.nextConsumed = true;
                return this.currentValue;
            }
            throw new NoSuchElementException("This iterator is exhausted.");
        }

        @Override
        public boolean hasNext() {
            return !this.finished && (!this.nextConsumed || this.moveToNextValid());
        }

        @Override
        public void remove() {
        }
    }
}

