/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.collection;

import com.mware.ge.collection.PrefetchingIterator;
import com.mware.ge.function.Predicates;
import java.util.Iterator;
import java.util.function.Predicate;

public class FilteringIterator<T>
extends PrefetchingIterator<T> {
    private final Iterator<T> source;
    private final Predicate<T> predicate;

    public FilteringIterator(Iterator<T> source, Predicate<T> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    protected T fetchNextOrNull() {
        while (this.source.hasNext()) {
            T testItem = this.source.next();
            if (!this.predicate.test(testItem)) continue;
            return testItem;
        }
        return null;
    }

    public static <T> Iterator<T> notNull(Iterator<T> source) {
        return new FilteringIterator<T>(source, Predicates.notNull());
    }

    public static <T> Iterator<T> noDuplicates(Iterator<T> source) {
        return new FilteringIterator<T>(source, Predicates.noDuplicates());
    }
}

