/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.collection;

import com.mware.ge.collection.RawIterator;
import java.util.NoSuchElementException;

public abstract class PrefetchingRawIterator<T, EXCEPTION extends Exception>
implements RawIterator<T, EXCEPTION> {
    boolean hasFetchedNext;
    T nextObject;

    @Override
    public boolean hasNext() throws EXCEPTION {
        return this.peek() != null;
    }

    public T peek() throws EXCEPTION {
        if (this.hasFetchedNext) {
            return this.nextObject;
        }
        this.nextObject = this.fetchNextOrNull();
        this.hasFetchedNext = true;
        return this.nextObject;
    }

    @Override
    public T next() throws EXCEPTION {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.nextObject;
        this.nextObject = null;
        this.hasFetchedNext = false;
        return result;
    }

    protected abstract T fetchNextOrNull() throws EXCEPTION;

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

