/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.collection;

import com.mware.ge.collection.Iterators;
import com.mware.ge.collection.PrefetchingRawIterator;
import com.mware.ge.function.ThrowingSupplier;
import java.util.Iterator;
import java.util.NoSuchElementException;

public interface RawIterator<T, EXCEPTION extends Exception> {
    public static final RawIterator<Object, Exception> EMPTY_ITERATOR = RawIterator.of(new Object[0]);

    public boolean hasNext() throws EXCEPTION;

    public T next() throws EXCEPTION;

    default public void remove() {
        throw new UnsupportedOperationException();
    }

    public static <T, EXCEPTION extends Exception> RawIterator<T, EXCEPTION> empty() {
        return EMPTY_ITERATOR;
    }

    public static <T, EX extends Exception> RawIterator<T, EX> of(final T ... values) {
        return new RawIterator<T, EX>(){
            private int position;

            @Override
            public boolean hasNext() throws Exception {
                return this.position < values.length;
            }

            @Override
            public T next() throws Exception {
                if (this.hasNext()) {
                    return values[this.position++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public static <T, EX extends Exception> RawIterator<T, EX> from(final ThrowingSupplier<T, EX> supplier) {
        return new PrefetchingRawIterator<T, EX>(){

            @Override
            protected T fetchNextOrNull() throws Exception {
                return supplier.get();
            }
        };
    }

    public static <T, EX extends Exception> RawIterator<T, EX> wrap(Iterator<T> iterator) {
        return Iterators.asRawIterator(iterator);
    }
}

