/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.collection;

import com.mware.ge.io.Resource;
import com.mware.ge.io.ResourceIterator;
import com.mware.ge.io.ResourceUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class ResourceClosingIterator<T, V>
implements ResourceIterator<V> {
    private Resource[] resources;
    private final Iterator<T> iterator;

    @Deprecated
    public static <R> ResourceIterator<R> newResourceIterator(Resource resource, Iterator<R> iterator) {
        return ResourceClosingIterator.newResourceIterator(iterator, resource);
    }

    public static <R> ResourceIterator<R> newResourceIterator(Iterator<R> iterator, Resource ... resources) {
        return new ResourceClosingIterator<R, R>(iterator, resources){

            @Override
            public R map(R elem) {
                return elem;
            }
        };
    }

    ResourceClosingIterator(Iterator<T> iterator, Resource ... resources) {
        this.resources = resources;
        this.iterator = iterator;
    }

    @Override
    public void close() {
        if (this.resources != null) {
            ResourceUtils.closeAll((Resource[])this.resources);
            this.resources = null;
        }
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.iterator.hasNext();
        if (!hasNext) {
            this.close();
        }
        return hasNext;
    }

    public abstract V map(T var1);

    @Override
    public V next() {
        try {
            return this.map(this.iterator.next());
        }
        catch (NoSuchElementException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

