/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.csv;

import com.mware.ge.csv.AutoReadingSource;
import com.mware.ge.csv.BufferedCharSeeker;
import com.mware.ge.csv.CharReadable;
import com.mware.ge.csv.CharSeeker;
import com.mware.ge.csv.Configuration;
import com.mware.ge.csv.ThreadAheadReadable;

public class CharSeekers {
    private CharSeekers() {
    }

    public static CharSeeker charSeeker(CharReadable reader, Configuration config, boolean readAhead) {
        if (readAhead) {
            reader = ThreadAheadReadable.threadAhead(reader, config.bufferSize());
        }
        return new BufferedCharSeeker(new AutoReadingSource(reader, config.bufferSize()), config);
    }

    public static CharSeeker charSeeker(CharReadable reader, final int bufferSize, boolean readAhead, final char quotationCharacter) {
        return CharSeekers.charSeeker(reader, new Configuration.Overridden(Configuration.DEFAULT){

            @Override
            public char quotationCharacter() {
                return quotationCharacter;
            }

            @Override
            public int bufferSize() {
                return bufferSize;
            }
        }, readAhead);
    }
}

