/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.csv;

import com.mware.ge.csv.CharReadable;
import com.mware.ge.csv.CharReadableChunker;
import com.mware.ge.csv.Source;
import java.io.IOException;

public class ClosestNewLineChunker
extends CharReadableChunker {
    public ClosestNewLineChunker(CharReadable reader, int chunkSize) {
        super(reader, chunkSize);
    }

    @Override
    public synchronized boolean nextChunk(Source.Chunk chunk) throws IOException {
        int leftToRead;
        CharReadableChunker.ChunkImpl into = (CharReadableChunker.ChunkImpl)chunk;
        int offset = this.fillFromBackBuffer(into.buffer);
        int read = this.reader.read(into.buffer, offset, leftToRead = this.chunkSize - offset);
        if (read == leftToRead) {
            int newlineOffset = ClosestNewLineChunker.offsetOfLastNewline(into.buffer);
            if (newlineOffset > -1) {
                read -= this.storeInBackBuffer(into.data(), newlineOffset + 1, this.chunkSize - (newlineOffset + 1));
            } else {
                throw new IllegalStateException("Weird input data, no newline character in the whole buffer " + this.chunkSize + ", not supported a.t.m.");
            }
        }
        if (read > 0) {
            this.position += (long)read;
            into.initialize(offset += read, this.reader.sourceDescription());
            return true;
        }
        return false;
    }

    private static int offsetOfLastNewline(char[] buffer) {
        for (int i = buffer.length - 1; i >= 0; --i) {
            if (buffer[i] != '\n') continue;
            return i;
        }
        return -1;
    }
}

