/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.csv;

import java.io.IOException;
import java.io.Reader;

public class SectionedCharBuffer {
    private final char[] buffer;
    private final int pivot;
    private int back;
    private int front;

    public SectionedCharBuffer(int effectiveBuffserSize) {
        this.buffer = new char[effectiveBuffserSize * 2];
        this.front = this.pivot = effectiveBuffserSize;
        this.back = this.pivot;
    }

    public char[] array() {
        return this.buffer;
    }

    public void compact(SectionedCharBuffer into, int from) {
        assert (this.buffer.length == into.buffer.length);
        int diff = this.front - from;
        into.back = this.pivot - diff;
        System.arraycopy(this.buffer, from, into.buffer, into.back, diff);
    }

    public void readFrom(Reader reader) throws IOException {
        this.readFrom(reader, this.pivot);
    }

    public void readFrom(Reader reader, int max) throws IOException {
        int read = reader.read(this.buffer, this.pivot, Math.min(max, this.pivot));
        this.front = read == -1 ? this.pivot : this.pivot + read;
    }

    public void append(char ch) {
        this.buffer[this.front++] = ch;
    }

    public int pivot() {
        return this.pivot;
    }

    public int back() {
        return this.back;
    }

    public int front() {
        return this.front;
    }

    public boolean hasAvailable() {
        return this.front > this.pivot;
    }

    public int available() {
        return this.front - this.pivot;
    }
}

