/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.csv;

import com.mware.ge.csv.CharReadable;
import com.mware.ge.csv.SectionedCharBuffer;
import com.mware.ge.csv.ThreadAhead;
import java.io.IOException;

public class ThreadAheadReadable
extends ThreadAhead
implements CharReadable {
    private final CharReadable actual;
    private SectionedCharBuffer theOtherBuffer;
    private String sourceDescription;
    private String newSourceDescription;

    private ThreadAheadReadable(CharReadable actual, int bufferSize) {
        super(actual);
        this.actual = actual;
        this.theOtherBuffer = new SectionedCharBuffer(bufferSize);
        this.sourceDescription = actual.sourceDescription();
        this.start();
    }

    @Override
    public SectionedCharBuffer read(SectionedCharBuffer buffer, int from) throws IOException {
        this.waitUntilReadAhead();
        SectionedCharBuffer resultBuffer = this.theOtherBuffer;
        buffer.compact(resultBuffer, from);
        this.theOtherBuffer = buffer;
        if (this.newSourceDescription != null) {
            this.sourceDescription = this.newSourceDescription;
            this.newSourceDescription = null;
        }
        this.pokeReader();
        return resultBuffer;
    }

    @Override
    public int read(char[] into, int offset, int length) {
        throw new UnsupportedOperationException("Unsupported for now");
    }

    @Override
    protected boolean readAhead() throws IOException {
        this.theOtherBuffer = this.actual.read(this.theOtherBuffer, this.theOtherBuffer.front());
        String sourceDescriptionAfterRead = this.actual.sourceDescription();
        if (!this.sourceDescription.equals(sourceDescriptionAfterRead)) {
            this.newSourceDescription = sourceDescriptionAfterRead;
        }
        return this.theOtherBuffer.hasAvailable();
    }

    @Override
    public long position() {
        return this.actual.position();
    }

    @Override
    public String sourceDescription() {
        return this.sourceDescription;
    }

    public static CharReadable threadAhead(CharReadable actual, int bufferSize) {
        return new ThreadAheadReadable(actual, bufferSize);
    }

    @Override
    public long length() {
        return this.actual.length();
    }
}

