/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.csv;

import com.mware.ge.csv.CharReadable;
import com.mware.ge.csv.SectionedCharBuffer;
import java.io.IOException;
import java.io.Reader;

class WrappedCharReadable
extends CharReadable.Adapter {
    private final long length;
    private final Reader reader;
    private long position;
    private final String sourceDescription;

    WrappedCharReadable(long length, Reader reader) {
        this.length = length;
        this.reader = reader;
        this.sourceDescription = reader.toString();
    }

    @Override
    public SectionedCharBuffer read(SectionedCharBuffer buffer, int from) throws IOException {
        buffer.compact(buffer, from);
        buffer.readFrom(this.reader);
        this.position += (long)buffer.available();
        return buffer;
    }

    @Override
    public int read(char[] into, int offset, int length) throws IOException {
        int totalRead;
        int read;
        boolean eof = false;
        for (totalRead = 0; totalRead < length; totalRead += read) {
            read = this.reader.read(into, offset + totalRead, length - totalRead);
            if (read != -1) continue;
            eof = true;
            break;
        }
        this.position += (long)totalRead;
        return totalRead == 0 && eof ? -1 : totalRead;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public String sourceDescription() {
        return this.sourceDescription;
    }

    @Override
    public long length() {
        return this.length;
    }

    public String toString() {
        return this.sourceDescription;
    }
}

