/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.dependencies;

import com.mware.ge.collection.Iterables;
import com.mware.ge.dependencies.DependencyResolver;
import com.mware.ge.dependencies.DependencySatisfier;
import com.mware.ge.dependencies.UnsatisfiedDependencyException;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.impl.factory.Multimaps;

public class Dependencies
extends DependencyResolver.Adapter
implements DependencySatisfier {
    private final DependencyResolver parent;
    private final MutableListMultimap<Class, Object> typeDependencies;

    public Dependencies() {
        this.typeDependencies = Multimaps.mutable.list.empty();
        this.parent = null;
    }

    public Dependencies(DependencyResolver parent) {
        this.typeDependencies = Multimaps.mutable.list.empty();
        Objects.requireNonNull(parent);
        this.parent = parent;
    }

    @Override
    public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
        MutableList options = this.typeDependencies.get(type);
        if (options.notEmpty()) {
            return selector.select(type, options);
        }
        if (this.parent != null) {
            return this.parent.resolveDependency(type, selector);
        }
        throw new UnsatisfiedDependencyException(type);
    }

    @Override
    public <T> Iterable<? extends T> resolveTypeDependencies(Class<T> type) {
        MutableList options = this.typeDependencies.get(type);
        if (this.parent != null) {
            return Iterables.concat(new Iterable[]{options, this.parent.resolveTypeDependencies(type)});
        }
        return options;
    }

    @Override
    public <T> Supplier<T> provideDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
        return () -> this.resolveDependency(type, selector);
    }

    @Override
    public <T> Supplier<T> provideDependency(Class<T> type) {
        return () -> this.resolveDependency(type);
    }

    @Override
    public <T> T satisfyDependency(T dependency) {
        Class<?> type = dependency.getClass();
        do {
            this.typeDependencies.put(type, dependency);
            Class<?>[] interfaces = type.getInterfaces();
            this.addInterfaces(interfaces, dependency);
        } while ((type = type.getSuperclass()) != null);
        return dependency;
    }

    public void satisfyDependencies(Object ... dependencies) {
        for (Object dependency : dependencies) {
            this.satisfyDependency(dependency);
        }
    }

    private <T> void addInterfaces(Class<?>[] interfaces, T dependency) {
        for (Class<?> type : interfaces) {
            this.typeDependencies.put(type, dependency);
            this.addInterfaces(type.getInterfaces(), dependency);
        }
    }
}

