/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.function;

import com.mware.ge.function.UncaughtCheckedException;
import java.util.Optional;
import java.util.function.Function;

public interface ThrowingFunction<T, R, E extends Exception> {
    public R apply(T var1) throws E;

    public static <T, R, E extends Exception> Function<T, R> catchThrown(Class<E> clazz, ThrowingFunction<T, R, E> throwing) {
        return input -> {
            try {
                return throwing.apply(input);
            }
            catch (Exception e) {
                if (clazz.isInstance(e)) {
                    throw new UncaughtCheckedException(throwing, (Throwable)clazz.cast(e));
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalStateException("Unexpected exception", e);
            }
        };
    }

    public static <E extends Exception> void throwIfPresent(Optional<E> exception) throws E {
        if (exception.isPresent()) {
            throw (Exception)exception.get();
        }
    }
}

