/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.helpers;

import com.mware.ge.function.Predicates;
import java.lang.reflect.Field;
import java.util.function.Predicate;

public class Exceptions {
    public static final Thread.UncaughtExceptionHandler SILENT_UNCAUGHT_EXCEPTION_HANDLER = (t, e) -> {};
    private static final Field THROWABLE_MESSAGE_FIELD;

    private Exceptions() {
        throw new AssertionError((Object)"No instances");
    }

    @Deprecated
    public static <T extends Throwable> T withCause(T exception, Throwable cause) {
        try {
            exception.initCause(cause);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return exception;
    }

    @Deprecated
    public static <T extends Throwable> T withSuppressed(T exception, Throwable ... suppressed) {
        if (suppressed != null) {
            for (Throwable s : suppressed) {
                exception.addSuppressed(s);
            }
        }
        return exception;
    }

    public static boolean contains(Throwable cause, String containsMessage, Class ... anyOfTheseClasses) {
        Predicate anyOfClasses = Predicates.instanceOfAny(anyOfTheseClasses);
        return Exceptions.contains(cause, (Throwable item) -> item.getMessage() != null && item.getMessage().contains(containsMessage) && anyOfClasses.test(item));
    }

    public static boolean contains(Throwable cause, Class ... anyOfTheseClasses) {
        return Exceptions.contains(cause, Predicates.instanceOfAny(anyOfTheseClasses));
    }

    public static boolean contains(Throwable cause, Predicate<Throwable> toLookFor) {
        while (cause != null) {
            if (toLookFor.test(cause)) {
                return true;
            }
            cause = cause.getCause();
        }
        return false;
    }

    public static <T extends Throwable> T chain(T initial, T current) {
        if (initial == null) {
            return current;
        }
        if (current != null) {
            initial.addSuppressed(current);
        }
        return initial;
    }

    public static <T extends Throwable> T withMessage(T cause, String message) {
        Exceptions.setMessage(cause, message);
        return cause;
    }

    public static void setMessage(Throwable cause, String message) {
        try {
            THROWABLE_MESSAGE_FIELD.set(cause, message);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            THROWABLE_MESSAGE_FIELD = Throwable.class.getDeclaredField("detailMessage");
            THROWABLE_MESSAGE_FIELD.setAccessible(true);
        }
        catch (Exception e2) {
            throw new LinkageError("Could not get Throwable message field", e2);
        }
    }
}

