/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.inmemory;

import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.EdgeVertices;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Vertex;
import com.mware.ge.inmemory.InMemoryElement;
import com.mware.ge.inmemory.InMemoryGraph;
import com.mware.ge.inmemory.InMemoryTableEdge;
import com.mware.ge.inmemory.mutations.AlterEdgeLabelMutation;
import com.mware.ge.inmemory.mutations.EdgeSetupMutation;
import com.mware.ge.mutation.ExistingEdgeMutation;
import com.mware.ge.search.IndexHint;

public class InMemoryEdge
extends InMemoryElement<InMemoryEdge>
implements Edge {
    private final EdgeSetupMutation edgeSetupMutation;

    public InMemoryEdge(InMemoryGraph graph, String id, InMemoryTableEdge inMemoryTableElement, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        super(graph, id, inMemoryTableElement, fetchHints, endTime, authorizations);
        this.edgeSetupMutation = inMemoryTableElement.findLastMutation(EdgeSetupMutation.class);
    }

    @Override
    public String getLabel() {
        return this.getInMemoryTableElement().findLastMutation(AlterEdgeLabelMutation.class).getNewEdgeLabel();
    }

    @Override
    public String getVertexId(Direction direction) {
        switch (direction) {
            case IN: {
                return this.edgeSetupMutation.getInVertexId();
            }
            case OUT: {
                return this.edgeSetupMutation.getOutVertexId();
            }
        }
        throw new IllegalArgumentException("Unexpected direction: " + (Object)((Object)direction));
    }

    @Override
    public Vertex getVertex(Direction direction, Authorizations authorizations) {
        return this.getVertex(direction, this.getGraph().getDefaultFetchHints(), authorizations);
    }

    @Override
    public String getOtherVertexId(String myVertexId) {
        if (this.edgeSetupMutation.getInVertexId().equals(myVertexId)) {
            return this.edgeSetupMutation.getOutVertexId();
        }
        if (this.edgeSetupMutation.getOutVertexId().equals(myVertexId)) {
            return this.edgeSetupMutation.getInVertexId();
        }
        throw new GeException("myVertexId does not appear on either the in or the out.");
    }

    @Override
    public EdgeVertices getVertices(FetchHints fetchHints, Authorizations authorizations) {
        return new EdgeVertices(this.getVertex(Direction.OUT, authorizations), this.getVertex(Direction.IN, authorizations));
    }

    @Override
    public ExistingEdgeMutation prepareMutation() {
        return new ExistingEdgeMutation(this){

            @Override
            public Edge save(Authorizations authorizations) {
                IndexHint indexHint = this.getIndexHint();
                InMemoryEdge.this.saveExistingElementMutation(this, indexHint, authorizations);
                Edge edge = (Edge)this.getElement();
                if (indexHint != IndexHint.DO_NOT_INDEX) {
                    InMemoryEdge.this.getGraph().updateElementAndExtendedDataInSearchIndex(edge, this, authorizations);
                }
                return edge;
            }
        };
    }
}

