/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.inmemory;

import com.google.common.collect.ImmutableSet;
import com.mware.ge.Authorizations;
import com.mware.ge.EdgeBuilderBase;
import com.mware.ge.Element;
import com.mware.ge.ElementBase;
import com.mware.ge.ElementType;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.ExtendedDataRowId;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.GeMissingFetchHintException;
import com.mware.ge.HistoricalPropertyValue;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.VertexBuilder;
import com.mware.ge.Visibility;
import com.mware.ge.inmemory.InMemoryGraph;
import com.mware.ge.inmemory.InMemoryTableEdge;
import com.mware.ge.inmemory.InMemoryTableElement;
import com.mware.ge.inmemory.InMemoryTableVertex;
import com.mware.ge.mutation.EdgeMutation;
import com.mware.ge.mutation.ExistingElementMutation;
import com.mware.ge.mutation.ExistingElementMutationImpl;
import com.mware.ge.mutation.ExtendedDataDeleteMutation;
import com.mware.ge.mutation.ExtendedDataMutation;
import com.mware.ge.mutation.PropertyDeleteMutation;
import com.mware.ge.mutation.PropertySoftDeleteMutation;
import com.mware.ge.mutation.VertexMutation;
import com.mware.ge.query.ExtendedDataQueryableIterable;
import com.mware.ge.query.QueryableIterable;
import com.mware.ge.search.IndexHint;
import com.mware.ge.values.storable.Value;
import org.apache.commons.lang3.StringUtils;

public abstract class InMemoryElement<TElement extends InMemoryElement>
extends ElementBase {
    private final String id;
    private final FetchHints fetchHints;
    private transient InMemoryGraph graph;
    private InMemoryTableElement<TElement> inMemoryTableElement;
    private final Long endTime;
    private final Authorizations authorizations;

    protected InMemoryElement(InMemoryGraph graph, String id, InMemoryTableElement<TElement> inMemoryTableElement, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        this.graph = graph;
        this.id = id;
        this.fetchHints = fetchHints;
        this.endTime = endTime;
        this.authorizations = authorizations;
        this.inMemoryTableElement = inMemoryTableElement;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Visibility getVisibility() {
        return this.inMemoryTableElement.getVisibility();
    }

    @Override
    public long getTimestamp() {
        return this.inMemoryTableElement.getTimestamp();
    }

    @Override
    public Long getEndTime() {
        return this.endTime;
    }

    @Override
    public void deleteProperty(String key, String name, Visibility visibility, Authorizations authorizations) {
        this.getGraph().deleteProperty(this, this.inMemoryTableElement, key, name, visibility, authorizations);
    }

    @Override
    public void softDeleteProperty(String key, String name, Visibility visibility, Authorizations authorizations) {
        this.softDeleteProperty(key, name, null, visibility, IndexHint.INDEX, authorizations);
    }

    protected void softDeleteProperty(String key, String name, Long timestamp, Visibility visibility, IndexHint indexHint, Authorizations authorizations) {
        Property property = this.getProperty(key, name, visibility);
        if (property != null) {
            this.getGraph().softDeleteProperty(this.inMemoryTableElement, property, timestamp, indexHint, authorizations);
        }
    }

    private void deleteExtendedData(String tableName, String row, String columnName, String key, Visibility visibility) {
        if (StringUtils.isEmpty((CharSequence)columnName)) {
            this.getGraph().deleteExtendedDataRow(new ExtendedDataRowId(this.getElementType(), this.getId(), tableName, row), this.authorizations);
        } else {
            this.getGraph().deleteExtendedData(this, tableName, row, columnName, key, visibility, this.authorizations);
        }
    }

    protected void extendedData(ExtendedDataMutation extendedData, Authorizations authorizations) {
        ExtendedDataRowId extendedDataRowId = new ExtendedDataRowId(ElementType.getTypeFromElement(this), this.getId(), extendedData.getTableName(), extendedData.getRow());
        this.getGraph().extendedData(this, extendedDataRowId, extendedData, authorizations);
    }

    @Override
    public void markPropertyHidden(Property property, Long timestamp, Visibility visibility, Authorizations authorizations) {
        this.getGraph().markPropertyHidden(this, this.inMemoryTableElement, property, timestamp, visibility, authorizations);
    }

    @Override
    public void markPropertyVisible(Property property, Long timestamp, Visibility visibility, Authorizations authorizations) {
        this.getGraph().markPropertyVisible(this, this.inMemoryTableElement, property.getKey(), property.getName(), property.getVisibility(), timestamp, visibility, authorizations);
    }

    @Override
    public Value getPropertyValue(String name) {
        Property p = this.getProperty(name);
        return p == null ? null : p.getValue();
    }

    @Override
    public Value getPropertyValue(String key, String name) {
        Property p = this.getProperty(key, name);
        return p == null ? null : p.getValue();
    }

    public void addPropertyValue(String key, String name, Value value, Metadata metadata, Visibility visibility, Long timestamp, boolean indexAfterAdd, Authorizations authorizations) {
        this.getGraph().addPropertyValue(this, this.inMemoryTableElement, key, name, value, metadata, visibility, timestamp, authorizations);
        if (indexAfterAdd) {
            this.getGraph().getSearchIndex().addElement(this.getGraph(), this, authorizations);
        }
    }

    @Override
    public void markPropertyVisible(String key, String name, Visibility propertyVisibility, Long timestamp, Visibility visibility, Authorizations authorizations) {
        this.getGraph().markPropertyVisible(this, this.inMemoryTableElement, key, name, propertyVisibility, timestamp, visibility, authorizations);
    }

    @Override
    public boolean isHidden(Authorizations authorizations) {
        return this.inMemoryTableElement.isHidden(authorizations);
    }

    @Override
    public Iterable<Property> getProperties() {
        if (!this.getFetchHints().isIncludeProperties()) {
            throw new GeMissingFetchHintException(this.getFetchHints(), "includeProperties");
        }
        return this.inMemoryTableElement.getProperties(this.fetchHints, this.endTime, this.authorizations);
    }

    @Override
    public Iterable<HistoricalPropertyValue> getHistoricalPropertyValues(String key, String name, Visibility visibility, Long startTime, Long endTime, Authorizations authorizations) {
        return this.inMemoryTableElement.getHistoricalPropertyValues(key, name, visibility, startTime, endTime, authorizations);
    }

    @Override
    public abstract <T extends Element> ExistingElementMutation<T> prepareMutation();

    @Override
    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    @Override
    public InMemoryGraph getGraph() {
        return this.graph;
    }

    void updatePropertiesInternal(VertexBuilder vertexBuilder) {
        this.updatePropertiesInternal(vertexBuilder.getProperties(), vertexBuilder.getPropertyDeletes(), vertexBuilder.getPropertySoftDeletes(), vertexBuilder.getExtendedData(), vertexBuilder.getExtendedDataDeletes(), vertexBuilder.getIndexHint());
    }

    void updatePropertiesInternal(EdgeBuilderBase edgeBuilder) {
        this.updatePropertiesInternal(edgeBuilder.getProperties(), edgeBuilder.getPropertyDeletes(), edgeBuilder.getPropertySoftDeletes(), edgeBuilder.getExtendedData(), edgeBuilder.getExtendedDataDeletes(), edgeBuilder.getIndexHint());
    }

    protected void updatePropertiesInternal(Iterable<Property> properties, Iterable<PropertyDeleteMutation> propertyDeleteMutations, Iterable<PropertySoftDeleteMutation> propertySoftDeleteMutations, Iterable<ExtendedDataMutation> extendedDatas, Iterable<ExtendedDataDeleteMutation> extendedDataDeletes, IndexHint indexHint) {
        for (Property property : properties) {
            this.addPropertyValue(property.getKey(), property.getName(), property.getValue(), property.getMetadata(), property.getVisibility(), property.getTimestamp(), false, this.authorizations);
        }
        for (PropertyDeleteMutation propertyDeleteMutation : propertyDeleteMutations) {
            this.deleteProperty(propertyDeleteMutation.getKey(), propertyDeleteMutation.getName(), propertyDeleteMutation.getVisibility(), this.authorizations);
        }
        for (PropertySoftDeleteMutation propertySoftDeleteMutation : propertySoftDeleteMutations) {
            this.softDeleteProperty(propertySoftDeleteMutation.getKey(), propertySoftDeleteMutation.getName(), propertySoftDeleteMutation.getTimestamp(), propertySoftDeleteMutation.getVisibility(), indexHint, this.authorizations);
        }
        for (ExtendedDataMutation extendedData : extendedDatas) {
            this.getGraph().ensurePropertyDefined(extendedData.getColumnName(), extendedData.getValue());
            this.extendedData(extendedData, this.authorizations);
        }
        for (ExtendedDataDeleteMutation extendedDataDelete : extendedDataDeletes) {
            this.deleteExtendedData(extendedDataDelete.getTableName(), extendedDataDelete.getRow(), extendedDataDelete.getColumnName(), extendedDataDelete.getKey(), extendedDataDelete.getVisibility());
        }
    }

    protected <T extends Element> void saveExistingElementMutation(ExistingElementMutationImpl<T> mutation, IndexHint indexHint, Authorizations authorizations) {
        VertexMutation vertexMutation;
        EdgeMutation edgeMutation;
        if (mutation.getElement() != this) {
            throw new GeException("cannot save mutation from another element");
        }
        this.graph.alterElementPropertyMetadata(this.inMemoryTableElement, mutation.getSetPropertyMetadatas(), authorizations);
        this.graph.alterElementPropertyVisibilities(this.inMemoryTableElement, mutation.getAlterPropertyVisibilities(), authorizations);
        Iterable<Property> properties = mutation.getProperties();
        Iterable<PropertyDeleteMutation> propertyDeleteMutations = mutation.getPropertyDeletes();
        Iterable<PropertySoftDeleteMutation> propertySoftDeleteMutations = mutation.getPropertySoftDeletes();
        this.updatePropertiesInternal(properties, propertyDeleteMutations, propertySoftDeleteMutations, mutation.getExtendedData(), mutation.getExtendedDataDeletes(), indexHint);
        InMemoryGraph graph = this.getGraph();
        if (mutation.getNewElementVisibility() != null) {
            graph.alterElementVisibility(this.inMemoryTableElement, mutation.getNewElementVisibility());
        }
        if (mutation instanceof EdgeMutation && (edgeMutation = (EdgeMutation)((Object)mutation)).getNewEdgeLabel() != null) {
            graph.alterEdgeLabel((InMemoryTableEdge)this.inMemoryTableElement, edgeMutation.getAlterEdgeLabelTimestamp(), edgeMutation.getNewEdgeLabel());
        }
        if (mutation instanceof VertexMutation && (vertexMutation = (VertexMutation)((Object)mutation)).getNewConceptType() != null) {
            graph.alterConceptType((InMemoryTableVertex)this.inMemoryTableElement, vertexMutation.getAlterConceptTypeTimestamp(), vertexMutation.getNewConceptType());
        }
    }

    public boolean canRead(Authorizations authorizations) {
        return this.inMemoryTableElement.canRead(this.getFetchHints(), authorizations);
    }

    @Override
    public Iterable<Visibility> getHiddenVisibilities() {
        return this.inMemoryTableElement.getHiddenVisibilities();
    }

    @Override
    public FetchHints getFetchHints() {
        return this.fetchHints;
    }

    protected InMemoryTableElement<TElement> getInMemoryTableElement() {
        return this.inMemoryTableElement;
    }

    protected void setInMemoryTableElement(InMemoryTableElement<TElement> inMemoryTableElement) {
        this.inMemoryTableElement = inMemoryTableElement;
    }

    @Override
    public ImmutableSet<String> getExtendedDataTableNames() {
        if (!this.getFetchHints().isIncludeExtendedDataTableNames()) {
            throw new GeMissingFetchHintException(this.getFetchHints(), "includeExtendedDataTableNames");
        }
        return this.graph.getExtendedDataTableNames(ElementType.getTypeFromElement(this), this.id, this.getFetchHints(), this.authorizations);
    }

    @Override
    public QueryableIterable<ExtendedDataRow> getExtendedData(String tableName, FetchHints fetchHints) {
        return new ExtendedDataQueryableIterable(this.getGraph(), this, tableName, this.graph.getExtendedDataTable(ElementType.getTypeFromElement(this), this.id, tableName, fetchHints, this.authorizations));
    }
}

