/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.inmemory;

import com.mware.ge.Authorizations;
import com.mware.ge.ExtendedDataRowBase;
import com.mware.ge.ExtendedDataRowId;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.security.ColumnVisibility;
import com.mware.ge.security.VisibilityEvaluator;
import com.mware.ge.security.VisibilityParseException;
import com.mware.ge.values.storable.Value;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;

public class InMemoryExtendedDataRow
extends ExtendedDataRowBase {
    private final ExtendedDataRowId id;
    private ReadWriteLock propertiesLock = new ReentrantReadWriteLock();
    private Set<InMemoryProperty> properties = new HashSet<InMemoryProperty>();

    public InMemoryExtendedDataRow(ExtendedDataRowId id, FetchHints fetchHints) {
        super(fetchHints);
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canRead(VisibilityEvaluator visibilityEvaluator, FetchHints fetchHints) {
        this.propertiesLock.readLock().lock();
        try {
            boolean bl = this.properties.stream().anyMatch(e -> e.canRead(visibilityEvaluator));
            return bl;
        }
        finally {
            this.propertiesLock.readLock().unlock();
        }
    }

    @Override
    public ExtendedDataRowId getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InMemoryExtendedDataRow toReadable(VisibilityEvaluator visibilityEvaluator, FetchHints fetchHints) {
        this.propertiesLock.readLock().lock();
        try {
            InMemoryExtendedDataRow row = new InMemoryExtendedDataRow(this.getId(), this.getFetchHints());
            for (InMemoryProperty column : this.properties) {
                if (!column.canRead(visibilityEvaluator)) continue;
                row.properties.add(column);
            }
            InMemoryExtendedDataRow inMemoryExtendedDataRow = row;
            return inMemoryExtendedDataRow;
        }
        finally {
            this.propertiesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumn(String propertyName, String key, Value value, long timestamp, Visibility visibility) {
        this.propertiesLock.writeLock().lock();
        try {
            InMemoryProperty prop = new InMemoryProperty(propertyName, key, value, FetchHints.ALL, timestamp, visibility);
            this.properties.remove(prop);
            this.properties.add(prop);
        }
        finally {
            this.propertiesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeColumn(String columnName, String key, Visibility visibility) {
        this.propertiesLock.writeLock().lock();
        try {
            this.properties.removeIf(p -> p.getName().equals(columnName) && p.getVisibility().equals(visibility) && (key == null && p.getKey() == null || key != null && key.equals(p.getKey())));
        }
        finally {
            this.propertiesLock.writeLock().unlock();
        }
    }

    @Override
    public Iterable<Property> getProperties() {
        this.propertiesLock.readLock().lock();
        try {
            Iterable iterable = this.properties.stream().map(p -> p).collect(Collectors.toList());
            return iterable;
        }
        finally {
            this.propertiesLock.readLock().unlock();
        }
    }

    private static class InMemoryProperty
    extends Property {
        private final String name;
        private final String key;
        private final Long timestamp;
        private final Value value;
        private final Visibility visibility;
        private final ColumnVisibility columnVisibility;
        private final FetchHints fetchHints;

        public InMemoryProperty(String name, String key, Value value, FetchHints fetchHints, long timestamp, Visibility visibility) {
            this.name = name;
            this.key = key;
            this.value = value;
            this.fetchHints = fetchHints;
            this.timestamp = timestamp;
            this.visibility = visibility;
            this.columnVisibility = new ColumnVisibility(visibility.getVisibilityString());
        }

        public boolean canRead(VisibilityEvaluator visibilityEvaluator) {
            try {
                return visibilityEvaluator.evaluate(this.columnVisibility);
            }
            catch (VisibilityParseException e) {
                throw new GeException("could not evaluate visibility " + this.visibility.getVisibilityString(), e);
            }
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Value getValue() {
            return this.value;
        }

        @Override
        public Long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public FetchHints getFetchHints() {
            return this.fetchHints;
        }

        @Override
        public Visibility getVisibility() {
            return this.visibility;
        }

        @Override
        public Metadata getMetadata() {
            return Metadata.create(this.getFetchHints());
        }

        @Override
        public Iterable<Visibility> getHiddenVisibilities() {
            return new ArrayList<Visibility>();
        }

        @Override
        public boolean isHidden(Authorizations authorizations) {
            return false;
        }
    }
}

