/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.inmemory;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.EdgeBuilder;
import com.mware.ge.EdgeBuilderBase;
import com.mware.ge.EdgeBuilderByVertexId;
import com.mware.ge.Element;
import com.mware.ge.ElementType;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.ExtendedDataRowId;
import com.mware.ge.FetchHints;
import com.mware.ge.FindPathOptions;
import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.GraphBaseWithSearchIndex;
import com.mware.ge.GraphConfiguration;
import com.mware.ge.GraphMetadataStore;
import com.mware.ge.Metadata;
import com.mware.ge.Path;
import com.mware.ge.ProgressCallback;
import com.mware.ge.Property;
import com.mware.ge.SecurityGeException;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.Visibility;
import com.mware.ge.event.AddEdgeEvent;
import com.mware.ge.event.AddExtendedDataEvent;
import com.mware.ge.event.AddPropertyEvent;
import com.mware.ge.event.AddVertexEvent;
import com.mware.ge.event.DeleteEdgeEvent;
import com.mware.ge.event.DeleteExtendedDataEvent;
import com.mware.ge.event.DeleteExtendedDataRowEvent;
import com.mware.ge.event.DeletePropertyEvent;
import com.mware.ge.event.DeleteVertexEvent;
import com.mware.ge.event.MarkHiddenEdgeEvent;
import com.mware.ge.event.MarkHiddenPropertyEvent;
import com.mware.ge.event.MarkHiddenVertexEvent;
import com.mware.ge.event.MarkVisibleEdgeEvent;
import com.mware.ge.event.MarkVisiblePropertyEvent;
import com.mware.ge.event.MarkVisibleVertexEvent;
import com.mware.ge.event.SoftDeleteEdgeEvent;
import com.mware.ge.event.SoftDeletePropertyEvent;
import com.mware.ge.event.SoftDeleteVertexEvent;
import com.mware.ge.id.IdGenerator;
import com.mware.ge.id.UUIDIdGenerator;
import com.mware.ge.inmemory.InMemoryEdge;
import com.mware.ge.inmemory.InMemoryEdgeTable;
import com.mware.ge.inmemory.InMemoryElement;
import com.mware.ge.inmemory.InMemoryExtendedDataTable;
import com.mware.ge.inmemory.InMemoryGraphConfiguration;
import com.mware.ge.inmemory.InMemoryGraphMetadataStore;
import com.mware.ge.inmemory.InMemoryStreamingPropertyValueRef;
import com.mware.ge.inmemory.InMemoryTableEdge;
import com.mware.ge.inmemory.InMemoryTableElement;
import com.mware.ge.inmemory.InMemoryTableVertex;
import com.mware.ge.inmemory.InMemoryVertex;
import com.mware.ge.inmemory.InMemoryVertexTable;
import com.mware.ge.inmemory.MapInMemoryExtendedDataTable;
import com.mware.ge.inmemory.mutations.AlterConceptTypeMutation;
import com.mware.ge.inmemory.mutations.AlterEdgeLabelMutation;
import com.mware.ge.inmemory.mutations.AlterVisibilityMutation;
import com.mware.ge.inmemory.mutations.EdgeSetupMutation;
import com.mware.ge.inmemory.mutations.ElementTimestampMutation;
import com.mware.ge.mutation.AlterPropertyVisibility;
import com.mware.ge.mutation.ElementMutation;
import com.mware.ge.mutation.ExistingElementMutation;
import com.mware.ge.mutation.ExtendedDataDeleteMutation;
import com.mware.ge.mutation.ExtendedDataMutation;
import com.mware.ge.mutation.SetPropertyMetadata;
import com.mware.ge.property.PropertyDescriptor;
import com.mware.ge.search.IndexHint;
import com.mware.ge.search.SearchIndex;
import com.mware.ge.util.ArrayUtils;
import com.mware.ge.util.ConvertingIterable;
import com.mware.ge.util.IncreasingTime;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.util.LookAheadIterable;
import com.mware.ge.util.Preconditions;
import com.mware.ge.util.StreamUtils;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.StreamingPropertyValueRef;
import com.mware.ge.values.storable.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class InMemoryGraph
extends GraphBaseWithSearchIndex {
    protected static final InMemoryGraphConfiguration DEFAULT_CONFIGURATION = new InMemoryGraphConfiguration(new HashMap<String, Object>());
    private final Set<String> validAuthorizations = new HashSet<String>();
    private final InMemoryVertexTable verticesTable;
    private final InMemoryEdgeTable edgesTable;
    private final InMemoryExtendedDataTable extendedDataTable;
    private final GraphMetadataStore graphMetadataStore;

    protected InMemoryGraph(InMemoryGraphConfiguration configuration) {
        this(configuration, new InMemoryVertexTable(), new InMemoryEdgeTable(), new MapInMemoryExtendedDataTable());
    }

    protected InMemoryGraph(InMemoryGraphConfiguration configuration, IdGenerator idGenerator, SearchIndex searchIndex) {
        this(configuration, idGenerator, searchIndex, new InMemoryVertexTable(), new InMemoryEdgeTable(), new MapInMemoryExtendedDataTable());
    }

    protected InMemoryGraph(InMemoryGraphConfiguration configuration, InMemoryVertexTable verticesTable, InMemoryEdgeTable edgesTable, InMemoryExtendedDataTable extendedDataTable) {
        super(configuration);
        this.verticesTable = verticesTable;
        this.edgesTable = edgesTable;
        this.extendedDataTable = extendedDataTable;
        this.graphMetadataStore = this.newGraphMetadataStore(configuration);
    }

    protected InMemoryGraph(InMemoryGraphConfiguration configuration, IdGenerator idGenerator, SearchIndex searchIndex, InMemoryVertexTable verticesTable, InMemoryEdgeTable edgesTable, InMemoryExtendedDataTable extendedDataTable) {
        super(configuration, idGenerator, searchIndex);
        this.verticesTable = verticesTable;
        this.edgesTable = edgesTable;
        this.extendedDataTable = extendedDataTable;
        this.graphMetadataStore = this.newGraphMetadataStore(configuration);
    }

    protected GraphMetadataStore newGraphMetadataStore(GraphConfiguration configuration) {
        return new InMemoryGraphMetadataStore();
    }

    public static InMemoryGraph create() {
        DEFAULT_CONFIGURATION.set("idgenerator", UUIDIdGenerator.class.getName());
        return InMemoryGraph.create(DEFAULT_CONFIGURATION);
    }

    public static InMemoryGraph create(InMemoryGraphConfiguration config) {
        InMemoryGraph graph = new InMemoryGraph(config);
        graph.setup();
        return graph;
    }

    public static InMemoryGraph create(Map<String, Object> config) {
        return InMemoryGraph.create(new InMemoryGraphConfiguration(config));
    }

    public static InMemoryGraph create(InMemoryGraphConfiguration config, IdGenerator idGenerator, SearchIndex searchIndex) {
        InMemoryGraph graph = new InMemoryGraph(config, idGenerator, searchIndex);
        graph.setup();
        return graph;
    }

    @Override
    public VertexBuilder prepareVertex(String vertexId, Long timestamp, Visibility visibility, String conceptType) {
        if (vertexId == null) {
            vertexId = this.getIdGenerator().nextId();
        }
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        final long timestampLong = timestamp;
        return new VertexBuilder(vertexId, conceptType, visibility){

            @Override
            public Vertex save(Authorizations authorizations) {
                InMemoryGraph.this.addValidAuthorizations(authorizations.getAuthorizations());
                boolean isNew = false;
                InMemoryTableElement vertexTableElement = InMemoryGraph.this.verticesTable.getTableElement(this.getId());
                if (vertexTableElement == null) {
                    isNew = true;
                    InMemoryGraph.this.verticesTable.append(this.getId(), new AlterVisibilityMutation(timestampLong, this.getVisibility()), new ElementTimestampMutation(timestampLong), new AlterConceptTypeMutation(timestampLong, this.getConceptType()));
                } else if (vertexTableElement.getVisibility().equals(this.getVisibility())) {
                    InMemoryGraph.this.verticesTable.append(this.getId(), new ElementTimestampMutation(timestampLong));
                } else {
                    InMemoryGraph.this.verticesTable.append(this.getId(), new AlterVisibilityMutation(timestampLong, this.getVisibility()), new ElementTimestampMutation(timestampLong));
                }
                if (this.getNewConceptType() != null) {
                    InMemoryGraph.this.verticesTable.append(this.getId(), new AlterConceptTypeMutation(timestampLong, this.getNewConceptType()));
                }
                InMemoryVertex vertex = (InMemoryVertex)InMemoryGraph.this.verticesTable.get(InMemoryGraph.this, this.getId(), FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
                if (isNew && InMemoryGraph.this.hasEventListeners()) {
                    InMemoryGraph.this.fireGraphEvent(new AddVertexEvent(InMemoryGraph.this, vertex));
                }
                vertex.updatePropertiesInternal(this);
                if (this.getIndexHint() != IndexHint.DO_NOT_INDEX) {
                    InMemoryGraph.this.updateElementAndExtendedDataInSearchIndex(vertex, this, authorizations);
                }
                return vertex;
            }
        };
    }

    <T extends Element> void updateElementAndExtendedDataInSearchIndex(Element element, ElementMutation<T> elementMutation, Authorizations authorizations) {
        if (elementMutation instanceof ExistingElementMutation) {
            this.getSearchIndex().updateElement(this, (ExistingElementMutation)elementMutation, authorizations);
        } else {
            this.getSearchIndex().addElement(this, element, authorizations);
        }
        this.getSearchIndex().addElementExtendedData(this, element, elementMutation.getExtendedData(), authorizations);
        for (ExtendedDataDeleteMutation m : elementMutation.getExtendedDataDeletes()) {
            if (StringUtils.isEmpty((CharSequence)m.getColumnName())) {
                this.deleteExtendedDataRow(new ExtendedDataRowId(element.getElementType(), (String)element.getId(), m.getTableName(), m.getRow()), authorizations);
                continue;
            }
            this.deleteExtendedData((InMemoryElement)element, m.getTableName(), m.getRow(), m.getColumnName(), m.getKey(), m.getVisibility(), authorizations);
        }
    }

    private void addValidAuthorizations(String[] authorizations) {
        Collections.addAll(this.validAuthorizations, authorizations);
    }

    @Override
    public Iterable<Vertex> getVertices(FetchHints fetchHints, Long endTime, Authorizations authorizations) throws GeException {
        this.validateAuthorizations(authorizations);
        return new ConvertingIterable<InMemoryVertex, Vertex>(this.verticesTable.getAll(this, fetchHints, endTime, authorizations)){

            @Override
            protected Vertex convert(InMemoryVertex o) {
                return o;
            }
        };
    }

    @Override
    public Iterable<String> getVertexIds(Authorizations authorizations) {
        this.validateAuthorizations(authorizations);
        return new ConvertingIterable<InMemoryVertex, String>(this.verticesTable.getAll(this, FetchHints.NONE, null, authorizations)){

            @Override
            protected String convert(InMemoryVertex o) {
                return o.getId();
            }
        };
    }

    protected void validateAuthorizations(Authorizations authorizations) {
        for (String auth : authorizations.getAuthorizations()) {
            if (this.validAuthorizations.contains(auth)) continue;
            throw new SecurityGeException("Invalid authorizations", authorizations);
        }
    }

    @Override
    public void deleteVertex(Vertex vertex, Authorizations authorizations) {
        if (!((InMemoryVertex)vertex).canRead(authorizations)) {
            return;
        }
        List<Edge> edgesToDelete = IterableUtils.toList(vertex.getEdges(Direction.BOTH, authorizations));
        for (Edge edgeToDelete : edgesToDelete) {
            this.deleteEdge(edgeToDelete, authorizations);
        }
        this.deleteAllExtendedDataForElement(vertex, authorizations);
        this.verticesTable.remove((String)vertex.getId());
        this.getSearchIndex().deleteElement(this, vertex, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent(new DeleteVertexEvent(this, vertex));
        }
    }

    @Override
    public void softDeleteVertex(Vertex vertex, Long timestamp, Authorizations authorizations) {
        if (!((InMemoryVertex)vertex).canRead(authorizations)) {
            return;
        }
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        for (Property property : vertex.getProperties()) {
            vertex.softDeleteProperty(property.getKey(), property.getName(), property.getVisibility(), authorizations);
        }
        List<Edge> edgesToSoftDelete = IterableUtils.toList(vertex.getEdges(Direction.BOTH, authorizations));
        for (Edge edgeToSoftDelete : edgesToSoftDelete) {
            this.softDeleteEdge(edgeToSoftDelete, timestamp, authorizations);
        }
        this.verticesTable.getTableElement((String)vertex.getId()).appendSoftDeleteMutation(timestamp);
        this.getSearchIndex().deleteElement(this, vertex, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent(new SoftDeleteVertexEvent(this, vertex));
        }
    }

    @Override
    public void markVertexHidden(Vertex vertex, Visibility visibility, Authorizations authorizations) {
        if (!((InMemoryVertex)vertex).canRead(authorizations)) {
            return;
        }
        List<Edge> edgesToMarkHidden = IterableUtils.toList(vertex.getEdges(Direction.BOTH, authorizations));
        for (Edge edgeToMarkHidden : edgesToMarkHidden) {
            this.markEdgeHidden(edgeToMarkHidden, visibility, authorizations);
        }
        this.verticesTable.getTableElement((String)vertex.getId()).appendMarkHiddenMutation(visibility);
        this.refreshVertexInMemoryTableElement(vertex);
        this.getSearchIndex().markElementHidden(this, vertex, visibility, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent(new MarkHiddenVertexEvent(this, vertex));
        }
    }

    @Override
    public void markVertexVisible(Vertex vertex, Visibility visibility, Authorizations authorizations) {
        if (!((InMemoryVertex)vertex).canRead(authorizations)) {
            return;
        }
        List<Edge> edgesToMarkVisible = IterableUtils.toList(vertex.getEdges(Direction.BOTH, FetchHints.ALL_INCLUDING_HIDDEN, authorizations));
        for (Edge edgeToMarkVisible : edgesToMarkVisible) {
            this.markEdgeVisible(edgeToMarkVisible, visibility, authorizations);
        }
        this.verticesTable.getTableElement((String)vertex.getId()).appendMarkVisibleMutation(visibility);
        this.refreshVertexInMemoryTableElement(vertex);
        this.getSearchIndex().markElementVisible(this, vertex, visibility, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent(new MarkVisibleVertexEvent(this, vertex));
        }
    }

    public void markPropertyHidden(InMemoryElement element, InMemoryTableElement inMemoryTableElement, Property property, Long timestamp, Visibility visibility, Authorizations authorizations) {
        if (!element.canRead(authorizations)) {
            return;
        }
        Property hiddenProperty = inMemoryTableElement.appendMarkPropertyHiddenMutation(property.getKey(), property.getName(), property.getVisibility(), timestamp, visibility, authorizations);
        this.getSearchIndex().markPropertyHidden(this, element, property, visibility, authorizations);
        if (hiddenProperty != null && this.hasEventListeners()) {
            this.fireGraphEvent(new MarkHiddenPropertyEvent(this, element, hiddenProperty, visibility));
        }
    }

    public void markPropertyVisible(InMemoryElement element, InMemoryTableElement inMemoryTableElement, String key, String name, Visibility propertyVisibility, Long timestamp, Visibility visibility, Authorizations authorizations) {
        if (!element.canRead(authorizations)) {
            return;
        }
        Property property = inMemoryTableElement.appendMarkPropertyVisibleMutation(key, name, propertyVisibility, timestamp, visibility, authorizations);
        this.getSearchIndex().markPropertyVisible(this, element, property, visibility, authorizations);
        if (property != null && this.hasEventListeners()) {
            this.fireGraphEvent(new MarkVisiblePropertyEvent(this, element, property, visibility));
        }
    }

    @Override
    public EdgeBuilderByVertexId prepareEdge(String edgeId, String outVertexId, String inVertexId, String label, final Long timestamp, Visibility visibility) {
        Preconditions.checkNotNull(outVertexId, "outVertexId cannot be null");
        Preconditions.checkNotNull(inVertexId, "inVertexId cannot be null");
        Preconditions.checkNotNull(label, "label cannot be null");
        if (edgeId == null) {
            edgeId = this.getIdGenerator().nextId();
        }
        return new EdgeBuilderByVertexId(edgeId, outVertexId, inVertexId, label, visibility){

            @Override
            public Edge save(Authorizations authorizations) {
                InMemoryGraph.this.addValidAuthorizations(authorizations.getAuthorizations());
                return InMemoryGraph.this.savePreparedEdge(this, this.getVertexId(Direction.OUT), this.getVertexId(Direction.IN), timestamp, authorizations);
            }
        };
    }

    @Override
    public EdgeBuilder prepareEdge(String edgeId, Vertex outVertex, Vertex inVertex, String label, final Long timestamp, Visibility visibility) {
        Preconditions.checkNotNull(outVertex, "outVertex cannot be null");
        Preconditions.checkNotNull(inVertex, "inVertex cannot be null");
        Preconditions.checkNotNull(label, "label cannot be null");
        if (edgeId == null) {
            edgeId = this.getIdGenerator().nextId();
        }
        return new EdgeBuilder(edgeId, outVertex, inVertex, label, visibility){

            @Override
            public Edge save(Authorizations authorizations) {
                InMemoryGraph.this.addValidAuthorizations(authorizations.getAuthorizations());
                return InMemoryGraph.this.savePreparedEdge(this, (String)this.getOutVertex().getId(), (String)this.getInVertex().getId(), timestamp, authorizations);
            }
        };
    }

    private Edge savePreparedEdge(EdgeBuilderBase edgeBuilder, String outVertexId, String inVertexId, Long timestamp, Authorizations authorizations) {
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
            IncreasingTime.advanceTime(10);
        }
        long incrementingTimestamp = timestamp;
        InMemoryTableEdge edgeTableElement = (InMemoryTableEdge)this.edgesTable.getTableElement(edgeBuilder.getId());
        boolean isNew = false;
        if (edgeTableElement == null) {
            isNew = true;
            this.edgesTable.append(edgeBuilder.getId(), new AlterVisibilityMutation(incrementingTimestamp++, edgeBuilder.getVisibility()), new ElementTimestampMutation(incrementingTimestamp++), new AlterEdgeLabelMutation(incrementingTimestamp++, edgeBuilder.getEdgeLabel()), new EdgeSetupMutation(incrementingTimestamp++, outVertexId, inVertexId));
        } else {
            if (!outVertexId.equals(edgeTableElement.getOutVertexId()) || !inVertexId.equals(edgeTableElement.getInVertexId())) {
                this.edgesTable.append(edgeBuilder.getId(), new EdgeSetupMutation(incrementingTimestamp++, outVertexId, inVertexId));
            }
            this.edgesTable.append(edgeBuilder.getId(), new ElementTimestampMutation(incrementingTimestamp++));
        }
        if (edgeBuilder.getNewEdgeLabel() != null) {
            this.edgesTable.append(edgeBuilder.getId(), new AlterEdgeLabelMutation(incrementingTimestamp, edgeBuilder.getNewEdgeLabel()));
        }
        InMemoryEdge edge = (InMemoryEdge)this.edgesTable.get(this, edgeBuilder.getId(), FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
        if (isNew && this.hasEventListeners()) {
            this.fireGraphEvent(new AddEdgeEvent(this, edge));
        }
        edge.updatePropertiesInternal(edgeBuilder);
        if (edgeBuilder.getIndexHint() != IndexHint.DO_NOT_INDEX) {
            this.updateElementAndExtendedDataInSearchIndex(edge, edgeBuilder, authorizations);
        }
        return edge;
    }

    @Override
    public Iterable<Edge> getEdges(FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        return new ConvertingIterable<InMemoryEdge, Edge>(this.edgesTable.getAll(this, fetchHints, endTime, authorizations)){

            @Override
            protected Edge convert(InMemoryEdge o) {
                return o;
            }
        };
    }

    @Override
    protected GraphMetadataStore getGraphMetadataStore() {
        return this.graphMetadataStore;
    }

    @Override
    public void deleteEdge(Edge edge, Authorizations authorizations) {
        Preconditions.checkNotNull(edge, "Edge cannot be null");
        this.deleteAllExtendedDataForElement(edge, authorizations);
        this.edgesTable.remove((String)edge.getId());
        this.getSearchIndex().deleteElement(this, edge, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent(new DeleteEdgeEvent(this, edge));
        }
    }

    @Override
    public void softDeleteEdge(Edge edge, Long timestamp, Authorizations authorizations) {
        Preconditions.checkNotNull(edge, "Edge cannot be null");
        if (!((InMemoryEdge)edge).canRead(authorizations)) {
            return;
        }
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        this.edgesTable.getTableElement((String)edge.getId()).appendSoftDeleteMutation(timestamp);
        this.getSearchIndex().deleteElement(this, edge, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent(new SoftDeleteEdgeEvent(this, edge));
        }
    }

    @Override
    public void markEdgeHidden(Edge edge, Visibility visibility, Authorizations authorizations) {
        if (!((InMemoryEdge)edge).canRead(authorizations)) {
            return;
        }
        Vertex inVertex = this.getVertex(edge.getVertexId(Direction.IN), authorizations);
        Preconditions.checkNotNull(inVertex, "Could not find in vertex \"" + edge.getVertexId(Direction.IN) + "\" on edge \"" + (String)edge.getId() + "\"");
        Vertex outVertex = this.getVertex(edge.getVertexId(Direction.OUT), authorizations);
        Preconditions.checkNotNull(outVertex, "Could not find out vertex \"" + edge.getVertexId(Direction.OUT) + "\" on edge \"" + (String)edge.getId() + "\"");
        this.edgesTable.getTableElement((String)edge.getId()).appendMarkHiddenMutation(visibility);
        this.getSearchIndex().markElementHidden(this, edge, visibility, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent(new MarkHiddenEdgeEvent(this, edge));
        }
    }

    @Override
    public void markEdgeVisible(Edge edge, Visibility visibility, Authorizations authorizations) {
        if (!((InMemoryEdge)edge).canRead(authorizations)) {
            return;
        }
        Vertex inVertex = this.getVertex(edge.getVertexId(Direction.IN), FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
        Preconditions.checkNotNull(inVertex, "Could not find in vertex \"" + edge.getVertexId(Direction.IN) + "\" on edge \"" + (String)edge.getId() + "\"");
        Vertex outVertex = this.getVertex(edge.getVertexId(Direction.OUT), FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
        Preconditions.checkNotNull(outVertex, "Could not find out vertex \"" + edge.getVertexId(Direction.OUT) + "\" on edge \"" + (String)edge.getId() + "\"");
        this.edgesTable.getTableElement((String)edge.getId()).appendMarkVisibleMutation(visibility);
        this.getSearchIndex().markElementVisible(this, edge, visibility, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent(new MarkVisibleEdgeEvent(this, edge));
        }
    }

    @Override
    public Authorizations createAuthorizations(String ... auths) {
        this.addValidAuthorizations(auths);
        return new Authorizations(auths);
    }

    @Override
    protected void findPathsRecursive(FindPathOptions options, List<Path> foundPaths, Vertex sourceVertex, Vertex destVertex, int hops, Set<String> seenVertices, Path currentPath, ProgressCallback progressCallback, Authorizations authorizations) {
        this.findPathsRecursive(options, foundPaths, (String)sourceVertex.getId(), (String)destVertex.getId(), hops, seenVertices, currentPath, progressCallback, authorizations);
    }

    protected void findPathsRecursive(FindPathOptions options, List<Path> foundPaths, String sourceVertexId, String destVertexId, int hops, Set<String> seenVertices, Path currentPath, ProgressCallback progressCallback, Authorizations authorizations) {
        boolean firstLevelRecursion;
        boolean bl = firstLevelRecursion = hops == options.getMaxHops();
        if (options.isGetAnyPath() && foundPaths.size() == 1) {
            return;
        }
        seenVertices.add(sourceVertexId);
        if (sourceVertexId.equals(destVertexId)) {
            foundPaths.add(currentPath);
        } else if (hops > 0) {
            Stream<Edge> edges = StreamUtils.stream(this.getEdgesFromVertex(sourceVertexId, this.getDefaultFetchHints(), null, authorizations)).filter(edge -> {
                if (options.getExcludedLabels() != null && ArrayUtils.contains(options.getExcludedLabels(), edge.getLabel())) {
                    return false;
                }
                return options.getLabels() == null || ArrayUtils.contains(options.getLabels(), edge.getLabel());
            });
            ArrayList vertexIds = new ArrayList();
            edges.forEach(edge -> {
                if (edge.getOtherVertex(sourceVertexId, FetchHints.NONE, authorizations) != null) {
                    vertexIds.add(edge.getOtherVertexId(sourceVertexId));
                }
            });
            int vertexCount = 0;
            if (firstLevelRecursion) {
                vertexCount = vertexIds.size();
            }
            int i = 0;
            for (String childId : vertexIds) {
                if (firstLevelRecursion) {
                    double progress = (double)i / (double)vertexCount;
                    progressCallback.progress(progress, ProgressCallback.Step.SEARCHING_EDGES, i + 1, vertexCount);
                }
                if (!seenVertices.contains(childId)) {
                    this.findPathsRecursive(options, foundPaths, childId, destVertexId, hops - 1, seenVertices, new Path(currentPath, childId), progressCallback, authorizations);
                }
                ++i;
            }
        }
        seenVertices.remove(sourceVertexId);
    }

    protected Iterable<Edge> getEdgesFromVertex(final String vertexId, final FetchHints fetchHints, final Long endTime, final Authorizations authorizations) {
        return new LookAheadIterable<InMemoryTableEdge, Edge>(){

            @Override
            protected boolean isIncluded(InMemoryTableEdge inMemoryTableElement, Edge edge) {
                if (edge == null) {
                    return false;
                }
                EdgeSetupMutation edgeSetupMutation = inMemoryTableElement.findLastMutation(EdgeSetupMutation.class);
                String inVertexId = edgeSetupMutation.getInVertexId();
                Preconditions.checkNotNull(inVertexId, "inVertexId was null");
                String outVertexId = edgeSetupMutation.getOutVertexId();
                Preconditions.checkNotNull(outVertexId, "outVertexId was null");
                return (inVertexId.equals(vertexId) || outVertexId.equals(vertexId)) && InMemoryGraph.this.isIncluded(inMemoryTableElement, fetchHints, authorizations);
            }

            @Override
            protected Edge convert(InMemoryTableEdge inMemoryTableElement) {
                return (Edge)inMemoryTableElement.createElement(InMemoryGraph.this, fetchHints, endTime, authorizations);
            }

            @Override
            protected Iterator<InMemoryTableEdge> createIterator() {
                return InMemoryGraph.this.edgesTable.getAllTableElements().iterator();
            }
        };
    }

    protected boolean isIncluded(InMemoryTableElement element, FetchHints fetchHints, Authorizations authorizations) {
        boolean includeHidden = fetchHints.isIncludeHidden();
        if (!element.canRead(fetchHints, authorizations)) {
            return false;
        }
        return includeHidden || !element.isHidden(authorizations);
    }

    protected boolean isIncludedInTimeSpan(InMemoryTableElement element, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        boolean includeHidden = fetchHints.isIncludeHidden();
        if (!element.canRead(fetchHints, authorizations)) {
            return false;
        }
        if (!includeHidden && element.isHidden(authorizations)) {
            return false;
        }
        if (element.isDeleted(endTime, authorizations)) {
            return false;
        }
        return endTime == null || element.getFirstTimestamp() <= endTime;
    }

    protected void softDeleteProperty(InMemoryTableElement inMemoryTableElement, Property property, Long timestamp, IndexHint indexHint, Authorizations authorizations) {
        Element element;
        if (inMemoryTableElement instanceof InMemoryTableVertex) {
            inMemoryTableElement.appendSoftDeletePropertyMutation(property.getKey(), property.getName(), property.getVisibility(), timestamp);
            element = this.getVertex(inMemoryTableElement.getId(), FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
        } else if (inMemoryTableElement instanceof InMemoryTableEdge) {
            inMemoryTableElement.appendSoftDeletePropertyMutation(property.getKey(), property.getName(), property.getVisibility(), timestamp);
            element = this.getEdge(inMemoryTableElement.getId(), FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
        } else {
            throw new IllegalArgumentException("Unexpected element type: " + inMemoryTableElement.getClass().getName());
        }
        if (indexHint != IndexHint.DO_NOT_INDEX) {
            this.getSearchIndex().deleteProperty(this, element, PropertyDescriptor.fromProperty(property), authorizations);
        }
        if (this.hasEventListeners()) {
            this.fireGraphEvent(new SoftDeletePropertyEvent((Graph)this, element, property));
        }
    }

    public void addPropertyValue(InMemoryElement element, InMemoryTableElement inMemoryTableElement, String key, String name, Value value, Metadata metadata, Visibility visibility, Long timestamp, Authorizations authorizations) {
        this.ensurePropertyDefined(name, value);
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        if (value instanceof StreamingPropertyValue) {
            value = this.saveStreamingPropertyValue(element.getId(), key, name, visibility, timestamp, (StreamingPropertyValue)value);
        }
        inMemoryTableElement.appendAddPropertyValueMutation(key, name, value, metadata, visibility, timestamp);
        Property property = inMemoryTableElement.getProperty(key, name, visibility, FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent(new AddPropertyEvent(this, element, property));
        }
    }

    protected void alterElementVisibility(InMemoryTableElement inMemoryTableElement, Visibility newEdgeVisibility) {
        inMemoryTableElement.appendAlterVisibilityMutation(newEdgeVisibility);
    }

    protected void alterElementPropertyVisibilities(InMemoryTableElement inMemoryTableElement, List<AlterPropertyVisibility> alterPropertyVisibilities, Authorizations authorizations) {
        for (AlterPropertyVisibility apv : alterPropertyVisibilities) {
            Property property = inMemoryTableElement.getProperty(apv.getKey(), apv.getName(), apv.getExistingVisibility(), FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
            if (property == null) {
                throw new GeException("Could not find property " + apv.getKey() + ":" + apv.getName());
            }
            if (apv.getExistingVisibility() == null) {
                apv.setExistingVisibility(property.getVisibility());
            }
            Value value = property.getValue();
            Metadata metadata = property.getMetadata();
            inMemoryTableElement.appendSoftDeletePropertyMutation(apv.getKey(), apv.getName(), apv.getExistingVisibility(), apv.getTimestamp());
            long newTimestamp = apv.getTimestamp() + 1L;
            if (value instanceof StreamingPropertyValue) {
                value = this.saveStreamingPropertyValue(inMemoryTableElement.getId(), apv.getKey(), apv.getName(), apv.getVisibility(), newTimestamp, (StreamingPropertyValue)value);
            }
            inMemoryTableElement.appendAddPropertyValueMutation(apv.getKey(), apv.getName(), value, metadata, apv.getVisibility(), newTimestamp);
        }
    }

    protected void alterElementPropertyMetadata(InMemoryTableElement inMemoryTableElement, List<SetPropertyMetadata> setPropertyMetadatas, Authorizations authorizations) {
        for (SetPropertyMetadata spm : setPropertyMetadatas) {
            Property property = inMemoryTableElement.getProperty(spm.getPropertyKey(), spm.getPropertyName(), spm.getPropertyVisibility(), FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
            if (property == null) {
                throw new GeException("Could not find property " + spm.getPropertyKey() + ":" + spm.getPropertyName());
            }
            Metadata metadata = Metadata.create(property.getMetadata());
            metadata.add(spm.getMetadataName(), spm.getNewValue(), spm.getMetadataVisibility());
            long newTimestamp = IncreasingTime.currentTimeMillis();
            inMemoryTableElement.appendAddPropertyMetadataMutation(property.getKey(), property.getName(), metadata, property.getVisibility(), newTimestamp);
        }
    }

    protected StreamingPropertyValueRef saveStreamingPropertyValue(String elementId, String key, String name, Visibility visibility, long timestamp, StreamingPropertyValue value) {
        return new InMemoryStreamingPropertyValueRef(value);
    }

    @Override
    public boolean isVisibilityValid(Visibility visibility, Authorizations authorizations) {
        return authorizations.canRead(visibility);
    }

    @Override
    public void truncate() {
        this.verticesTable.clear();
        this.edgesTable.clear();
        this.getSearchIndex().truncate(this);
    }

    @Override
    public void drop() {
        this.verticesTable.clear();
        this.edgesTable.clear();
        this.getSearchIndex().drop(this);
    }

    protected void alterEdgeLabel(InMemoryTableEdge inMemoryTableEdge, long timestamp, String newEdgeLabel) {
        inMemoryTableEdge.appendAlterEdgeLabelMutation(timestamp, newEdgeLabel);
    }

    protected void alterConceptType(InMemoryTableVertex inMemoryTableVertex, long timestamp, String newConceptType) {
        inMemoryTableVertex.appendAlterConceptTypeMutation(timestamp, newConceptType);
    }

    protected void deleteProperty(InMemoryElement element, InMemoryTableElement inMemoryTableElement, String key, String name, Visibility visibility, Authorizations authorizations) {
        Property property = inMemoryTableElement.getProperty(key, name, visibility, FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
        inMemoryTableElement.deleteProperty(key, name, visibility, authorizations);
        this.getSearchIndex().deleteProperty(this, element, PropertyDescriptor.fromProperty(property), authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent(new DeletePropertyEvent((Graph)this, (Element)element, property));
        }
    }

    private void refreshVertexInMemoryTableElement(Vertex vertex) {
        ((InMemoryVertex)vertex).setInMemoryTableElement(this.verticesTable.getTableElement((String)vertex.getId()));
    }

    public ImmutableSet<String> getExtendedDataTableNames(ElementType elementType, String elementId, FetchHints fetchHints, Authorizations authorizations) {
        return this.extendedDataTable.getTableNames(elementType, elementId, fetchHints, authorizations);
    }

    public Iterable<? extends ExtendedDataRow> getExtendedDataTable(ElementType elementType, String elementId, String tableName, FetchHints fetchHints, Authorizations authorizations) {
        return this.extendedDataTable.getTable(elementType, elementId, tableName, fetchHints, authorizations);
    }

    public void extendedData(Element element, ExtendedDataRowId rowId, ExtendedDataMutation extendedData, Authorizations authorizations) {
        this.extendedDataTable.addData(rowId, extendedData.getColumnName(), extendedData.getKey(), extendedData.getValue(), extendedData.getTimestamp(), extendedData.getVisibility());
        this.getSearchIndex().addElementExtendedData(this, element, Collections.singleton(extendedData), authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent(new AddExtendedDataEvent(this, element, rowId.getTableName(), rowId.getRowId(), extendedData.getColumnName(), extendedData.getKey(), extendedData.getValue(), extendedData.getVisibility()));
        }
    }

    @Override
    public void deleteExtendedDataRow(ExtendedDataRowId id, Authorizations authorizations) {
        ArrayList rows = Lists.newArrayList(this.getExtendedData(Lists.newArrayList((Object[])new ExtendedDataRowId[]{id}), authorizations));
        if (rows.size() > 1) {
            throw new GeException("Found too many extended data rows for id: " + id);
        }
        if (rows.size() != 1) {
            return;
        }
        this.extendedDataTable.remove(id);
        this.getSearchIndex().deleteExtendedData(this, id, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent(new DeleteExtendedDataRowEvent(this, id));
        }
    }

    public void deleteExtendedData(InMemoryElement element, String tableName, String row, String columnName, String key, Visibility visibility, Authorizations authorizations) {
        this.extendedDataTable.removeColumn(new ExtendedDataRowId(ElementType.getTypeFromElement(element), element.getId(), tableName, row), columnName, key, visibility);
        this.getSearchIndex().deleteExtendedData(this, element, tableName, row, columnName, key, visibility, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent(new DeleteExtendedDataEvent(this, element, tableName, row, columnName, key));
        }
    }

    @Override
    public void flushGraph() {
    }

    @Override
    public Vertex getVertex(String vertexId, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        this.validateAuthorizations(authorizations);
        InMemoryTableElement element = this.verticesTable.getTableElement(vertexId);
        if (element == null || !this.isIncludedInTimeSpan(element, fetchHints, endTime, authorizations)) {
            return null;
        }
        return (Vertex)element.createElement(this, fetchHints, endTime, authorizations);
    }

    @Override
    public Edge getEdge(String edgeId, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        InMemoryTableElement element = this.edgesTable.getTableElement(edgeId);
        if (element == null || !this.isIncluded(element, fetchHints, authorizations)) {
            return null;
        }
        return (Edge)element.createElement(this, fetchHints, endTime, authorizations);
    }
}

