/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.inmemory;

import com.mware.ge.GraphMetadataEntry;
import com.mware.ge.GraphMetadataStore;
import com.mware.ge.util.JavaSerializableUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;

public class InMemoryGraphMetadataStore
extends GraphMetadataStore
implements Serializable {
    private final ReadWriteLock metadataLock = new ReentrantReadWriteLock();
    private final Map<String, byte[]> metadata = new HashMap<String, byte[]>();

    @Override
    public Iterable<GraphMetadataEntry> getMetadata() {
        this.metadataLock.readLock().lock();
        try {
            Iterable iterable = this.metadata.entrySet().stream().map(o -> new GraphMetadataEntry((String)o.getKey(), (byte[])o.getValue())).collect(Collectors.toList());
            return iterable;
        }
        finally {
            this.metadataLock.readLock().unlock();
        }
    }

    @Override
    public void reloadMetadata() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getMetadata(String key) {
        this.metadataLock.readLock().lock();
        try {
            byte[] bytes = this.metadata.get(key);
            if (bytes == null) {
                Object var3_3 = null;
                return var3_3;
            }
            Object object = JavaSerializableUtils.bytesToObject(bytes);
            return object;
        }
        finally {
            this.metadataLock.readLock().unlock();
        }
    }

    @Override
    public void setMetadata(String key, Object value) {
        this.metadataLock.writeLock().lock();
        try {
            this.metadata.put(key, JavaSerializableUtils.objectToBytes(value));
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    @Override
    public void removeMetadata(String key) {
        this.metadataLock.writeLock().lock();
        try {
            this.metadata.remove(key);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void drop() {
    }
}

