/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.inmemory;

import com.mware.ge.GeException;
import com.mware.ge.inmemory.InMemoryGraph;
import com.mware.ge.inmemory.InMemoryStreamingPropertyValue;
import com.mware.ge.util.IOUtils;
import com.mware.ge.values.ValueMapper;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.StreamingPropertyValueRef;
import com.mware.ge.values.storable.ValueWriter;
import java.io.IOException;

class InMemoryStreamingPropertyValueRef
extends StreamingPropertyValueRef<InMemoryGraph> {
    private final byte[] valueData;

    InMemoryStreamingPropertyValueRef(StreamingPropertyValue value) {
        super(value);
        try {
            this.valueData = IOUtils.toBytes(value.getInputStream());
        }
        catch (IOException ex) {
            throw new GeException("Could not read streaming property value", ex);
        }
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public Object asObjectCopy() {
        return this.valueData;
    }

    @Override
    public StreamingPropertyValue toStreamingPropertyValue(InMemoryGraph graph, Long timestamp) {
        return (StreamingPropertyValue)new InMemoryStreamingPropertyValue(this.valueData, this.getValueType()).searchIndex(this.isSearchIndex());
    }
}

