/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.inmemory;

import com.mware.ge.Authorizations;
import com.mware.ge.FetchHints;
import com.mware.ge.inmemory.InMemoryElement;
import com.mware.ge.inmemory.InMemoryGraph;
import com.mware.ge.inmemory.InMemoryTableElement;
import com.mware.ge.inmemory.mutations.Mutation;
import com.mware.ge.util.StreamUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;

public abstract class InMemoryTable<TElement extends InMemoryElement> {
    private ReadWriteLock rowsLock = new ReentrantReadWriteLock();
    private Map<String, InMemoryTableElement<TElement>> rows;

    protected InMemoryTable(Map<String, InMemoryTableElement<TElement>> rows) {
        this.rows = rows;
    }

    protected InMemoryTable() {
        this(new ConcurrentSkipListMap<String, InMemoryTableElement<TElement>>());
    }

    public TElement get(InMemoryGraph graph, String id, FetchHints fetchHints, Authorizations authorizations) {
        InMemoryTableElement<TElement> inMemoryTableElement = this.getTableElement(id);
        if (inMemoryTableElement == null) {
            return null;
        }
        return inMemoryTableElement.createElement(graph, fetchHints, authorizations);
    }

    public InMemoryTableElement<TElement> getTableElement(String id) {
        if (null == id) {
            return null;
        }
        this.rowsLock.readLock().lock();
        try {
            InMemoryTableElement<TElement> inMemoryTableElement = this.rows.get(id);
            return inMemoryTableElement;
        }
        finally {
            this.rowsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String id, Mutation ... newMutations) {
        if (null == id) {
            return;
        }
        this.rowsLock.writeLock().lock();
        try {
            InMemoryTableElement<TElement> inMemoryTableElement = this.rows.get(id);
            if (inMemoryTableElement == null) {
                inMemoryTableElement = this.createInMemoryTableElement(id);
                this.rows.put(id, inMemoryTableElement);
            }
            inMemoryTableElement.addAll(newMutations);
        }
        finally {
            this.rowsLock.writeLock().unlock();
        }
    }

    protected abstract InMemoryTableElement<TElement> createInMemoryTableElement(String var1);

    public void remove(String id) {
        if (null == id) {
            return;
        }
        this.rowsLock.writeLock().lock();
        try {
            this.rows.remove(id);
        }
        finally {
            this.rowsLock.writeLock().unlock();
        }
    }

    public void clear() {
        this.rowsLock.writeLock().lock();
        try {
            this.rows.clear();
        }
        finally {
            this.rowsLock.writeLock().unlock();
        }
    }

    public Iterable<TElement> getAll(InMemoryGraph graph, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        return StreamUtils.stream(this.getRowValues()).filter(element -> graph.isIncludedInTimeSpan((InMemoryTableElement)element, fetchHints, endTime, authorizations)).map(element -> element.createElement(graph, fetchHints, endTime, authorizations)).collect(Collectors.toList());
    }

    public Iterable<InMemoryTableElement<TElement>> getRowValues() {
        this.rowsLock.readLock().lock();
        try {
            ArrayList<InMemoryTableElement<TElement>> arrayList = new ArrayList<InMemoryTableElement<TElement>>(this.rows.values());
            return arrayList;
        }
        finally {
            this.rowsLock.readLock().unlock();
        }
    }
}

