/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.inmemory;

import com.google.common.collect.Maps;
import com.mware.ge.Authorizations;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.HistoricalPropertyValue;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.inmemory.InMemoryElement;
import com.mware.ge.inmemory.InMemoryGraph;
import com.mware.ge.inmemory.mutations.AddPropertyMetadataMutation;
import com.mware.ge.inmemory.mutations.AddPropertyValueMutation;
import com.mware.ge.inmemory.mutations.AlterConceptTypeMutation;
import com.mware.ge.inmemory.mutations.AlterEdgeLabelMutation;
import com.mware.ge.inmemory.mutations.AlterVisibilityMutation;
import com.mware.ge.inmemory.mutations.ElementTimestampMutation;
import com.mware.ge.inmemory.mutations.MarkHiddenMutation;
import com.mware.ge.inmemory.mutations.MarkPropertyHiddenMutation;
import com.mware.ge.inmemory.mutations.MarkPropertyVisibleMutation;
import com.mware.ge.inmemory.mutations.MarkVisibleMutation;
import com.mware.ge.inmemory.mutations.Mutation;
import com.mware.ge.inmemory.mutations.PropertyMutation;
import com.mware.ge.inmemory.mutations.SoftDeleteMutation;
import com.mware.ge.inmemory.mutations.SoftDeletePropertyMutation;
import com.mware.ge.property.MutablePropertyImpl;
import com.mware.ge.util.IncreasingTime;
import com.mware.ge.util.LookAheadIterable;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.StreamingPropertyValueRef;
import com.mware.ge.values.storable.Value;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class InMemoryTableElement<TElement extends InMemoryElement>
implements Serializable {
    private final String id;
    private ReadWriteLock mutationLock = new ReentrantReadWriteLock();
    private TreeSet<Mutation> mutations = new TreeSet();

    protected InMemoryTableElement(String id) {
        if (null == id) {
            throw new GeException("Element id is null");
        }
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void addAll(Mutation ... newMutations) {
        this.mutationLock.writeLock().lock();
        try {
            Collections.addAll(this.mutations, newMutations);
        }
        finally {
            this.mutationLock.writeLock().unlock();
        }
    }

    public long getFirstTimestamp() {
        return this.findFirstMutation(ElementTimestampMutation.class).getTimestamp();
    }

    public <T extends Mutation> T findLastMutation(Class<T> clazz) {
        List<Mutation> filteredMutations = this.getFilteredMutations(m -> clazz.isAssignableFrom(m.getClass()));
        return (T)(filteredMutations.isEmpty() ? null : filteredMutations.get(filteredMutations.size() - 1));
    }

    protected <T extends Mutation> T findFirstMutation(Class<T> clazz) {
        List<Mutation> filteredMutations = this.getFilteredMutations(m -> clazz.isAssignableFrom(m.getClass()));
        return (T)(filteredMutations.isEmpty() ? null : filteredMutations.get(0));
    }

    protected <T extends Mutation> Iterable<T> findMutations(Class<T> clazz) {
        return this.getFilteredMutations(m -> clazz.isAssignableFrom(m.getClass()));
    }

    public Visibility getVisibility() {
        return this.findLastMutation(AlterVisibilityMutation.class).getNewVisibility();
    }

    public long getTimestamp() {
        return this.findLastMutation(ElementTimestampMutation.class).getTimestamp();
    }

    private List<PropertyMutation> findPropertyMutations(Property p) {
        return this.findPropertyMutations(p.getKey(), p.getName(), p.getVisibility());
    }

    public Property deleteProperty(String key, String name, Authorizations authorizations) {
        return this.deleteProperty(key, name, null, authorizations);
    }

    public Property getProperty(String key, String name, Visibility visibility, FetchHints fetchHints, Authorizations authorizations) {
        List<PropertyMutation> propertyMutations = this.findPropertyMutations(key, name, visibility);
        if (propertyMutations == null || propertyMutations.size() == 0) {
            return null;
        }
        return this.toProperty(propertyMutations, fetchHints, authorizations);
    }

    public Property deleteProperty(String key, String name, Visibility visibility, Authorizations authorizations) {
        Property p = this.getProperty(key, name, visibility, FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
        if (p != null) {
            this.deleteProperty(p);
        }
        return p;
    }

    protected void deleteProperty(Property p) {
        List<PropertyMutation> propertyMutations = this.findPropertyMutations(p);
        this.mutationLock.writeLock().lock();
        try {
            this.mutations.removeAll(propertyMutations);
        }
        finally {
            this.mutationLock.writeLock().unlock();
        }
    }

    private List<PropertyMutation> findPropertyMutations(String key, String name, Visibility visibility) {
        return this.getFilteredMutations(m -> !(!(m instanceof PropertyMutation) || key != null && !((PropertyMutation)m).getPropertyKey().equals(key) || name != null && !((PropertyMutation)m).getPropertyName().equals(name) || visibility != null && !((PropertyMutation)m).getPropertyVisibility().equals(visibility))).stream().map(m -> (PropertyMutation)m).collect(Collectors.toList());
    }

    public Iterable<HistoricalPropertyValue> getHistoricalPropertyValues(String key, String name, Visibility visibility, Long startTime, Long endTime, Authorizations authorizations) {
        List<PropertyMutation> propertyMutations = this.findPropertyMutations(key, name, visibility);
        ArrayList<HistoricalPropertyValue> historicalPropertyValues = new ArrayList<HistoricalPropertyValue>();
        HashMap currentPropertyBuilders = Maps.newHashMap();
        HashSet<Visibility> hiddenVisibilities = new HashSet<Visibility>();
        for (PropertyMutation m : propertyMutations) {
            String propertyIdentifier = m.getPropertyKey() + m.getPropertyName();
            HistoricalPropertyValue.HistoricalPropertyValueBuilder builder = currentPropertyBuilders.computeIfAbsent(propertyIdentifier, k -> new HistoricalPropertyValue.HistoricalPropertyValueBuilder(m.getPropertyKey(), m.getPropertyName(), m.getTimestamp()));
            if (startTime != null && m.getTimestamp() < startTime || endTime != null && m.getTimestamp() > endTime || !InMemoryTableElement.canRead(m.getVisibility(), authorizations) || m.getVisibility() != null && m.getPropertyVisibility().getVisibilityString().matches("(.*)WORKSPACE(.*)")) continue;
            if (m instanceof SoftDeletePropertyMutation) {
                builder.isDeleted(true);
                builder.timestamp(m.getTimestamp());
                historicalPropertyValues.add(builder.build());
                continue;
            }
            if (m instanceof AddPropertyMetadataMutation) {
                builder.metadata(((AddPropertyMetadataMutation)m).getMetadata(FetchHints.ALL));
                builder.timestamp(m.getTimestamp());
                continue;
            }
            if (m instanceof MarkPropertyHiddenMutation || m instanceof MarkPropertyVisibleMutation) continue;
            if (m instanceof AddPropertyValueMutation) {
                HistoricalPropertyValue last;
                AddPropertyValueMutation apvm = (AddPropertyValueMutation)m;
                Value value = apvm.getValue();
                value = this.loadIfStreamingPropertyValue(value, m.getTimestamp());
                builder.propertyVisibility(m.getPropertyVisibility()).timestamp(m.getTimestamp()).value(value).metadata(apvm.getMetadata(FetchHints.ALL)).hiddenVisibilities(hiddenVisibilities).isDeleted(false);
                if (historicalPropertyValues.size() > 0 && propertyIdentifier.equals((last = (HistoricalPropertyValue)historicalPropertyValues.get(historicalPropertyValues.size() - 1)).getPropertyKey() + last.getPropertyName()) && last.isDeleted()) {
                    historicalPropertyValues.remove(historicalPropertyValues.size() - 1);
                }
                historicalPropertyValues.add(builder.build());
                continue;
            }
            throw new GeException("Unhandled PropertyMutation: " + m.getClass().getName());
        }
        Collections.reverse(historicalPropertyValues);
        return historicalPropertyValues;
    }

    public Iterable<Property> getProperties(final FetchHints fetchHints, Long endTime, final Authorizations authorizations) {
        final TreeMap<String, List> propertiesMutations = new TreeMap<String, List>();
        for (PropertyMutation m : this.findMutations(PropertyMutation.class)) {
            if (endTime != null && m.getTimestamp() > endTime) continue;
            String mapKey = this.toMapKey(m);
            List propertyMutations = propertiesMutations.computeIfAbsent(mapKey, k -> new ArrayList());
            propertyMutations.add(m);
        }
        return new LookAheadIterable<List<PropertyMutation>, Property>(){

            @Override
            protected boolean isIncluded(List<PropertyMutation> src, Property property) {
                return property != null;
            }

            @Override
            protected Property convert(List<PropertyMutation> propertyMutations) {
                return InMemoryTableElement.this.toProperty(propertyMutations, fetchHints, authorizations);
            }

            @Override
            protected Iterator<List<PropertyMutation>> createIterator() {
                return propertiesMutations.values().iterator();
            }
        };
    }

    private Property toProperty(List<PropertyMutation> propertyMutations, FetchHints fetchHints, Authorizations authorizations) {
        String propertyKey = null;
        String propertyName = null;
        Value value = null;
        Metadata metadata = null;
        long timestamp = 0L;
        HashSet<Visibility> hiddenVisibilities = new HashSet<Visibility>();
        Visibility visibility = null;
        boolean softDeleted = false;
        boolean hidden = false;
        for (PropertyMutation m : propertyMutations) {
            if (!InMemoryTableElement.canRead(m.getVisibility(), authorizations)) continue;
            propertyKey = m.getPropertyKey();
            propertyName = m.getPropertyName();
            visibility = m.getPropertyVisibility();
            if (m.getTimestamp() > timestamp) {
                timestamp = m.getTimestamp();
            }
            if (m instanceof AddPropertyValueMutation) {
                AddPropertyValueMutation apvm = (AddPropertyValueMutation)m;
                value = apvm.getValue();
                metadata = apvm.getMetadata(fetchHints);
                softDeleted = false;
                continue;
            }
            if (m instanceof AddPropertyMetadataMutation) {
                AddPropertyMetadataMutation apmm = (AddPropertyMetadataMutation)m;
                metadata = apmm.getMetadata(fetchHints);
                continue;
            }
            if (m instanceof SoftDeletePropertyMutation) {
                softDeleted = true;
                continue;
            }
            if (m instanceof MarkPropertyHiddenMutation) {
                hidden = true;
                hiddenVisibilities.add(m.getVisibility());
                continue;
            }
            if (m instanceof MarkPropertyVisibleMutation) {
                hidden = false;
                hiddenVisibilities.remove(m.getVisibility());
                continue;
            }
            throw new GeException("Unhandled PropertyMutation: " + m.getClass().getName());
        }
        if (softDeleted) {
            return null;
        }
        if (!fetchHints.isIncludeHidden() && hidden) {
            return null;
        }
        if (propertyKey == null) {
            return null;
        }
        value = this.loadIfStreamingPropertyValue(value, timestamp);
        return new MutablePropertyImpl(propertyKey, propertyName, value, metadata, timestamp, hiddenVisibilities, visibility, fetchHints);
    }

    private Value loadIfStreamingPropertyValue(Value value, long timestamp) {
        if (value instanceof StreamingPropertyValueRef) {
            value = this.loadStreamingPropertyValue((StreamingPropertyValueRef)value, timestamp);
        }
        return value;
    }

    protected StreamingPropertyValue loadStreamingPropertyValue(StreamingPropertyValueRef<?> streamingPropertyValueRef, long timestamp) {
        return streamingPropertyValueRef.toStreamingPropertyValue(null, timestamp);
    }

    private String toMapKey(PropertyMutation m) {
        return m.getPropertyName() + m.getPropertyKey() + m.getPropertyVisibility().getVisibilityString();
    }

    public void appendSoftDeleteMutation(Long timestamp) {
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        this.addMutation(new SoftDeleteMutation(timestamp));
    }

    public void appendMarkHiddenMutation(Visibility visibility) {
        long timestamp = IncreasingTime.currentTimeMillis();
        this.addMutation(new MarkHiddenMutation(timestamp, visibility));
    }

    public void appendMarkVisibleMutation(Visibility visibility) {
        long timestamp = IncreasingTime.currentTimeMillis();
        this.addAll(new MarkVisibleMutation(timestamp, visibility));
    }

    public Property appendMarkPropertyHiddenMutation(String key, String name, Visibility propertyVisibility, Long timestamp, Visibility visibility, Authorizations authorizations) {
        Property prop = this.getProperty(key, name, propertyVisibility, FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        this.addMutation(new MarkPropertyHiddenMutation(key, name, propertyVisibility, timestamp, visibility));
        return prop;
    }

    public Property appendMarkPropertyVisibleMutation(String key, String name, Visibility propertyVisibility, Long timestamp, Visibility visibility, Authorizations authorizations) {
        Property prop = this.getProperty(key, name, propertyVisibility, FetchHints.ALL_INCLUDING_HIDDEN, authorizations);
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        this.addMutation(new MarkPropertyVisibleMutation(key, name, propertyVisibility, timestamp, visibility));
        return prop;
    }

    public void appendSoftDeletePropertyMutation(String key, String name, Visibility propertyVisibility, Long timestamp) {
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        this.addMutation(new SoftDeletePropertyMutation(timestamp, key, name, propertyVisibility));
    }

    public void appendAlterVisibilityMutation(Visibility newVisibility) {
        long timestamp = IncreasingTime.currentTimeMillis();
        this.addMutation(new AlterVisibilityMutation(timestamp, newVisibility));
    }

    public void appendAddPropertyValueMutation(String key, String name, Value value, Metadata metadata, Visibility visibility, Long timestamp) {
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        this.addMutation(new AddPropertyValueMutation(timestamp, key, name, value, metadata, visibility));
    }

    public void appendAddPropertyMetadataMutation(String key, String name, Metadata metadata, Visibility visibility, Long timestamp) {
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        this.addMutation(new AddPropertyMetadataMutation((long)timestamp, key, name, metadata, visibility));
    }

    public void appendAlterEdgeLabelMutation(long timestamp, String newEdgeLabel) {
        this.addMutation(new AlterEdgeLabelMutation(timestamp, newEdgeLabel));
    }

    public void appendAlterConceptTypeMutation(long timestamp, String newConceptType) {
        this.addMutation(new AlterConceptTypeMutation(timestamp, newConceptType));
    }

    protected List<Mutation> getFilteredMutations(boolean includeHidden, Long endTime, Authorizations authorizations) {
        return this.getFilteredMutations(m -> InMemoryTableElement.canRead(m.getVisibility(), authorizations) && (endTime == null || m.getTimestamp() <= endTime) && (includeHidden || !(m instanceof MarkHiddenMutation) && !(m instanceof MarkPropertyHiddenMutation)));
    }

    public boolean canRead(FetchHints fetchHints, Authorizations authorizations) {
        if (this.getVisibility().getVisibilityString().length() == 0) {
            return true;
        }
        return authorizations.canRead(this.getVisibility());
    }

    private static boolean canRead(Visibility visibility, Authorizations authorizations) {
        if (visibility.getVisibilityString().length() == 0) {
            return true;
        }
        return authorizations.canRead(visibility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Visibility> getHiddenVisibilities() {
        HashSet<Visibility> results = new HashSet<Visibility>();
        this.mutationLock.readLock().lock();
        try {
            for (Mutation m : this.mutations) {
                if (m instanceof MarkHiddenMutation) {
                    results.add(m.getVisibility());
                    continue;
                }
                if (!(m instanceof MarkVisibleMutation)) continue;
                results.remove(m.getVisibility());
            }
        }
        finally {
            this.mutationLock.readLock().unlock();
        }
        return results;
    }

    public boolean isHidden(Authorizations authorizations) {
        for (Visibility visibility : this.getHiddenVisibilities()) {
            if (!authorizations.canRead(visibility)) continue;
            return true;
        }
        return false;
    }

    public TElement createElement(InMemoryGraph graph, FetchHints fetchHints, Authorizations authorizations) {
        return this.createElement(graph, fetchHints, null, authorizations);
    }

    public final TElement createElement(InMemoryGraph graph, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        if (endTime != null && this.getFirstTimestamp() > endTime) {
            return null;
        }
        if (this.isDeleted(endTime, authorizations)) {
            return null;
        }
        return this.createElementInternal(graph, fetchHints, endTime, authorizations);
    }

    public boolean isDeleted(Long endTime, Authorizations authorizations) {
        List<Mutation> filteredMutations = this.getFilteredMutations(m -> !(!InMemoryTableElement.canRead(m.getVisibility(), authorizations) || endTime != null && m.getTimestamp() > endTime || !(m instanceof SoftDeleteMutation) && !(m instanceof ElementTimestampMutation)));
        return filteredMutations.isEmpty() || filteredMutations.get(filteredMutations.size() - 1) instanceof SoftDeleteMutation;
    }

    protected abstract TElement createElementInternal(InMemoryGraph var1, FetchHints var2, Long var3, Authorizations var4);

    private List<Mutation> getFilteredMutations(Predicate<Mutation> filter) {
        this.mutationLock.readLock().lock();
        try {
            List<Mutation> list = this.mutations.stream().filter(filter).collect(Collectors.toList());
            return list;
        }
        finally {
            this.mutationLock.readLock().unlock();
        }
    }

    private void addMutation(Mutation mutation) {
        this.mutationLock.writeLock().lock();
        try {
            this.mutations.add(mutation);
        }
        finally {
            this.mutationLock.writeLock().unlock();
        }
    }
}

