/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.inmemory;

import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.EdgeInfo;
import com.mware.ge.EdgesSummary;
import com.mware.ge.FetchHints;
import com.mware.ge.GeMissingFetchHintException;
import com.mware.ge.Vertex;
import com.mware.ge.inmemory.InMemoryElement;
import com.mware.ge.inmemory.InMemoryGraph;
import com.mware.ge.inmemory.InMemoryTableVertex;
import com.mware.ge.inmemory.mutations.AlterConceptTypeMutation;
import com.mware.ge.inmemory.util.EdgeToEdgeIdIterable;
import com.mware.ge.mutation.ExistingVertexMutation;
import com.mware.ge.query.VertexQuery;
import com.mware.ge.search.IndexHint;
import com.mware.ge.util.ConvertingIterable;
import com.mware.ge.util.FilterIterable;
import java.util.HashMap;

public class InMemoryVertex
extends InMemoryElement<InMemoryVertex>
implements Vertex {
    public InMemoryVertex(InMemoryGraph graph, String id, InMemoryTableVertex inMemoryTableElement, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        super(graph, id, inMemoryTableElement, fetchHints, endTime, authorizations);
    }

    @Override
    public String getConceptType() {
        return this.getInMemoryTableElement().findLastMutation(AlterConceptTypeMutation.class).getNewConceptType();
    }

    @Override
    public Iterable<EdgeInfo> getEdgeInfos(Direction direction, final String[] labels, Authorizations authorizations) {
        this.getFetchHints().validateHasEdgeFetchHints(direction, labels);
        FilterIterable<EdgeInfo> results = this.internalGetEdgeInfo(direction, authorizations);
        results = new FilterIterable<EdgeInfo>(results){

            @Override
            protected boolean isIncluded(EdgeInfo o) {
                if (!InMemoryVertex.this.getFetchHints().isIncludeEdgeRefLabel(o.getLabel())) {
                    return false;
                }
                if (labels == null) {
                    return true;
                }
                for (String label : labels) {
                    if (!o.getLabel().equals(label)) continue;
                    return true;
                }
                return false;
            }
        };
        return results;
    }

    private Iterable<EdgeInfo> internalGetEdgeInfo(Direction direction, Authorizations authorizations) {
        return new ConvertingIterable<Edge, EdgeInfo>(this.internalGetEdges(direction, this.getFetchHints(), null, authorizations)){

            @Override
            protected EdgeInfo convert(final Edge edge) {
                return new EdgeInfo(){

                    @Override
                    public String getEdgeId() {
                        if (!InMemoryVertex.this.getFetchHints().isIncludeEdgeIds()) {
                            throw new GeMissingFetchHintException(InMemoryVertex.this.getFetchHints(), "includeEdgeIds");
                        }
                        return edge.getId();
                    }

                    @Override
                    public String getLabel() {
                        return edge.getLabel();
                    }

                    @Override
                    public String getVertexId() {
                        if (!InMemoryVertex.this.getFetchHints().isIncludeEdgeVertexIds()) {
                            throw new GeMissingFetchHintException(InMemoryVertex.this.getFetchHints(), "includeEdgeVertexIds");
                        }
                        return edge.getOtherVertexId(InMemoryVertex.this.getId());
                    }

                    @Override
                    public Direction getDirection() {
                        return edge.getVertexId(Direction.OUT).equals(edge.getOtherVertexId(InMemoryVertex.this.getId())) ? Direction.IN : Direction.OUT;
                    }
                };
            }
        };
    }

    @Override
    public Iterable<Edge> getEdges(Direction direction, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        this.getFetchHints().validateHasEdgeFetchHints(direction, new String[0]);
        if (!this.getFetchHints().isIncludeEdgeIds()) {
            throw new GeMissingFetchHintException(this.getFetchHints(), "includeEdgeIds");
        }
        return this.internalGetEdges(direction, fetchHints, endTime, authorizations);
    }

    private Iterable<Edge> internalGetEdges(final Direction direction, FetchHints fetchHints, Long endTime, Authorizations authorizations) {
        return new FilterIterable<Edge>(this.getGraph().getEdgesFromVertex(this.getId(), fetchHints, endTime, authorizations)){

            @Override
            protected boolean isIncluded(Edge edge) {
                switch (direction) {
                    case IN: {
                        return edge.getVertexId(Direction.IN).equals(InMemoryVertex.this.getId());
                    }
                    case OUT: {
                        return edge.getVertexId(Direction.OUT).equals(InMemoryVertex.this.getId());
                    }
                }
                return true;
            }
        };
    }

    @Override
    public Iterable<String> getEdgeIds(Direction direction, Authorizations authorizations) {
        if (!this.getFetchHints().isIncludeEdgeIds()) {
            throw new GeMissingFetchHintException(this.getFetchHints(), "includeEdgeIds");
        }
        return new EdgeToEdgeIdIterable(this.getEdges(direction, this.getFetchHints(), authorizations));
    }

    @Override
    public Iterable<String> getEdgeIds(Direction direction, String label, Authorizations authorizations) {
        if (!this.getFetchHints().isIncludeEdgeIds()) {
            throw new GeMissingFetchHintException(this.getFetchHints(), "includeEdgeIds");
        }
        return new EdgeToEdgeIdIterable(this.getEdges(direction, label, authorizations));
    }

    @Override
    public Iterable<String> getEdgeIds(Direction direction, String[] labels, Authorizations authorizations) {
        return new EdgeToEdgeIdIterable(this.getEdges(direction, labels, authorizations));
    }

    @Override
    public Iterable<String> getEdgeIds(Vertex otherVertex, Direction direction, Authorizations authorizations) {
        return new EdgeToEdgeIdIterable(this.getEdges(otherVertex, direction, authorizations));
    }

    @Override
    public Iterable<String> getEdgeIds(Vertex otherVertex, Direction direction, String label, Authorizations authorizations) {
        return new EdgeToEdgeIdIterable(this.getEdges(otherVertex, direction, label, authorizations));
    }

    @Override
    public Iterable<String> getEdgeIds(Vertex otherVertex, Direction direction, String[] labels, Authorizations authorizations) {
        return new EdgeToEdgeIdIterable(this.getEdges(otherVertex, direction, labels, authorizations));
    }

    @Override
    public EdgesSummary getEdgesSummary(Authorizations authorizations) {
        Integer c;
        String label;
        HashMap<String, Integer> outEdgeCountsByLabels = new HashMap<String, Integer>();
        HashMap<String, Integer> inEdgeCountsByLabels = new HashMap<String, Integer>();
        for (EdgeInfo entry : this.internalGetEdgeInfo(Direction.IN, authorizations)) {
            label = entry.getLabel();
            c = inEdgeCountsByLabels.getOrDefault(label, 0);
            inEdgeCountsByLabels.put(label, c + 1);
        }
        for (EdgeInfo entry : this.internalGetEdgeInfo(Direction.OUT, authorizations)) {
            label = entry.getLabel();
            c = outEdgeCountsByLabels.getOrDefault(label, 0);
            outEdgeCountsByLabels.put(label, c + 1);
        }
        return new EdgesSummary(outEdgeCountsByLabels, inEdgeCountsByLabels);
    }

    @Override
    public VertexQuery query(String queryString, Authorizations authorizations) {
        return this.getGraph().getSearchIndex().queryVertex(this.getGraph(), this, queryString, authorizations);
    }

    @Override
    public ExistingVertexMutation prepareMutation() {
        return new ExistingVertexMutation(this){

            @Override
            public Vertex save(Authorizations authorizations) {
                IndexHint indexHint = this.getIndexHint();
                InMemoryVertex.this.saveExistingElementMutation(this, indexHint, authorizations);
                Vertex vertex = (Vertex)this.getElement();
                if (indexHint != IndexHint.DO_NOT_INDEX) {
                    InMemoryVertex.this.getGraph().updateElementAndExtendedDataInSearchIndex(vertex, this, authorizations);
                }
                return vertex;
            }
        };
    }
}

