/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.inmemory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.mware.ge.Authorizations;
import com.mware.ge.ElementType;
import com.mware.ge.ExtendedDataRow;
import com.mware.ge.ExtendedDataRowId;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Visibility;
import com.mware.ge.inmemory.InMemoryExtendedDataRow;
import com.mware.ge.inmemory.InMemoryExtendedDataTable;
import com.mware.ge.security.SecurityAuthorizations;
import com.mware.ge.security.VisibilityEvaluator;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.util.StreamUtils;
import com.mware.ge.values.storable.Value;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class MapInMemoryExtendedDataTable
extends InMemoryExtendedDataTable {
    private Map<ElementType, ElementTypeData> elementTypeData = new HashMap<ElementType, ElementTypeData>();

    @Override
    public ImmutableSet<String> getTableNames(ElementType elementType, String elementId, FetchHints fetchHints, Authorizations authorizations) {
        ElementTypeData data = this.elementTypeData.get((Object)elementType);
        if (data == null) {
            return ImmutableSet.of();
        }
        return data.getTableNames(elementId, fetchHints, authorizations);
    }

    public Iterable<ExtendedDataRow> getTable(ElementType elementType, String elementId, String tableName, FetchHints fetchHints, Authorizations authorizations) {
        ElementTypeData data = this.elementTypeData.get((Object)elementType);
        if (data == null) {
            return ImmutableList.of();
        }
        return data.getTable(elementId, tableName, fetchHints, authorizations);
    }

    @Override
    public synchronized void addData(ExtendedDataRowId rowId, String column, String key, Value value, long timestamp, Visibility visibility) {
        ElementTypeData data = this.elementTypeData.computeIfAbsent(rowId.getElementType(), k -> new ElementTypeData());
        data.addData(rowId, column, key, value, timestamp, visibility);
    }

    @Override
    public void remove(ExtendedDataRowId rowId) {
        ElementTypeData data = this.elementTypeData.get((Object)rowId.getElementType());
        if (data != null) {
            data.removeData(rowId);
        }
    }

    @Override
    public void removeColumn(ExtendedDataRowId rowId, String columnName, String key, Visibility visibility) {
        ElementTypeData data = this.elementTypeData.get((Object)rowId.getElementType());
        if (data != null) {
            data.removeColumn(rowId, columnName, key, visibility);
        }
    }

    private static class ElementData {
        private final Map<String, Table> tables = new HashMap<String, Table>();

        private ElementData() {
        }

        public ImmutableSet<String> getTableNames(FetchHints fetchHints, Authorizations authorizations) {
            VisibilityEvaluator visibilityEvaluator = new VisibilityEvaluator(new SecurityAuthorizations(authorizations.getAuthorizations()));
            return this.tables.entrySet().stream().filter(entry -> ((Table)entry.getValue()).canRead(visibilityEvaluator, fetchHints)).map(Map.Entry::getKey).collect(StreamUtils.toImmutableSet());
        }

        public Iterable<ExtendedDataRow> getTable(String tableName, FetchHints fetchHints, Authorizations authorizations) {
            if (tableName == null) {
                return this.getTableNames(fetchHints, authorizations).stream().flatMap(t -> Streams.stream(this.getTable((String)t, fetchHints, authorizations))).collect(Collectors.toList());
            }
            VisibilityEvaluator visibilityEvaluator = new VisibilityEvaluator(new SecurityAuthorizations(authorizations.getAuthorizations()));
            Table table = this.tables.get(tableName);
            if (table == null) {
                throw new GeException("Invalid table '" + tableName + "'");
            }
            Iterable<ExtendedDataRow> rows = table.getRows(visibilityEvaluator, fetchHints);
            if (!rows.iterator().hasNext()) {
                return Collections.emptyList();
            }
            return rows;
        }

        public synchronized void addData(ExtendedDataRowId rowId, String column, String key, Value value, long timestamp, Visibility visibility) {
            Table table = this.tables.computeIfAbsent(rowId.getTableName(), k -> new Table());
            table.addData(rowId, column, key, value, timestamp, visibility);
        }

        public void removeData(ExtendedDataRowId rowId) {
            Table table = this.tables.get(rowId.getTableName());
            if (table != null) {
                table.removeData(rowId);
            }
        }

        public void removeColumn(ExtendedDataRowId rowId, String columnName, String key, Visibility visibility) {
            Table table = this.tables.get(rowId.getTableName());
            if (table != null) {
                table.removeColumn(rowId, columnName, key, visibility);
            }
        }

        private class Table {
            private final TreeSet<InMemoryExtendedDataRow> rows = new TreeSet();

            private Table() {
            }

            public Iterable<ExtendedDataRow> getRows(VisibilityEvaluator visibilityEvaluator, FetchHints fetchHints) {
                return this.rows.stream().map(row -> row.toReadable(visibilityEvaluator, fetchHints)).filter(Objects::nonNull).filter(row -> IterableUtils.count(row.getProperties()) > 0).collect(Collectors.toList());
            }

            public boolean canRead(VisibilityEvaluator visibilityEvaluator, FetchHints fetchHints) {
                return this.rows.stream().anyMatch(r -> r.canRead(visibilityEvaluator, fetchHints));
            }

            public void addData(ExtendedDataRowId rowId, String column, String key, Value value, long timestamp, Visibility visibility) {
                InMemoryExtendedDataRow row = this.findOrAddRow(rowId);
                row.addColumn(column, key, value, timestamp, visibility);
            }

            private InMemoryExtendedDataRow findOrAddRow(ExtendedDataRowId rowId) {
                InMemoryExtendedDataRow row = this.findRow(rowId);
                if (row != null) {
                    return row;
                }
                row = new InMemoryExtendedDataRow(rowId, FetchHints.ALL);
                this.rows.add(row);
                return row;
            }

            private InMemoryExtendedDataRow findRow(ExtendedDataRowId rowId) {
                for (InMemoryExtendedDataRow row : this.rows) {
                    if (!row.getId().equals(rowId)) continue;
                    return row;
                }
                return null;
            }

            public void removeData(ExtendedDataRowId rowId) {
                this.rows.removeIf(row -> row.getId().equals(rowId));
            }

            public void removeColumn(ExtendedDataRowId rowId, String columnName, String key, Visibility visibility) {
                InMemoryExtendedDataRow row = this.findRow(rowId);
                if (row == null) {
                    return;
                }
                row.removeColumn(columnName, key, visibility);
            }
        }
    }

    private static class ElementTypeData {
        Map<String, ElementData> elementData = new HashMap<String, ElementData>();

        private ElementTypeData() {
        }

        public ImmutableSet<String> getTableNames(String elementId, FetchHints fetchHints, Authorizations authorizations) {
            ElementData data = this.elementData.get(elementId);
            if (data == null) {
                return ImmutableSet.of();
            }
            return data.getTableNames(fetchHints, authorizations);
        }

        public Iterable<ExtendedDataRow> getTable(String elementId, String tableName, FetchHints fetchHints, Authorizations authorizations) {
            ElementData data = this.elementData.get(elementId);
            if (data == null) {
                return ImmutableList.of();
            }
            return data.getTable(tableName, fetchHints, authorizations);
        }

        public synchronized void addData(ExtendedDataRowId rowId, String column, String key, Value value, long timestamp, Visibility visibility) {
            ElementData data = this.elementData.computeIfAbsent(rowId.getElementId(), k -> new ElementData());
            data.addData(rowId, column, key, value, timestamp, visibility);
        }

        public void removeData(ExtendedDataRowId rowId) {
            ElementData data = this.elementData.get(rowId.getElementId());
            if (data != null) {
                data.removeData(rowId);
            }
        }

        public void removeColumn(ExtendedDataRowId rowId, String columnName, String key, Visibility visibility) {
            ElementData data = this.elementData.get(rowId.getElementId());
            if (data != null) {
                data.removeColumn(rowId, columnName, key, visibility);
            }
        }
    }
}

