/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.inmemory.mutations;

import com.mware.ge.Visibility;
import com.mware.ge.util.IncreasingTime;
import java.io.Serializable;
import java.util.Objects;

public abstract class Mutation
implements Comparable<Mutation>,
Serializable {
    private final long objectCreationTimestamp = IncreasingTime.currentTimeMillis();
    private final long timestamp;
    private final Visibility visibility;

    protected Mutation(long timestamp, Visibility visibility) {
        this.timestamp = timestamp;
        this.visibility = visibility;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public int compareTo(Mutation o) {
        int result = Long.compare(this.getTimestamp(), o.getTimestamp());
        if (result != 0) {
            return result;
        }
        result = this.getClass().getName().compareTo(o.getClass().getName());
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.objectCreationTimestamp, o.objectCreationTimestamp);
        if (result != 0) {
            return result;
        }
        return Integer.compare(System.identityHashCode(this), System.identityHashCode(o));
    }

    public String toString() {
        return this.getClass().getName() + "{timestamp=" + this.timestamp + ", visibility=" + this.visibility + '}';
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Mutation)) {
            return false;
        }
        Mutation other = (Mutation)obj;
        return this.timestamp == other.timestamp && Objects.equals(this.visibility, other.visibility);
    }
}

