/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.inmemory.mutations;

import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.inmemory.mutations.Mutation;
import java.util.Objects;

public class PropertyMutation
extends Mutation {
    private final String propertyKey;
    private final String propertyName;
    private final Visibility propertyVisibility;

    protected PropertyMutation(long timestamp, String propertyKey, String propertyName, Visibility propertyVisibility, Visibility visibility) {
        super(timestamp, visibility);
        this.propertyKey = propertyKey;
        this.propertyName = propertyName;
        this.propertyVisibility = propertyVisibility;
    }

    protected PropertyMutation(long timestamp, Property property, Visibility visibility) {
        this(timestamp, property.getKey(), property.getName(), property.getVisibility(), visibility);
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Visibility getPropertyVisibility() {
        return this.propertyVisibility;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "{propertyKey='" + this.propertyKey + '\'' + ", propertyName='" + this.propertyName + '\'' + ", propertyVisibility=" + this.propertyVisibility + ", timestamp=" + this.getTimestamp() + ", visibility=" + this.getVisibility() + '}';
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PropertyMutation)) {
            return false;
        }
        PropertyMutation other = (PropertyMutation)obj;
        return super.equals(other) && Objects.equals(this.propertyKey, other.propertyKey) && Objects.equals(this.propertyName, other.propertyName) && Objects.equals(this.propertyVisibility, other.propertyVisibility);
    }
}

