/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.function.BiFunction;

public final class IOUtils {
    private IOUtils() {
    }

    public static <T extends AutoCloseable> void closeAll(Collection<T> closeables) throws IOException {
        IOUtils.close(IOException::new, (AutoCloseable[])closeables.toArray(new AutoCloseable[0]));
    }

    public static <T extends AutoCloseable> void closeAllUnchecked(Collection<T> closeables) throws UncheckedIOException {
        IOUtils.closeAllUnchecked((AutoCloseable[])closeables.toArray(new AutoCloseable[0]));
    }

    @SafeVarargs
    public static <T extends AutoCloseable> void closeAllUnchecked(T ... closeables) throws UncheckedIOException {
        try {
            IOUtils.closeAll(closeables);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T extends AutoCloseable> void closeAllSilently(Collection<T> closeables) {
        IOUtils.close((T msg, U cause) -> null, (AutoCloseable[])closeables.toArray(new AutoCloseable[0]));
    }

    @SafeVarargs
    public static <T extends AutoCloseable> void closeAll(T ... closeables) throws IOException {
        IOUtils.close(IOException::new, closeables);
    }

    @SafeVarargs
    public static <T extends AutoCloseable> void closeAllSilently(T ... closeables) {
        IOUtils.close((T msg, U cause) -> null, closeables);
    }

    public static <T extends AutoCloseable, E extends Throwable> void close(BiFunction<String, Throwable, E> constructor, Collection<T> closeables) throws E {
        IOUtils.close(constructor, (AutoCloseable[])closeables.toArray(new AutoCloseable[0]));
    }

    @SafeVarargs
    public static <T extends AutoCloseable, E extends Throwable> void close(BiFunction<String, Throwable, E> constructor, T ... closeables) throws E {
        Throwable closeThrowable = null;
        for (T closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Exception e) {
                if (closeThrowable == null) {
                    closeThrowable = (Throwable)constructor.apply("Exception closing multiple resources.", e);
                    continue;
                }
                closeThrowable.addSuppressed(e);
            }
        }
        if (closeThrowable != null) {
            throw closeThrowable;
        }
    }
}

