/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.io;

import com.mware.ge.io.Resource;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ResourceUtils {
    public static <T extends Resource> void closeAll(Iterable<T> resources) {
        ResourceUtils.closeAll(StreamSupport.stream(resources.spliterator(), false));
    }

    @SafeVarargs
    public static <T extends Resource> void closeAll(T ... resources) {
        ResourceUtils.closeAll(Arrays.stream(resources));
    }

    public static <T extends Resource> void closeAll(Stream<T> resources) {
        resources.filter(Objects::nonNull).forEach(Resource::close);
    }
}

