/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.metric;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.mware.ge.GeException;
import com.mware.ge.metric.GeMetricRegistry;
import com.mware.ge.metric.StackTraceTracker;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class DropWizardMetricRegistry
implements GeMetricRegistry {
    private static final String START_CONSOLE_REPORTER_PROPERTY_NAME = "metricRegistryStartConsoleReporter";
    private final MetricRegistry metricRegistry;
    private final Map<String, Counter> countersByName = new ConcurrentHashMap<String, Counter>();
    private final Map<String, Timer> timersByName = new ConcurrentHashMap<String, Timer>();
    private final Map<String, Histogram> histogramsByName = new ConcurrentHashMap<String, Histogram>();
    private final Map<String, Gauge> gaugesByName = new ConcurrentHashMap<String, Gauge>();
    private final Map<String, StackTraceTracker> stackTraceTrackersByName = new ConcurrentHashMap<String, StackTraceTracker>();
    private boolean consoleReporterStarted;
    private ConsoleReporter consoleReporter;

    public DropWizardMetricRegistry() {
        this(new MetricRegistry());
    }

    public DropWizardMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        this.startConsoleReporterUsingSystemProperty();
    }

    private void startConsoleReporterUsingSystemProperty() {
        String startConsoleReporter = System.getProperty(START_CONSOLE_REPORTER_PROPERTY_NAME, "false").trim();
        if (startConsoleReporter.equalsIgnoreCase("false")) {
            return;
        }
        if (startConsoleReporter.equalsIgnoreCase("true") || startConsoleReporter.length() == 0) {
            this.startConsoleReporter(10L, TimeUnit.SECONDS);
            return;
        }
        this.startConsoleReporter(startConsoleReporter);
    }

    private void startConsoleReporter(String period) {
        try {
            Duration duration = DropWizardMetricRegistry.parseDuration(period);
            this.startConsoleReporter(duration.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            throw new GeException("Could not parse period: " + period, ex);
        }
    }

    static Duration parseDuration(String period) {
        period = period.trim();
        try {
            return Duration.parse(period.toUpperCase());
        }
        catch (Exception ex) {
            return Duration.parse("PT" + period.toUpperCase());
        }
    }

    public void startConsoleReporter(long periodMillis) {
        this.startConsoleReporter(periodMillis, TimeUnit.MILLISECONDS);
    }

    public void startConsoleReporter(long period, TimeUnit timeUnit) {
        if (this.consoleReporterStarted) {
            throw new GeException("console reporter already started");
        }
        this.getConsoleReporter().start(period, timeUnit);
        this.consoleReporterStarted = true;
    }

    public void stopConsoleReporter() {
        if (!this.consoleReporterStarted) {
            throw new GeException("console reporter not started");
        }
        this.getConsoleReporter().stop();
        this.consoleReporterStarted = false;
    }

    private ConsoleReporter getConsoleReporter() {
        if (this.consoleReporter == null) {
            this.consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)this.getMetricRegistry()).build();
        }
        return this.consoleReporter;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public boolean isConsoleReporterStarted() {
        return this.consoleReporterStarted;
    }

    @Override
    public String createName(Class clazz, String ... nameParts) {
        return MetricRegistry.name((Class)clazz, (String[])nameParts);
    }

    @Override
    public Counter getCounter(String name) {
        return this.countersByName.computeIfAbsent(name, n -> new Counter(this.metricRegistry.counter(n)));
    }

    public Iterable<Counter> getCounters() {
        return this.countersByName.values();
    }

    @Override
    public Timer getTimer(String name) {
        return this.timersByName.computeIfAbsent(name, n -> new Timer(this.metricRegistry.timer(n)));
    }

    public Iterable<Timer> getTimers() {
        return this.timersByName.values();
    }

    @Override
    public Histogram getHistogram(String name) {
        return this.histogramsByName.computeIfAbsent(name, n -> new Histogram(this.metricRegistry.histogram(n)));
    }

    public Iterable<Histogram> getHistograms() {
        return this.histogramsByName.values();
    }

    public <T> Gauge<T> getGauge(String name, Supplier<T> supplier) {
        return this.gaugesByName.computeIfAbsent(name, n -> {
            com.codahale.metrics.Gauge g = (com.codahale.metrics.Gauge)this.metricRegistry.register(name, (Metric)((com.codahale.metrics.Gauge)((Supplier)supplier)::get));
            return new Gauge(g);
        });
    }

    public Iterable<Gauge> getGauges() {
        return this.gaugesByName.values();
    }

    @Override
    public StackTraceTracker getStackTraceTracker(String name) {
        return this.stackTraceTrackersByName.computeIfAbsent(name, s -> new StackTraceTracker());
    }

    @Override
    public Iterable<? extends StackTraceTracker> getStackTraceTrackers() {
        return this.stackTraceTrackersByName.values();
    }

    @Override
    public void shutdown() {
        this.countersByName.keySet().forEach(arg_0 -> ((MetricRegistry)this.metricRegistry).remove(arg_0));
        this.timersByName.keySet().forEach(arg_0 -> ((MetricRegistry)this.metricRegistry).remove(arg_0));
        this.histogramsByName.keySet().forEach(arg_0 -> ((MetricRegistry)this.metricRegistry).remove(arg_0));
        this.gaugesByName.keySet().forEach(arg_0 -> ((MetricRegistry)this.metricRegistry).remove(arg_0));
        this.stackTraceTrackersByName.keySet().forEach(arg_0 -> ((MetricRegistry)this.metricRegistry).remove(arg_0));
        if (this.consoleReporter != null && this.consoleReporterStarted) {
            this.consoleReporter.report();
        }
    }

    public static class Histogram
    implements com.mware.ge.metric.Histogram {
        private final com.codahale.metrics.Histogram histogram;

        public Histogram(com.codahale.metrics.Histogram histogram) {
            this.histogram = histogram;
        }

        public com.codahale.metrics.Histogram getHistogram() {
            return this.histogram;
        }

        @Override
        public void update(int value) {
            this.histogram.update(value);
        }

        @Override
        public void update(long value) {
            this.histogram.update(value);
        }
    }

    public static class Timer
    implements com.mware.ge.metric.Timer {
        private final com.codahale.metrics.Timer timer;

        public Timer(com.codahale.metrics.Timer timer) {
            this.timer = timer;
        }

        public com.codahale.metrics.Timer getTimer() {
            return this.timer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T time(Supplier<T> supplier) {
            Timer.Context ctx = this.timer.time();
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                ctx.stop();
            }
        }

        @Override
        public void update(long duration, TimeUnit unit) {
            this.timer.update(duration, unit);
        }
    }

    public static class Counter
    implements com.mware.ge.metric.Counter {
        private final com.codahale.metrics.Counter counter;

        public Counter(com.codahale.metrics.Counter counter) {
            this.counter = counter;
        }

        public com.codahale.metrics.Counter getCounter() {
            return this.counter;
        }

        @Override
        public void increment(long amount) {
            this.counter.inc(amount);
        }

        @Override
        public void decrement(long amount) {
            this.counter.dec(amount);
        }

        @Override
        public long getCount() {
            return this.counter.getCount();
        }
    }

    public static class Gauge<T>
    implements com.mware.ge.metric.Gauge<T> {
        private final com.codahale.metrics.Gauge gauge;

        public Gauge(com.codahale.metrics.Gauge gauge) {
            this.gauge = gauge;
        }

        public com.codahale.metrics.Gauge getGauge() {
            return this.gauge;
        }
    }
}

