/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.metric;

import com.google.common.base.Joiner;
import com.mware.ge.metric.Counter;
import com.mware.ge.metric.Gauge;
import com.mware.ge.metric.GeMetricRegistry;
import com.mware.ge.metric.Histogram;
import com.mware.ge.metric.StackTraceTracker;
import com.mware.ge.metric.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class NullMetricRegistry
implements GeMetricRegistry {
    private final Map<String, Counter> countersByName = new HashMap<String, Counter>();
    private final Map<String, Timer> timersByName = new HashMap<String, Timer>();
    private final Map<String, Histogram> histogramsByName = new HashMap<String, Histogram>();
    private final Map<String, Gauge> gaugesByName = new HashMap<String, Gauge>();
    private final Map<String, StackTraceTracker> stackTraceTrackersByName = new HashMap<String, StackTraceTracker>();

    @Override
    public String createName(Class clazz, String ... nameParts) {
        return clazz.getName() + "." + Joiner.on((String)".").join((Object[])nameParts);
    }

    @Override
    public Counter getCounter(String name) {
        return this.countersByName.computeIfAbsent(name, s -> new Counter(){
            long count;

            @Override
            public void increment(long amount) {
                this.count += amount;
            }

            @Override
            public void decrement(long amount) {
                this.count += amount;
            }

            @Override
            public long getCount() {
                return this.count;
            }
        });
    }

    public Iterable<Counter> getCounters() {
        return this.countersByName.values();
    }

    @Override
    public Timer getTimer(String name) {
        return this.timersByName.computeIfAbsent(name, s -> new Timer(){

            @Override
            public <T> T time(Supplier<T> supplier) {
                return supplier.get();
            }

            @Override
            public void update(long duration, TimeUnit unit) {
            }
        });
    }

    public Iterable<Timer> getTimers() {
        return this.timersByName.values();
    }

    @Override
    public Histogram getHistogram(String name) {
        return this.histogramsByName.computeIfAbsent(name, s -> new Histogram(){

            @Override
            public void update(int value) {
            }

            @Override
            public void update(long value) {
            }
        });
    }

    public Iterable<Histogram> getHistograms() {
        return this.histogramsByName.values();
    }

    @Override
    public <T> Gauge<T> getGauge(String name, Supplier<T> supplier) {
        return this.gaugesByName.computeIfAbsent(name, s -> new Gauge<T>(){});
    }

    public Iterable<Gauge> getGauges() {
        return this.gaugesByName.values();
    }

    @Override
    public StackTraceTracker getStackTraceTracker(String name) {
        return this.stackTraceTrackersByName.computeIfAbsent(name, s -> new StackTraceTracker());
    }

    @Override
    public Iterable<? extends StackTraceTracker> getStackTraceTrackers() {
        return this.stackTraceTrackersByName.values();
    }

    @Override
    public void shutdown() {
        this.countersByName.clear();
        this.timersByName.clear();
        this.histogramsByName.clear();
        this.gaugesByName.clear();
        this.stackTraceTrackersByName.clear();
    }
}

