/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.metric;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class StackTraceTracker {
    private final Set<StackTraceItem> roots = Collections.synchronizedSet(new HashSet());

    public void addStackTrace() {
        this.addStackTrace(Thread.currentThread().getStackTrace());
    }

    public void addStackTrace(StackTraceElement[] stackTraceElements) {
        Set parents = this.roots;
        for (int i = stackTraceElements.length - 1; i >= 0; --i) {
            StackTraceElement stackTraceElement = stackTraceElements[i];
            StackTraceItem item = this.addItem(parents, stackTraceElement);
            item.count++;
            parents = item.children;
        }
    }

    private StackTraceItem addItem(Set<StackTraceItem> parents, StackTraceElement stackTraceElement) {
        StackTraceItem item = this.getItem(parents, stackTraceElement);
        if (item == null) {
            item = new StackTraceItem(stackTraceElement);
            parents.add(item);
        }
        return item;
    }

    private StackTraceItem getItem(Set<StackTraceItem> parents, StackTraceElement stackTraceElement) {
        for (StackTraceItem item : parents) {
            if (!item.equals(stackTraceElement)) continue;
            return item;
        }
        return null;
    }

    public Set<StackTraceItem> getRoots() {
        return this.roots;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        this.toString(result, "", this.getRoots());
        return result.toString();
    }

    private void toString(StringBuilder result, String indent, Set<StackTraceItem> items) {
        for (StackTraceItem item : items) {
            result.append(indent);
            result.append(item.toString());
            result.append("\n");
            this.toString(result, indent + "  ", item.children);
        }
    }

    public void reset() {
        this.roots.clear();
    }

    public static class StackTraceItem {
        private final Set<StackTraceItem> children = new HashSet<StackTraceItem>();
        private final StackTraceElement stackTraceElement;
        private int count;

        public StackTraceItem(StackTraceElement stackTraceElement) {
            this.stackTraceElement = stackTraceElement;
        }

        public String toString() {
            return String.format("%s (count=%d)", this.stackTraceElement, this.count);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof StackTraceElement) {
                return this.stackTraceElement.equals(o);
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StackTraceItem that = (StackTraceItem)o;
            return this.stackTraceElement.equals(that.stackTraceElement);
        }

        public int hashCode() {
            return Objects.hash(this.stackTraceElement);
        }

        public Set<StackTraceItem> getChildren() {
            return this.children;
        }

        public StackTraceElement getStackTraceElement() {
            return this.stackTraceElement;
        }

        public int getCount() {
            return this.count;
        }
    }
}

