/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.mutation;

import com.mware.ge.Authorizations;
import com.mware.ge.Element;
import com.mware.ge.ElementType;
import com.mware.ge.FetchHints;
import com.mware.ge.GeMissingFetchHintException;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.AlterPropertyVisibility;
import com.mware.ge.mutation.ElementMutation;
import com.mware.ge.mutation.ExistingElementMutation;
import com.mware.ge.mutation.ExtendedDataDeleteMutation;
import com.mware.ge.mutation.ExtendedDataMutation;
import com.mware.ge.mutation.PropertyDeleteMutation;
import com.mware.ge.mutation.PropertyPropertyDeleteMutation;
import com.mware.ge.mutation.PropertyPropertySoftDeleteMutation;
import com.mware.ge.mutation.PropertySoftDeleteMutation;
import com.mware.ge.mutation.SetPropertyMetadata;
import com.mware.ge.property.MutablePropertyImpl;
import com.mware.ge.search.IndexHint;
import com.mware.ge.util.IncreasingTime;
import com.mware.ge.util.Preconditions;
import com.mware.ge.values.storable.Value;
import java.util.ArrayList;
import java.util.List;

public abstract class ExistingElementMutationImpl<T extends Element>
implements ElementMutation<T>,
ExistingElementMutation<T> {
    private final List<Property> properties = new ArrayList<Property>();
    private final List<PropertyDeleteMutation> propertyDeletes = new ArrayList<PropertyDeleteMutation>();
    private final List<PropertySoftDeleteMutation> propertySoftDeletes = new ArrayList<PropertySoftDeleteMutation>();
    private Visibility newElementVisibility;
    private Visibility oldElementVisibility;
    private final List<AlterPropertyVisibility> alterPropertyVisibilities = new ArrayList<AlterPropertyVisibility>();
    private final List<SetPropertyMetadata> setPropertyMetadatas = new ArrayList<SetPropertyMetadata>();
    private final List<ExtendedDataMutation> extendedDatas = new ArrayList<ExtendedDataMutation>();
    private final List<ExtendedDataDeleteMutation> extendedDataDeletes = new ArrayList<ExtendedDataDeleteMutation>();
    private final T element;
    private final ElementType elementType;
    private IndexHint indexHint = IndexHint.INDEX;

    public ExistingElementMutationImpl(T element) {
        this.element = element;
        this.elementType = ElementType.getTypeFromElement(element);
        if (element != null) {
            this.oldElementVisibility = element.getVisibility();
        }
    }

    public ExistingElementMutationImpl overrideProperties(List<Property> properties) {
        this.properties.clear();
        this.properties.addAll(properties);
        return this;
    }

    public ExistingElementMutationImpl overridePropertyDeletes(List<PropertyDeleteMutation> propertyDeletes) {
        this.propertyDeletes.clear();
        this.propertyDeletes.addAll(propertyDeletes);
        return this;
    }

    public ExistingElementMutationImpl overridePropertySoftDeletes(List<PropertySoftDeleteMutation> propertySoftDeletes) {
        this.propertySoftDeletes.clear();
        this.propertySoftDeletes.addAll(propertySoftDeletes);
        return this;
    }

    public ExistingElementMutationImpl overrideAlterPropertyVisibilities(List<AlterPropertyVisibility> alterPropertyVisibilities) {
        this.alterPropertyVisibilities.clear();
        this.alterPropertyVisibilities.addAll(alterPropertyVisibilities);
        return this;
    }

    public ExistingElementMutationImpl overrideSetPropertyMetadatas(List<SetPropertyMetadata> setPropertyMetadatas) {
        this.setPropertyMetadatas.clear();
        this.setPropertyMetadatas.addAll(setPropertyMetadatas);
        return this;
    }

    public ExistingElementMutationImpl overrideExtendedDatas(List<ExtendedDataMutation> extendedDatas) {
        this.extendedDatas.clear();
        this.extendedDatas.addAll(extendedDatas);
        return this;
    }

    public ExistingElementMutationImpl overrideExtendedDataDeletes(List<ExtendedDataDeleteMutation> extendedDataDeletes) {
        this.extendedDataDeletes.clear();
        this.extendedDataDeletes.addAll(extendedDataDeletes);
        return this;
    }

    public ExistingElementMutationImpl overrideOldElementVisibility(Visibility oldElementVisibility) {
        this.oldElementVisibility = oldElementVisibility;
        return this;
    }

    public ExistingElementMutationImpl overrideNewElementVisibility(Visibility newElementVisibility) {
        this.newElementVisibility = newElementVisibility;
        return this;
    }

    @Override
    public abstract T save(Authorizations var1);

    @Override
    public ElementMutation<T> setProperty(String name, Value value, Visibility visibility) {
        return this.setProperty(name, value, Metadata.create(FetchHints.ALL), visibility);
    }

    @Override
    public ElementMutation<T> setProperty(String name, Value value, Metadata metadata, Visibility visibility) {
        return this.addPropertyValue("", name, value, metadata, visibility);
    }

    @Override
    public ElementMutation<T> addPropertyValue(String key, String name, Value value, Visibility visibility) {
        return this.addPropertyValue(key, name, value, Metadata.create(FetchHints.ALL), visibility);
    }

    @Override
    public ElementMutation<T> addPropertyValue(String key, String name, Value value, Metadata metadata, Visibility visibility) {
        return this.addPropertyValue(key, name, value, metadata, IncreasingTime.currentTimeMillis(), visibility);
    }

    @Override
    public ElementMutation<T> addPropertyValue(String key, String name, Value value, Metadata metadata, Long timestamp, Visibility visibility) {
        Preconditions.checkNotNull(name, "property name cannot be null for property: " + name + ":" + key);
        Preconditions.checkNotNull(value, "property value cannot be null for property: " + name + ":" + key);
        this.properties.add(new MutablePropertyImpl(key, name, value, metadata, timestamp, null, visibility, FetchHints.ALL_INCLUDING_HIDDEN));
        return this;
    }

    @Override
    public Iterable<Property> getProperties() {
        return this.properties;
    }

    @Override
    public Iterable<PropertyDeleteMutation> getPropertyDeletes() {
        return this.propertyDeletes;
    }

    @Override
    public Iterable<PropertySoftDeleteMutation> getPropertySoftDeletes() {
        return this.propertySoftDeletes;
    }

    @Override
    public Iterable<ExtendedDataMutation> getExtendedData() {
        return this.extendedDatas;
    }

    @Override
    public ElementMutation<T> deleteProperty(Property property) {
        if (!this.element.getFetchHints().isIncludePropertyAndMetadata(property.getName())) {
            throw new GeMissingFetchHintException(this.element.getFetchHints(), "Property " + property.getName() + " needs to be included with metadata");
        }
        Preconditions.checkNotNull(property, "property cannot be null");
        this.propertyDeletes.add(new PropertyPropertyDeleteMutation(property));
        return this;
    }

    @Override
    public Iterable<ExtendedDataDeleteMutation> getExtendedDataDeletes() {
        return this.extendedDataDeletes;
    }

    @Override
    public ExistingElementMutation<T> deleteProperties(String name) {
        for (Property prop : this.element.getProperties(name)) {
            this.deleteProperty(prop);
        }
        return this;
    }

    @Override
    public ExistingElementMutation<T> deleteProperties(String key, String name) {
        for (Property prop : this.element.getProperties(key, name)) {
            this.deleteProperty(prop);
        }
        return this;
    }

    @Override
    public ElementMutation<T> deleteProperty(String name, Visibility visibility) {
        Property property = this.element.getProperty(name, visibility);
        if (property != null) {
            this.deleteProperty(property);
        }
        return this;
    }

    @Override
    public ElementMutation<T> deleteProperty(String key, String name, Visibility visibility) {
        Property property = this.element.getProperty(key, name, visibility);
        if (property != null) {
            this.deleteProperty(property);
        }
        return this;
    }

    @Override
    public ElementMutation<T> softDeleteProperty(Property property) {
        Preconditions.checkNotNull(property, "property cannot be null");
        this.propertySoftDeletes.add(new PropertyPropertySoftDeleteMutation(property));
        return this;
    }

    @Override
    public ExistingElementMutation<T> softDeleteProperties(String name) {
        for (Property prop : this.element.getProperties(name)) {
            this.softDeleteProperty(prop);
        }
        return this;
    }

    @Override
    public ExistingElementMutation<T> softDeleteProperties(String key, String name) {
        for (Property prop : this.element.getProperties(key, name)) {
            this.softDeleteProperty(prop);
        }
        return this;
    }

    @Override
    public ElementMutation<T> softDeleteProperty(String name, Visibility visibility) {
        Property property = this.element.getProperty(name, visibility);
        if (property != null) {
            this.softDeleteProperty(property);
        }
        return this;
    }

    @Override
    public ElementMutation<T> softDeleteProperty(String key, String name, Visibility visibility) {
        Property property = this.element.getProperty(key, name, visibility);
        if (property != null) {
            this.softDeleteProperty(property);
        }
        return this;
    }

    @Override
    public ExistingElementMutation<T> alterPropertyVisibility(Property property, Visibility visibility) {
        if (!this.element.getFetchHints().isIncludePropertyAndMetadata(property.getName())) {
            throw new GeMissingFetchHintException(this.element.getFetchHints(), "Property " + property.getName() + " needs to be included with metadata");
        }
        this.alterPropertyVisibilities.add(new AlterPropertyVisibility(property.getKey(), property.getName(), property.getVisibility(), visibility));
        return this;
    }

    @Override
    public ExistingElementMutation<T> alterPropertyVisibility(String name, Visibility visibility) {
        return this.alterPropertyVisibility("", name, visibility);
    }

    @Override
    public ExistingElementMutation<T> alterPropertyVisibility(String key, String name, Visibility visibility) {
        if (!this.element.getFetchHints().isIncludePropertyAndMetadata(name)) {
            throw new GeMissingFetchHintException(this.element.getFetchHints(), "Property " + name + " needs to be included with metadata");
        }
        this.alterPropertyVisibilities.add(new AlterPropertyVisibility(key, name, null, visibility));
        return this;
    }

    @Override
    public ExistingElementMutation<T> alterElementVisibility(Visibility visibility) {
        this.newElementVisibility = visibility;
        return this;
    }

    @Override
    public ExistingElementMutation<T> setPropertyMetadata(Property property, String metadataName, Value newValue, Visibility visibility) {
        this.setPropertyMetadatas.add(new SetPropertyMetadata(property.getKey(), property.getName(), property.getVisibility(), metadataName, newValue, visibility));
        return this;
    }

    @Override
    public ExistingElementMutation<T> setPropertyMetadata(String propertyName, String metadataName, Value newValue, Visibility visibility) {
        return this.setPropertyMetadata("", propertyName, metadataName, newValue, visibility);
    }

    @Override
    public ExistingElementMutation<T> setPropertyMetadata(String propertyKey, String propertyName, String metadataName, Value newValue, Visibility visibility) {
        this.setPropertyMetadatas.add(new SetPropertyMetadata(propertyKey, propertyName, null, metadataName, newValue, visibility));
        return this;
    }

    @Override
    public ExistingElementMutation<T> addExtendedData(String tableName, String row, String column, Value value, Visibility visibility) {
        return this.addExtendedData(tableName, row, column, null, value, null, visibility);
    }

    @Override
    public ExistingElementMutation<T> addExtendedData(String tableName, String row, String column, Value value, Long timestamp, Visibility visibility) {
        return this.addExtendedData(tableName, row, column, null, value, timestamp, visibility);
    }

    @Override
    public ExistingElementMutation<T> addExtendedData(String tableName, String row, String column, String key, Value value, Visibility visibility) {
        return this.addExtendedData(tableName, row, column, key, value, null, visibility);
    }

    @Override
    public ExistingElementMutation<T> addExtendedData(String tableName, String row, String column, String key, Value value, Long timestamp, Visibility visibility) {
        this.extendedDatas.add(new ExtendedDataMutation(tableName, row, column, key, value, timestamp, visibility));
        return this;
    }

    @Override
    public ExistingElementMutation<T> deleteExtendedData(String tableName, String row, String column, Visibility visibility) {
        return this.deleteExtendedData(tableName, row, column, null, visibility);
    }

    @Override
    public ElementMutation<T> deleteExtendedData(String tableName, String row) {
        return this.deleteExtendedData(tableName, row, null, null, null);
    }

    @Override
    public ElementMutation<T> deleteExtendedDataTable(String tableName) {
        return this.deleteExtendedData(tableName, null, null, null, null);
    }

    @Override
    public ExistingElementMutation<T> deleteExtendedData(String tableName, String row, String column, String key, Visibility visibility) {
        this.extendedDataDeletes.add(new ExtendedDataDeleteMutation(tableName, row, column, key, visibility));
        return this;
    }

    @Override
    public T getElement() {
        return this.element;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    @Override
    public String getId() {
        return this.getElement().getId();
    }

    @Override
    public Visibility getVisibility() {
        return this.getElement().getVisibility();
    }

    @Override
    public Visibility getNewElementVisibility() {
        return this.newElementVisibility;
    }

    @Override
    public Visibility getOldElementVisibility() {
        return this.oldElementVisibility;
    }

    @Override
    public List<AlterPropertyVisibility> getAlterPropertyVisibilities() {
        return this.alterPropertyVisibilities;
    }

    @Override
    public List<SetPropertyMetadata> getSetPropertyMetadatas() {
        return this.setPropertyMetadatas;
    }

    @Override
    public IndexHint getIndexHint() {
        return this.indexHint;
    }

    @Override
    public ElementMutation<T> setIndexHint(IndexHint indexHint) {
        this.indexHint = indexHint;
        return this;
    }

    @Override
    public boolean hasChanges() {
        if (this.properties.size() > 0) {
            return true;
        }
        if (this.propertyDeletes.size() > 0) {
            return true;
        }
        if (this.propertySoftDeletes.size() > 0) {
            return true;
        }
        if (this.newElementVisibility != null) {
            return true;
        }
        if (this.alterPropertyVisibilities.size() > 0) {
            return true;
        }
        if (this.setPropertyMetadatas.size() > 0) {
            return true;
        }
        if (this.extendedDatas.size() > 0) {
            return true;
        }
        return this.extendedDataDeletes.size() > 0;
    }
}

