/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.property;

import com.mware.ge.Authorizations;
import com.mware.ge.FetchHints;
import com.mware.ge.GeMissingFetchHintException;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.property.MutableProperty;
import com.mware.ge.values.storable.Value;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class MutablePropertyImpl
extends MutableProperty {
    private final String key;
    private final String name;
    private final FetchHints fetchHints;
    private Set<Visibility> hiddenVisibilities;
    private Value value;
    private Visibility visibility;
    private Long timestamp;
    private final Metadata metadata;

    public MutablePropertyImpl(String key, String name, Value value, Metadata metadata, Long timestamp, Set<Visibility> hiddenVisibilities, Visibility visibility, FetchHints fetchHints) {
        if (metadata == null && fetchHints.isIncludePropertyMetadata()) {
            metadata = Metadata.create(FetchHints.ALL);
        }
        this.key = key;
        this.name = name;
        this.value = value;
        this.metadata = metadata;
        this.timestamp = timestamp;
        this.visibility = visibility;
        this.hiddenVisibilities = hiddenVisibilities;
        this.fetchHints = fetchHints;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public FetchHints getFetchHints() {
        return this.fetchHints;
    }

    @Override
    public Metadata getMetadata() {
        if (!this.fetchHints.isIncludePropertyMetadata()) {
            throw new GeMissingFetchHintException(this.fetchHints, "includePropertyMetadata");
        }
        return this.metadata;
    }

    @Override
    public Iterable<Visibility> getHiddenVisibilities() {
        if (this.hiddenVisibilities == null) {
            return new ArrayList<Visibility>();
        }
        return this.hiddenVisibilities;
    }

    @Override
    public boolean isHidden(Authorizations authorizations) {
        if (this.hiddenVisibilities != null) {
            for (Visibility v : this.getHiddenVisibilities()) {
                if (!authorizations.canRead(v)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValue(Value value) {
        this.value = value;
    }

    @Override
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public void addHiddenVisibility(Visibility visibility) {
        if (this.hiddenVisibilities == null) {
            this.hiddenVisibilities = new HashSet<Visibility>();
        }
        this.hiddenVisibilities.add(visibility);
    }

    @Override
    public void removeHiddenVisibility(Visibility visibility) {
        if (this.hiddenVisibilities == null) {
            this.hiddenVisibilities = new HashSet<Visibility>();
        }
        this.hiddenVisibilities.remove(visibility);
    }

    @Override
    protected void updateMetadata(Property property) {
        ArrayList<Metadata.Entry> entries = new ArrayList<Metadata.Entry>(property.getMetadata().entrySet());
        this.metadata.clear();
        for (Metadata.Entry metadataEntry : entries) {
            this.metadata.add(metadataEntry.getKey(), metadataEntry.getValue(), metadataEntry.getVisibility());
        }
    }
}

