/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.property;

import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.PropertyDeleteMutation;
import com.mware.ge.mutation.PropertySoftDeleteMutation;

public class PropertyDescriptor {
    private final String key;
    private final String name;
    private final Visibility visibility;

    public PropertyDescriptor(String key, String name, Visibility visibility) {
        this.key = key;
        this.name = name;
        this.visibility = visibility;
    }

    public static PropertyDescriptor from(String key, String name, Visibility visibility) {
        return new PropertyDescriptor(key, name, visibility);
    }

    public static PropertyDescriptor fromProperty(Property p) {
        return new PropertyDescriptor(p.getKey(), p.getName(), p.getVisibility());
    }

    public static PropertyDescriptor fromPropertyDeleteMutation(PropertyDeleteMutation p) {
        return new PropertyDescriptor(p.getKey(), p.getName(), p.getVisibility());
    }

    public static PropertyDescriptor fromPropertySoftDeleteMutation(PropertySoftDeleteMutation p) {
        return new PropertyDescriptor(p.getKey(), p.getName(), p.getVisibility());
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public String toString() {
        return "PropertyDescriptor{key='" + this.key + '\'' + ", name='" + this.name + '\'' + ", visibility=" + this.visibility + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyDescriptor that = (PropertyDescriptor)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.visibility != null ? this.visibility.equals(that.visibility) : that.visibility == null;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.visibility != null ? this.visibility.hashCode() : 0);
        return result;
    }
}

