/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.query;

import com.mware.ge.ElementType;
import com.mware.ge.GeException;
import com.mware.ge.Property;
import com.mware.ge.PropertyDefinition;
import com.mware.ge.Range;
import com.mware.ge.TextIndexHint;
import com.mware.ge.query.Predicate;
import com.mware.ge.util.ObjectUtils;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import java.util.Collection;

public enum Compare implements Predicate
{
    EQUAL,
    NOT_EQUAL,
    GREATER_THAN,
    GREATER_THAN_EQUAL,
    LESS_THAN,
    LESS_THAN_EQUAL,
    STARTS_WITH,
    ENDS_WITH,
    RANGE;


    @Override
    public boolean evaluate(Iterable<Property> properties, Object second, Collection<PropertyDefinition> propertyDefinitions) {
        boolean foundProperties = false;
        for (Property property : properties) {
            foundProperties = true;
            PropertyDefinition propertyDefinition = PropertyDefinition.findPropertyDefinition(propertyDefinitions, property.getName());
            if (!this.evaluate(property, second, propertyDefinition)) continue;
            return true;
        }
        return !foundProperties && this.equals(NOT_EQUAL);
    }

    @Override
    public void validate(PropertyDefinition propertyDefinition) {
    }

    @Override
    public boolean evaluate(Object first, Object second, PropertyDefinition propertyDefinition) {
        Compare comparePredicate = this;
        return Compare.evaluate(first, comparePredicate, second, propertyDefinition);
    }

    private boolean evaluate(Property property, Object second, PropertyDefinition propertyDefinition) {
        Value first = property.getValue();
        Compare comparePredicate = this;
        return Compare.evaluate(first, comparePredicate, second, propertyDefinition);
    }

    static boolean evaluate(Object first, Compare comparePredicate, Object second, PropertyDefinition propertyDefinition) {
        if (first instanceof ElementType) {
            first = ((ElementType)((Object)first)).name();
        }
        if (second instanceof ElementType) {
            second = ((ElementType)((Object)second)).name();
        }
        switch (comparePredicate) {
            case EQUAL: {
                if (null == first) {
                    return second == null;
                }
                if (propertyDefinition != null && propertyDefinition.getTextIndexHints().size() > 0 && !propertyDefinition.getTextIndexHints().contains((Object)TextIndexHint.EXACT_MATCH)) {
                    return false;
                }
                return ObjectUtils.compare(first, second) == 0;
            }
            case NOT_EQUAL: {
                if (null == first) {
                    return second != null;
                }
                return ObjectUtils.compare(first, second) != 0;
            }
            case GREATER_THAN: {
                if (null == first || second == null) {
                    return false;
                }
                return ObjectUtils.compare(first, second) >= 1;
            }
            case LESS_THAN: {
                if (null == first || second == null) {
                    return false;
                }
                return ObjectUtils.compare(first, second) <= -1;
            }
            case GREATER_THAN_EQUAL: {
                if (null == first || second == null) {
                    return false;
                }
                return ObjectUtils.compare(first, second) >= 0;
            }
            case LESS_THAN_EQUAL: {
                if (null == first || second == null) {
                    return false;
                }
                return ObjectUtils.compare(first, second) <= 0;
            }
            case STARTS_WITH: {
                if (!(second instanceof TextValue)) {
                    throw new GeException("STARTS_WITH may only be used to query String values");
                }
                if (null == first) {
                    return second == null;
                }
                if (propertyDefinition != null && propertyDefinition.getTextIndexHints().size() > 0 && !propertyDefinition.getTextIndexHints().contains((Object)TextIndexHint.EXACT_MATCH)) {
                    return false;
                }
                return ((TextValue)first).startsWith((TextValue)second);
            }
            case ENDS_WITH: {
                if (!(second instanceof TextValue)) {
                    throw new GeException("ENDS_WITH may only be used to query String values");
                }
                if (null == first) {
                    return second == null;
                }
                if (propertyDefinition != null && propertyDefinition.getTextIndexHints().size() > 0 && !propertyDefinition.getTextIndexHints().contains((Object)TextIndexHint.EXACT_MATCH)) {
                    return false;
                }
                return ((TextValue)first).endsWith((TextValue)second);
            }
            case RANGE: {
                if (first instanceof Range) {
                    return ((Range)first).isInRange(second);
                }
                if (second instanceof Range) {
                    return ((Range)second).isInRange(first);
                }
                throw new IllegalArgumentException("Invalid range values: " + first + ", " + second);
            }
        }
        throw new IllegalArgumentException("Invalid compare: " + comparePredicate);
    }

    private static int compare(Object first, Object second) {
        if (first instanceof StreamingPropertyValue && TextValue.class.isAssignableFrom(((StreamingPropertyValue)first).getValueType())) {
            first = ((StreamingPropertyValue)first).readToString();
        }
        if (second instanceof StreamingPropertyValue && TextValue.class.isAssignableFrom(((StreamingPropertyValue)second).getValueType())) {
            second = ((StreamingPropertyValue)second).readToString();
        }
        if (first instanceof String) {
            first = ((String)first).toLowerCase();
        }
        if (second instanceof String) {
            second = ((String)second).toLowerCase();
        }
        if (first instanceof Long && second instanceof Long) {
            long firstLong = (Long)first;
            long secondLong = (Long)second;
            return Long.compare(firstLong, secondLong);
        }
        if (first instanceof Integer && second instanceof Integer) {
            int firstInt = (Integer)first;
            int secondInt = (Integer)second;
            return Integer.compare(firstInt, secondInt);
        }
        if (first instanceof Number && second instanceof Number) {
            double firstDouble = ((Number)first).doubleValue();
            double secondDouble = ((Number)second).doubleValue();
            return Double.compare(firstDouble, secondDouble);
        }
        if (first instanceof Number && second instanceof String) {
            try {
                double firstDouble = ((Number)first).doubleValue();
                double secondDouble = Double.parseDouble(second.toString());
                return Double.compare(firstDouble, secondDouble);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        if (first instanceof String && second instanceof Number) {
            try {
                double firstDouble = Double.parseDouble(first.toString());
                double secondDouble = ((Number)second).doubleValue();
                return Double.compare(firstDouble, secondDouble);
            }
            catch (NumberFormatException e) {
                return 1;
            }
        }
        if (first instanceof Comparable) {
            return ((Comparable)first).compareTo(second);
        }
        if (second instanceof Comparable) {
            return ((Comparable)second).compareTo(first);
        }
        return first.equals(second) ? 0 : 1;
    }
}

