/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.query;

import com.mware.ge.GeException;
import com.mware.ge.Property;
import com.mware.ge.PropertyDefinition;
import com.mware.ge.query.Compare;
import com.mware.ge.query.Predicate;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.ArrayValue;
import java.util.Collection;

public enum Contains implements Predicate
{
    IN,
    NOT_IN;


    @Override
    public boolean evaluate(Iterable<Property> properties, Object second, Collection<PropertyDefinition> propertyDefinitions) {
        if (IterableUtils.count(properties) == 0 && this == NOT_IN) {
            return true;
        }
        for (Property property : properties) {
            PropertyDefinition propertyDefinition = PropertyDefinition.findPropertyDefinition(propertyDefinitions, property.getName());
            if (!this.evaluate(property.getValue(), second, propertyDefinition)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validate(PropertyDefinition propertyDefinition) {
    }

    @Override
    public boolean evaluate(Object first, Object second, PropertyDefinition propertyDefinition) {
        if (second instanceof Iterable) {
            switch (this) {
                case IN: {
                    return this.evaluateInIterable(first, (Iterable)second, propertyDefinition);
                }
                case NOT_IN: {
                    return !this.evaluateInIterable(first, (Iterable)second, propertyDefinition);
                }
            }
            throw new GeException("Not implemented: " + this);
        }
        if (second instanceof ArrayValue) {
            second = ((ArrayValue)second).asObjectCopy();
        }
        if (second.getClass().isArray()) {
            switch (this) {
                case IN: {
                    return this.evaluateInIterable(first, (Object[])second, propertyDefinition);
                }
                case NOT_IN: {
                    return !this.evaluateInIterable(first, (Object[])second, propertyDefinition);
                }
            }
            throw new GeException("Not implemented: " + this);
        }
        switch (this) {
            case IN: {
                return this.evaluateInIterable(first, new Object[]{second}, propertyDefinition);
            }
            case NOT_IN: {
                return !this.evaluateInIterable(first, new Object[]{second}, propertyDefinition);
            }
        }
        throw new GeException("Not implemented: " + this);
    }

    private boolean evaluateInIterable(Object first, Iterable second, PropertyDefinition propertyDefinition) {
        for (Object o : second) {
            if (!Compare.evaluate(first, Compare.EQUAL, o, propertyDefinition)) continue;
            return true;
        }
        return false;
    }

    private boolean evaluateInIterable(Object first, Object[] second, PropertyDefinition propertyDefinition) {
        for (Object o : second) {
            if (!Compare.evaluate(first, Compare.EQUAL, o, propertyDefinition)) continue;
            return true;
        }
        return false;
    }
}

