/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.query;

import com.mware.ge.Authorizations;
import com.mware.ge.Edge;
import com.mware.ge.Element;
import com.mware.ge.ElementType;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.GeObject;
import com.mware.ge.Graph;
import com.mware.ge.Vertex;
import com.mware.ge.query.DefaultGraphQueryIterableWithAggregations;
import com.mware.ge.query.GraphQueryBase;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.query.aggregations.Aggregation;
import com.mware.ge.util.JoinIterable;
import java.util.Collection;

public class DefaultGraphQuery
extends GraphQueryBase {
    public DefaultGraphQuery(Graph graph, String queryString, Authorizations authorizations) {
        super(graph, queryString, authorizations);
    }

    @Override
    public QueryResultsIterable<Vertex> vertices(FetchHints fetchHints) {
        return new DefaultGraphQueryIterableWithAggregations<Vertex>(this.getParameters(), this.getIterableFromElementType(ElementType.VERTEX, fetchHints), true, true, true, (Collection<Aggregation>)this.getAggregations());
    }

    @Override
    public QueryResultsIterable<Edge> edges(FetchHints fetchHints) {
        return new DefaultGraphQueryIterableWithAggregations<Edge>(this.getParameters(), this.getIterableFromElementType(ElementType.EDGE, fetchHints), true, true, true, (Collection<Aggregation>)this.getAggregations());
    }

    protected <T extends Element> Iterable<T> getIterableFromElementType(ElementType elementType, FetchHints fetchHints) throws GeException {
        switch (elementType) {
            case VERTEX: {
                return this.getGraph().getVertices(fetchHints, this.getParameters().getAuthorizations());
            }
            case EDGE: {
                return this.getGraph().getEdges(fetchHints, this.getParameters().getAuthorizations());
            }
        }
        throw new GeException("Unexpected element type: " + (Object)((Object)elementType));
    }

    @Override
    protected QueryResultsIterable<? extends GeObject> extendedData(FetchHints extendedDataFetchHints) {
        FetchHints extendedDataTableNamesFetchHints = FetchHints.builder().setIncludeExtendedDataTableNames(true).setIncludeAllProperties(true).build();
        return this.extendedData(extendedDataFetchHints, new JoinIterable(this.getIterableFromElementType(ElementType.VERTEX, extendedDataTableNamesFetchHints), this.getIterableFromElementType(ElementType.EDGE, extendedDataTableNamesFetchHints)));
    }

    @Override
    public boolean isAggregationSupported(Aggregation aggregation) {
        if (DefaultGraphQueryIterableWithAggregations.isAggregationSupported(aggregation)) {
            return true;
        }
        return super.isAggregationSupported(aggregation);
    }
}

